// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a file system info.
 */
@Fluent
public final class MicrosoftGraphFileSystemInfo implements JsonSerializable<MicrosoftGraphFileSystemInfo> {
    /*
     * The UTC date and time the file was created on a client.
     */
    private OffsetDateTime createdDateTime;

    /*
     * The UTC date and time the file was last accessed. Available for the recent file list only.
     */
    private OffsetDateTime lastAccessedDateTime;

    /*
     * The UTC date and time the file was last modified on a client.
     */
    private OffsetDateTime lastModifiedDateTime;

    /*
     * fileSystemInfo
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphFileSystemInfo class.
     */
    public MicrosoftGraphFileSystemInfo() {
    }

    /**
     * Get the createdDateTime property: The UTC date and time the file was created on a client.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: The UTC date and time the file was created on a client.
     * 
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphFileSystemInfo object itself.
     */
    public MicrosoftGraphFileSystemInfo withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the lastAccessedDateTime property: The UTC date and time the file was last accessed. Available for the recent
     * file list only.
     * 
     * @return the lastAccessedDateTime value.
     */
    public OffsetDateTime lastAccessedDateTime() {
        return this.lastAccessedDateTime;
    }

    /**
     * Set the lastAccessedDateTime property: The UTC date and time the file was last accessed. Available for the recent
     * file list only.
     * 
     * @param lastAccessedDateTime the lastAccessedDateTime value to set.
     * @return the MicrosoftGraphFileSystemInfo object itself.
     */
    public MicrosoftGraphFileSystemInfo withLastAccessedDateTime(OffsetDateTime lastAccessedDateTime) {
        this.lastAccessedDateTime = lastAccessedDateTime;
        return this;
    }

    /**
     * Get the lastModifiedDateTime property: The UTC date and time the file was last modified on a client.
     * 
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Set the lastModifiedDateTime property: The UTC date and time the file was last modified on a client.
     * 
     * @param lastModifiedDateTime the lastModifiedDateTime value to set.
     * @return the MicrosoftGraphFileSystemInfo object itself.
     */
    public MicrosoftGraphFileSystemInfo withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    /**
     * Get the additionalProperties property: fileSystemInfo.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: fileSystemInfo.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphFileSystemInfo object itself.
     */
    public MicrosoftGraphFileSystemInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdDateTime",
            this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastAccessedDateTime",
            this.lastAccessedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastAccessedDateTime));
        jsonWriter.writeStringField("lastModifiedDateTime",
            this.lastModifiedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphFileSystemInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphFileSystemInfo if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphFileSystemInfo.
     */
    public static MicrosoftGraphFileSystemInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphFileSystemInfo deserializedMicrosoftGraphFileSystemInfo = new MicrosoftGraphFileSystemInfo();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphFileSystemInfo.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastAccessedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphFileSystemInfo.lastAccessedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphFileSystemInfo.lastModifiedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphFileSystemInfo.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphFileSystemInfo;
        });
    }
}
