// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a file.
 */
@Fluent
public final class MicrosoftGraphFile implements JsonSerializable<MicrosoftGraphFile> {
    /*
     * hashes
     */
    private MicrosoftGraphHashes hashes;

    /*
     * The MIME type for the file. This is determined by logic on the server and might not be the value provided when
     * the file was uploaded. Read-only.
     */
    private String mimeType;

    /*
     * The processingMetadata property.
     */
    private Boolean processingMetadata;

    /*
     * file
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphFile class.
     */
    public MicrosoftGraphFile() {
    }

    /**
     * Get the hashes property: hashes.
     * 
     * @return the hashes value.
     */
    public MicrosoftGraphHashes hashes() {
        return this.hashes;
    }

    /**
     * Set the hashes property: hashes.
     * 
     * @param hashes the hashes value to set.
     * @return the MicrosoftGraphFile object itself.
     */
    public MicrosoftGraphFile withHashes(MicrosoftGraphHashes hashes) {
        this.hashes = hashes;
        return this;
    }

    /**
     * Get the mimeType property: The MIME type for the file. This is determined by logic on the server and might not be
     * the value provided when the file was uploaded. Read-only.
     * 
     * @return the mimeType value.
     */
    public String mimeType() {
        return this.mimeType;
    }

    /**
     * Set the mimeType property: The MIME type for the file. This is determined by logic on the server and might not be
     * the value provided when the file was uploaded. Read-only.
     * 
     * @param mimeType the mimeType value to set.
     * @return the MicrosoftGraphFile object itself.
     */
    public MicrosoftGraphFile withMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    /**
     * Get the processingMetadata property: The processingMetadata property.
     * 
     * @return the processingMetadata value.
     */
    public Boolean processingMetadata() {
        return this.processingMetadata;
    }

    /**
     * Set the processingMetadata property: The processingMetadata property.
     * 
     * @param processingMetadata the processingMetadata value to set.
     * @return the MicrosoftGraphFile object itself.
     */
    public MicrosoftGraphFile withProcessingMetadata(Boolean processingMetadata) {
        this.processingMetadata = processingMetadata;
        return this;
    }

    /**
     * Get the additionalProperties property: file.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: file.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphFile object itself.
     */
    public MicrosoftGraphFile withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (hashes() != null) {
            hashes().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("hashes", this.hashes);
        jsonWriter.writeStringField("mimeType", this.mimeType);
        jsonWriter.writeBooleanField("processingMetadata", this.processingMetadata);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphFile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphFile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphFile.
     */
    public static MicrosoftGraphFile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphFile deserializedMicrosoftGraphFile = new MicrosoftGraphFile();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("hashes".equals(fieldName)) {
                    deserializedMicrosoftGraphFile.hashes = MicrosoftGraphHashes.fromJson(reader);
                } else if ("mimeType".equals(fieldName)) {
                    deserializedMicrosoftGraphFile.mimeType = reader.getString();
                } else if ("processingMetadata".equals(fieldName)) {
                    deserializedMicrosoftGraphFile.processingMetadata = reader.getNullable(JsonReader::getBoolean);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphFile.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphFile;
        });
    }
}
