// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an external link.
 */
@Fluent
public final class MicrosoftGraphExternalLink implements JsonSerializable<MicrosoftGraphExternalLink> {
    /*
     * The url of the link.
     */
    private String href;

    /*
     * externalLink
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphExternalLink class.
     */
    public MicrosoftGraphExternalLink() {
    }

    /**
     * Get the href property: The url of the link.
     * 
     * @return the href value.
     */
    public String href() {
        return this.href;
    }

    /**
     * Set the href property: The url of the link.
     * 
     * @param href the href value to set.
     * @return the MicrosoftGraphExternalLink object itself.
     */
    public MicrosoftGraphExternalLink withHref(String href) {
        this.href = href;
        return this;
    }

    /**
     * Get the additionalProperties property: externalLink.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: externalLink.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphExternalLink object itself.
     */
    public MicrosoftGraphExternalLink withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("href", this.href);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphExternalLink from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphExternalLink if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphExternalLink.
     */
    public static MicrosoftGraphExternalLink fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphExternalLink deserializedMicrosoftGraphExternalLink = new MicrosoftGraphExternalLink();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("href".equals(fieldName)) {
                    deserializedMicrosoftGraphExternalLink.href = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphExternalLink.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphExternalLink;
        });
    }
}
