// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an endpoint.
 * <p>
 * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
 * entity types.
 */
@Fluent
public final class MicrosoftGraphEndpoint extends MicrosoftGraphDirectoryObjectInner {
    /*
     * Describes the capability that is associated with this resource. (e.g. Messages, Conversations, etc.) Not
     * nullable. Read-only.
     */
    private String capability;

    /*
     * Application id of the publishing underlying service. Not nullable. Read-only.
     */
    private String providerId;

    /*
     * Name of the publishing underlying service. Read-only.
     */
    private String providerName;

    /*
     * For Microsoft 365 groups, this is set to a well-known name for the resource (e.g. Yammer.FeedURL etc.). Not
     * nullable. Read-only.
     */
    private String providerResourceId;

    /*
     * URL of the published resource. Not nullable. Read-only.
     */
    private String uri;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
     * entity types.
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphEndpoint class.
     */
    public MicrosoftGraphEndpoint() {
    }

    /**
     * Get the capability property: Describes the capability that is associated with this resource. (e.g. Messages,
     * Conversations, etc.) Not nullable. Read-only.
     * 
     * @return the capability value.
     */
    public String capability() {
        return this.capability;
    }

    /**
     * Set the capability property: Describes the capability that is associated with this resource. (e.g. Messages,
     * Conversations, etc.) Not nullable. Read-only.
     * 
     * @param capability the capability value to set.
     * @return the MicrosoftGraphEndpoint object itself.
     */
    public MicrosoftGraphEndpoint withCapability(String capability) {
        this.capability = capability;
        return this;
    }

    /**
     * Get the providerId property: Application id of the publishing underlying service. Not nullable. Read-only.
     * 
     * @return the providerId value.
     */
    public String providerId() {
        return this.providerId;
    }

    /**
     * Set the providerId property: Application id of the publishing underlying service. Not nullable. Read-only.
     * 
     * @param providerId the providerId value to set.
     * @return the MicrosoftGraphEndpoint object itself.
     */
    public MicrosoftGraphEndpoint withProviderId(String providerId) {
        this.providerId = providerId;
        return this;
    }

    /**
     * Get the providerName property: Name of the publishing underlying service. Read-only.
     * 
     * @return the providerName value.
     */
    public String providerName() {
        return this.providerName;
    }

    /**
     * Set the providerName property: Name of the publishing underlying service. Read-only.
     * 
     * @param providerName the providerName value to set.
     * @return the MicrosoftGraphEndpoint object itself.
     */
    public MicrosoftGraphEndpoint withProviderName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    /**
     * Get the providerResourceId property: For Microsoft 365 groups, this is set to a well-known name for the resource
     * (e.g. Yammer.FeedURL etc.). Not nullable. Read-only.
     * 
     * @return the providerResourceId value.
     */
    public String providerResourceId() {
        return this.providerResourceId;
    }

    /**
     * Set the providerResourceId property: For Microsoft 365 groups, this is set to a well-known name for the resource
     * (e.g. Yammer.FeedURL etc.). Not nullable. Read-only.
     * 
     * @param providerResourceId the providerResourceId value to set.
     * @return the MicrosoftGraphEndpoint object itself.
     */
    public MicrosoftGraphEndpoint withProviderResourceId(String providerResourceId) {
        this.providerResourceId = providerResourceId;
        return this;
    }

    /**
     * Get the uri property: URL of the published resource. Not nullable. Read-only.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: URL of the published resource. Not nullable. Read-only.
     * 
     * @param uri the uri value to set.
     * @return the MicrosoftGraphEndpoint object itself.
     */
    public MicrosoftGraphEndpoint withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphEndpoint object itself.
     */
    public MicrosoftGraphEndpoint withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphEndpoint withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphEndpoint withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("deletedDateTime",
            deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(deletedDateTime()));
        jsonWriter.writeStringField("capability", this.capability);
        jsonWriter.writeStringField("providerId", this.providerId);
        jsonWriter.writeStringField("providerName", this.providerName);
        jsonWriter.writeStringField("providerResourceId", this.providerResourceId);
        jsonWriter.writeStringField("uri", this.uri);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphEndpoint from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphEndpoint if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphEndpoint.
     */
    public static MicrosoftGraphEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphEndpoint deserializedMicrosoftGraphEndpoint = new MicrosoftGraphEndpoint();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.withId(reader.getString());
                } else if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.withDeletedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("capability".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.capability = reader.getString();
                } else if ("providerId".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.providerId = reader.getString();
                } else if ("providerName".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.providerName = reader.getString();
                } else if ("providerResourceId".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.providerResourceId = reader.getString();
                } else if ("uri".equals(fieldName)) {
                    deserializedMicrosoftGraphEndpoint.uri = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphEndpoint.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphEndpoint;
        });
    }
}
