// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an employee org data.
 */
@Fluent
public final class MicrosoftGraphEmployeeOrgData implements JsonSerializable<MicrosoftGraphEmployeeOrgData> {
    /*
     * The cost center associated with the user. Returned only on $select. Supports $filter.
     */
    private String costCenter;

    /*
     * The name of the division in which the user works. Returned only on $select. Supports $filter.
     */
    private String division;

    /*
     * employeeOrgData
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphEmployeeOrgData class.
     */
    public MicrosoftGraphEmployeeOrgData() {
    }

    /**
     * Get the costCenter property: The cost center associated with the user. Returned only on $select. Supports
     * $filter.
     * 
     * @return the costCenter value.
     */
    public String costCenter() {
        return this.costCenter;
    }

    /**
     * Set the costCenter property: The cost center associated with the user. Returned only on $select. Supports
     * $filter.
     * 
     * @param costCenter the costCenter value to set.
     * @return the MicrosoftGraphEmployeeOrgData object itself.
     */
    public MicrosoftGraphEmployeeOrgData withCostCenter(String costCenter) {
        this.costCenter = costCenter;
        return this;
    }

    /**
     * Get the division property: The name of the division in which the user works. Returned only on $select. Supports
     * $filter.
     * 
     * @return the division value.
     */
    public String division() {
        return this.division;
    }

    /**
     * Set the division property: The name of the division in which the user works. Returned only on $select. Supports
     * $filter.
     * 
     * @param division the division value to set.
     * @return the MicrosoftGraphEmployeeOrgData object itself.
     */
    public MicrosoftGraphEmployeeOrgData withDivision(String division) {
        this.division = division;
        return this;
    }

    /**
     * Get the additionalProperties property: employeeOrgData.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: employeeOrgData.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphEmployeeOrgData object itself.
     */
    public MicrosoftGraphEmployeeOrgData withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("costCenter", this.costCenter);
        jsonWriter.writeStringField("division", this.division);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphEmployeeOrgData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphEmployeeOrgData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphEmployeeOrgData.
     */
    public static MicrosoftGraphEmployeeOrgData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphEmployeeOrgData deserializedMicrosoftGraphEmployeeOrgData
                = new MicrosoftGraphEmployeeOrgData();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("costCenter".equals(fieldName)) {
                    deserializedMicrosoftGraphEmployeeOrgData.costCenter = reader.getString();
                } else if ("division".equals(fieldName)) {
                    deserializedMicrosoftGraphEmployeeOrgData.division = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphEmployeeOrgData.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphEmployeeOrgData;
        });
    }
}
