// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Represents a drive item version.
 */
@Fluent
public final class MicrosoftGraphDriveItemVersion extends MicrosoftGraphBaseItemVersion {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    /*
     * The content stream for this version of the item.
     */
    private Base64Url content;

    /*
     * Indicates the size of the content stream for this version of the item.
     */
    private Long size;

    /*
     * driveItemVersion
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphDriveItemVersion class.
     */
    public MicrosoftGraphDriveItemVersion() {
    }

    /**
     * Get the content property: The content stream for this version of the item.
     * 
     * @return the content value.
     */
    public byte[] content() {
        if (this.content == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.content.decodedBytes();
    }

    /**
     * Set the content property: The content stream for this version of the item.
     * 
     * @param content the content value to set.
     * @return the MicrosoftGraphDriveItemVersion object itself.
     */
    public MicrosoftGraphDriveItemVersion withContent(byte[] content) {
        if (content == null) {
            this.content = null;
        } else {
            this.content = Base64Url.encode(CoreUtils.clone(content));
        }
        return this;
    }

    /**
     * Get the size property: Indicates the size of the content stream for this version of the item.
     * 
     * @return the size value.
     */
    public Long size() {
        return this.size;
    }

    /**
     * Set the size property: Indicates the size of the content stream for this version of the item.
     * 
     * @param size the size value to set.
     * @return the MicrosoftGraphDriveItemVersion object itself.
     */
    public MicrosoftGraphDriveItemVersion withSize(Long size) {
        this.size = size;
        return this;
    }

    /**
     * Get the additionalProperties property: driveItemVersion.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: driveItemVersion.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDriveItemVersion object itself.
     */
    public MicrosoftGraphDriveItemVersion withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDriveItemVersion withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDriveItemVersion withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDriveItemVersion withPublication(MicrosoftGraphPublicationFacet publication) {
        super.withPublication(publication);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDriveItemVersion withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("lastModifiedBy", lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime",
            lastModifiedDateTime() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(lastModifiedDateTime()));
        jsonWriter.writeJsonField("publication", publication());
        jsonWriter.writeStringField("content", Objects.toString(this.content, null));
        jsonWriter.writeNumberField("size", this.size);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphDriveItemVersion from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphDriveItemVersion if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphDriveItemVersion.
     */
    public static MicrosoftGraphDriveItemVersion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphDriveItemVersion deserializedMicrosoftGraphDriveItemVersion
                = new MicrosoftGraphDriveItemVersion();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphDriveItemVersion.withId(reader.getString());
                } else if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphDriveItemVersion
                        .withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDriveItemVersion.withLastModifiedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("publication".equals(fieldName)) {
                    deserializedMicrosoftGraphDriveItemVersion
                        .withPublication(MicrosoftGraphPublicationFacet.fromJson(reader));
                } else if ("content".equals(fieldName)) {
                    deserializedMicrosoftGraphDriveItemVersion.content
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("size".equals(fieldName)) {
                    deserializedMicrosoftGraphDriveItemVersion.size = reader.getNullable(JsonReader::getLong);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphDriveItemVersion.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphDriveItemVersion;
        });
    }
}
