// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a device compliance policy state.
 * <p>
 * Device compliance policy State for a given device.
 */
@Fluent
public final class MicrosoftGraphDeviceCompliancePolicyState extends MicrosoftGraphEntity {
    /*
     * The name of the policy for this policyBase
     */
    private String displayName;

    /*
     * policyPlatformType
     */
    private MicrosoftGraphPolicyPlatformType platformType;

    /*
     * Count of how many setting a policy holds
     */
    private Integer settingCount;

    /*
     * The settingStates property.
     */
    private List<MicrosoftGraphDeviceCompliancePolicySettingState> settingStates;

    /*
     * complianceStatus
     */
    private MicrosoftGraphComplianceStatus state;

    /*
     * The version of the policy
     */
    private Integer version;

    /*
     * Device Compliance Policy State for a given device.
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphDeviceCompliancePolicyState class.
     */
    public MicrosoftGraphDeviceCompliancePolicyState() {
    }

    /**
     * Get the displayName property: The name of the policy for this policyBase.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The name of the policy for this policyBase.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphDeviceCompliancePolicyState object itself.
     */
    public MicrosoftGraphDeviceCompliancePolicyState withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the platformType property: policyPlatformType.
     * 
     * @return the platformType value.
     */
    public MicrosoftGraphPolicyPlatformType platformType() {
        return this.platformType;
    }

    /**
     * Set the platformType property: policyPlatformType.
     * 
     * @param platformType the platformType value to set.
     * @return the MicrosoftGraphDeviceCompliancePolicyState object itself.
     */
    public MicrosoftGraphDeviceCompliancePolicyState withPlatformType(MicrosoftGraphPolicyPlatformType platformType) {
        this.platformType = platformType;
        return this;
    }

    /**
     * Get the settingCount property: Count of how many setting a policy holds.
     * 
     * @return the settingCount value.
     */
    public Integer settingCount() {
        return this.settingCount;
    }

    /**
     * Set the settingCount property: Count of how many setting a policy holds.
     * 
     * @param settingCount the settingCount value to set.
     * @return the MicrosoftGraphDeviceCompliancePolicyState object itself.
     */
    public MicrosoftGraphDeviceCompliancePolicyState withSettingCount(Integer settingCount) {
        this.settingCount = settingCount;
        return this;
    }

    /**
     * Get the settingStates property: The settingStates property.
     * 
     * @return the settingStates value.
     */
    public List<MicrosoftGraphDeviceCompliancePolicySettingState> settingStates() {
        return this.settingStates;
    }

    /**
     * Set the settingStates property: The settingStates property.
     * 
     * @param settingStates the settingStates value to set.
     * @return the MicrosoftGraphDeviceCompliancePolicyState object itself.
     */
    public MicrosoftGraphDeviceCompliancePolicyState
        withSettingStates(List<MicrosoftGraphDeviceCompliancePolicySettingState> settingStates) {
        this.settingStates = settingStates;
        return this;
    }

    /**
     * Get the state property: complianceStatus.
     * 
     * @return the state value.
     */
    public MicrosoftGraphComplianceStatus state() {
        return this.state;
    }

    /**
     * Set the state property: complianceStatus.
     * 
     * @param state the state value to set.
     * @return the MicrosoftGraphDeviceCompliancePolicyState object itself.
     */
    public MicrosoftGraphDeviceCompliancePolicyState withState(MicrosoftGraphComplianceStatus state) {
        this.state = state;
        return this;
    }

    /**
     * Get the version property: The version of the policy.
     * 
     * @return the version value.
     */
    public Integer version() {
        return this.version;
    }

    /**
     * Set the version property: The version of the policy.
     * 
     * @param version the version value to set.
     * @return the MicrosoftGraphDeviceCompliancePolicyState object itself.
     */
    public MicrosoftGraphDeviceCompliancePolicyState withVersion(Integer version) {
        this.version = version;
        return this;
    }

    /**
     * Get the additionalProperties property: Device Compliance Policy State for a given device.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Device Compliance Policy State for a given device.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDeviceCompliancePolicyState object itself.
     */
    public MicrosoftGraphDeviceCompliancePolicyState
        withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDeviceCompliancePolicyState withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (settingStates() != null) {
            settingStates().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("platformType", this.platformType == null ? null : this.platformType.toString());
        jsonWriter.writeNumberField("settingCount", this.settingCount);
        jsonWriter.writeArrayField("settingStates", this.settingStates, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeNumberField("version", this.version);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphDeviceCompliancePolicyState from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphDeviceCompliancePolicyState if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphDeviceCompliancePolicyState.
     */
    public static MicrosoftGraphDeviceCompliancePolicyState fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphDeviceCompliancePolicyState deserializedMicrosoftGraphDeviceCompliancePolicyState
                = new MicrosoftGraphDeviceCompliancePolicyState();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.withId(reader.getString());
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.displayName = reader.getString();
                } else if ("platformType".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.platformType
                        = MicrosoftGraphPolicyPlatformType.fromString(reader.getString());
                } else if ("settingCount".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.settingCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("settingStates".equals(fieldName)) {
                    List<MicrosoftGraphDeviceCompliancePolicySettingState> settingStates = reader
                        .readArray(reader1 -> MicrosoftGraphDeviceCompliancePolicySettingState.fromJson(reader1));
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.settingStates = settingStates;
                } else if ("state".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.state
                        = MicrosoftGraphComplianceStatus.fromString(reader.getString());
                } else if ("version".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.version
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphDeviceCompliancePolicyState.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphDeviceCompliancePolicyState;
        });
    }
}
