// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a date time time zone.
 */
@Fluent
public final class MicrosoftGraphDateTimeZone implements JsonSerializable<MicrosoftGraphDateTimeZone> {
    /*
     * A single point of time in a combined date and time representation ({date}T{time}; for example,
     * 2017-08-29T04:00:00.0000000).
     */
    private String dateTime;

    /*
     * Represents a time zone, for example, 'Pacific Standard Time'. See below for more possible values.
     */
    private String timeZone;

    /*
     * dateTimeTimeZone
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphDateTimeZone class.
     */
    public MicrosoftGraphDateTimeZone() {
    }

    /**
     * Get the dateTime property: A single point of time in a combined date and time representation ({date}T{time}; for
     * example, 2017-08-29T04:00:00.0000000).
     * 
     * @return the dateTime value.
     */
    public String dateTime() {
        return this.dateTime;
    }

    /**
     * Set the dateTime property: A single point of time in a combined date and time representation ({date}T{time}; for
     * example, 2017-08-29T04:00:00.0000000).
     * 
     * @param dateTime the dateTime value to set.
     * @return the MicrosoftGraphDateTimeZone object itself.
     */
    public MicrosoftGraphDateTimeZone withDateTime(String dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    /**
     * Get the timeZone property: Represents a time zone, for example, 'Pacific Standard Time'. See below for more
     * possible values.
     * 
     * @return the timeZone value.
     */
    public String timeZone() {
        return this.timeZone;
    }

    /**
     * Set the timeZone property: Represents a time zone, for example, 'Pacific Standard Time'. See below for more
     * possible values.
     * 
     * @param timeZone the timeZone value to set.
     * @return the MicrosoftGraphDateTimeZone object itself.
     */
    public MicrosoftGraphDateTimeZone withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    /**
     * Get the additionalProperties property: dateTimeTimeZone.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: dateTimeTimeZone.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDateTimeZone object itself.
     */
    public MicrosoftGraphDateTimeZone withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dateTime", this.dateTime);
        jsonWriter.writeStringField("timeZone", this.timeZone);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphDateTimeZone from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphDateTimeZone if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphDateTimeZone.
     */
    public static MicrosoftGraphDateTimeZone fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphDateTimeZone deserializedMicrosoftGraphDateTimeZone = new MicrosoftGraphDateTimeZone();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDateTimeZone.dateTime = reader.getString();
                } else if ("timeZone".equals(fieldName)) {
                    deserializedMicrosoftGraphDateTimeZone.timeZone = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphDateTimeZone.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphDateTimeZone;
        });
    }
}
