// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a copy notebook model.
 */
@Fluent
public final class MicrosoftGraphCopyNotebookModel implements JsonSerializable<MicrosoftGraphCopyNotebookModel> {
    /*
     * The createdBy property.
     */
    private String createdBy;

    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet createdByIdentity;

    /*
     * The createdTime property.
     */
    private OffsetDateTime createdTime;

    /*
     * The id property.
     */
    private String id;

    /*
     * The isDefault property.
     */
    private Boolean isDefault;

    /*
     * The isShared property.
     */
    private Boolean isShared;

    /*
     * The lastModifiedBy property.
     */
    private String lastModifiedBy;

    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet lastModifiedByIdentity;

    /*
     * The lastModifiedTime property.
     */
    private OffsetDateTime lastModifiedTime;

    /*
     * notebookLinks
     */
    private MicrosoftGraphNotebookLinks links;

    /*
     * The name property.
     */
    private String name;

    /*
     * The sectionGroupsUrl property.
     */
    private String sectionGroupsUrl;

    /*
     * The sectionsUrl property.
     */
    private String sectionsUrl;

    /*
     * The self property.
     */
    private String self;

    /*
     * onenoteUserRole
     */
    private MicrosoftGraphOnenoteUserRole userRole;

    /*
     * CopyNotebookModel
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphCopyNotebookModel class.
     */
    public MicrosoftGraphCopyNotebookModel() {
    }

    /**
     * Get the createdBy property: The createdBy property.
     * 
     * @return the createdBy value.
     */
    public String createdBy() {
        return this.createdBy;
    }

    /**
     * Set the createdBy property: The createdBy property.
     * 
     * @param createdBy the createdBy value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * Get the createdByIdentity property: identitySet.
     * 
     * @return the createdByIdentity value.
     */
    public MicrosoftGraphIdentitySet createdByIdentity() {
        return this.createdByIdentity;
    }

    /**
     * Set the createdByIdentity property: identitySet.
     * 
     * @param createdByIdentity the createdByIdentity value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withCreatedByIdentity(MicrosoftGraphIdentitySet createdByIdentity) {
        this.createdByIdentity = createdByIdentity;
        return this;
    }

    /**
     * Get the createdTime property: The createdTime property.
     * 
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    /**
     * Set the createdTime property: The createdTime property.
     * 
     * @param createdTime the createdTime value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    /**
     * Get the id property: The id property.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The id property.
     * 
     * @param id the id value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the isDefault property: The isDefault property.
     * 
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Set the isDefault property: The isDefault property.
     * 
     * @param isDefault the isDefault value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    /**
     * Get the isShared property: The isShared property.
     * 
     * @return the isShared value.
     */
    public Boolean isShared() {
        return this.isShared;
    }

    /**
     * Set the isShared property: The isShared property.
     * 
     * @param isShared the isShared value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withIsShared(Boolean isShared) {
        this.isShared = isShared;
        return this;
    }

    /**
     * Get the lastModifiedBy property: The lastModifiedBy property.
     * 
     * @return the lastModifiedBy value.
     */
    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    /**
     * Set the lastModifiedBy property: The lastModifiedBy property.
     * 
     * @param lastModifiedBy the lastModifiedBy value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    /**
     * Get the lastModifiedByIdentity property: identitySet.
     * 
     * @return the lastModifiedByIdentity value.
     */
    public MicrosoftGraphIdentitySet lastModifiedByIdentity() {
        return this.lastModifiedByIdentity;
    }

    /**
     * Set the lastModifiedByIdentity property: identitySet.
     * 
     * @param lastModifiedByIdentity the lastModifiedByIdentity value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel
        withLastModifiedByIdentity(MicrosoftGraphIdentitySet lastModifiedByIdentity) {
        this.lastModifiedByIdentity = lastModifiedByIdentity;
        return this;
    }

    /**
     * Get the lastModifiedTime property: The lastModifiedTime property.
     * 
     * @return the lastModifiedTime value.
     */
    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Set the lastModifiedTime property: The lastModifiedTime property.
     * 
     * @param lastModifiedTime the lastModifiedTime value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    /**
     * Get the links property: notebookLinks.
     * 
     * @return the links value.
     */
    public MicrosoftGraphNotebookLinks links() {
        return this.links;
    }

    /**
     * Set the links property: notebookLinks.
     * 
     * @param links the links value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withLinks(MicrosoftGraphNotebookLinks links) {
        this.links = links;
        return this;
    }

    /**
     * Get the name property: The name property.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name property.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the sectionGroupsUrl property: The sectionGroupsUrl property.
     * 
     * @return the sectionGroupsUrl value.
     */
    public String sectionGroupsUrl() {
        return this.sectionGroupsUrl;
    }

    /**
     * Set the sectionGroupsUrl property: The sectionGroupsUrl property.
     * 
     * @param sectionGroupsUrl the sectionGroupsUrl value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withSectionGroupsUrl(String sectionGroupsUrl) {
        this.sectionGroupsUrl = sectionGroupsUrl;
        return this;
    }

    /**
     * Get the sectionsUrl property: The sectionsUrl property.
     * 
     * @return the sectionsUrl value.
     */
    public String sectionsUrl() {
        return this.sectionsUrl;
    }

    /**
     * Set the sectionsUrl property: The sectionsUrl property.
     * 
     * @param sectionsUrl the sectionsUrl value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withSectionsUrl(String sectionsUrl) {
        this.sectionsUrl = sectionsUrl;
        return this;
    }

    /**
     * Get the self property: The self property.
     * 
     * @return the self value.
     */
    public String self() {
        return this.self;
    }

    /**
     * Set the self property: The self property.
     * 
     * @param self the self value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withSelf(String self) {
        this.self = self;
        return this;
    }

    /**
     * Get the userRole property: onenoteUserRole.
     * 
     * @return the userRole value.
     */
    public MicrosoftGraphOnenoteUserRole userRole() {
        return this.userRole;
    }

    /**
     * Set the userRole property: onenoteUserRole.
     * 
     * @param userRole the userRole value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withUserRole(MicrosoftGraphOnenoteUserRole userRole) {
        this.userRole = userRole;
        return this;
    }

    /**
     * Get the additionalProperties property: CopyNotebookModel.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: CopyNotebookModel.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphCopyNotebookModel object itself.
     */
    public MicrosoftGraphCopyNotebookModel withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (createdByIdentity() != null) {
            createdByIdentity().validate();
        }
        if (lastModifiedByIdentity() != null) {
            lastModifiedByIdentity().validate();
        }
        if (links() != null) {
            links().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdBy", this.createdBy);
        jsonWriter.writeJsonField("createdByIdentity", this.createdByIdentity);
        jsonWriter.writeStringField("createdTime",
            this.createdTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdTime));
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeBooleanField("isShared", this.isShared);
        jsonWriter.writeStringField("lastModifiedBy", this.lastModifiedBy);
        jsonWriter.writeJsonField("lastModifiedByIdentity", this.lastModifiedByIdentity);
        jsonWriter.writeStringField("lastModifiedTime",
            this.lastModifiedTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeJsonField("links", this.links);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("sectionGroupsUrl", this.sectionGroupsUrl);
        jsonWriter.writeStringField("sectionsUrl", this.sectionsUrl);
        jsonWriter.writeStringField("self", this.self);
        jsonWriter.writeStringField("userRole", this.userRole == null ? null : this.userRole.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphCopyNotebookModel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphCopyNotebookModel if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphCopyNotebookModel.
     */
    public static MicrosoftGraphCopyNotebookModel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphCopyNotebookModel deserializedMicrosoftGraphCopyNotebookModel
                = new MicrosoftGraphCopyNotebookModel();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.createdBy = reader.getString();
                } else if ("createdByIdentity".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.createdByIdentity
                        = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("createdTime".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.createdTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.id = reader.getString();
                } else if ("isDefault".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.isDefault = reader.getNullable(JsonReader::getBoolean);
                } else if ("isShared".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.isShared = reader.getNullable(JsonReader::getBoolean);
                } else if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.lastModifiedBy = reader.getString();
                } else if ("lastModifiedByIdentity".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.lastModifiedByIdentity
                        = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("lastModifiedTime".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.lastModifiedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("links".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.links = MicrosoftGraphNotebookLinks.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.name = reader.getString();
                } else if ("sectionGroupsUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.sectionGroupsUrl = reader.getString();
                } else if ("sectionsUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.sectionsUrl = reader.getString();
                } else if ("self".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.self = reader.getString();
                } else if ("userRole".equals(fieldName)) {
                    deserializedMicrosoftGraphCopyNotebookModel.userRole
                        = MicrosoftGraphOnenoteUserRole.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphCopyNotebookModel.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphCopyNotebookModel;
        });
    }
}
