// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a conversation thread.
 */
@Fluent
public final class MicrosoftGraphConversationThread extends MicrosoftGraphEntity {
    /*
     * The Cc: recipients for the thread.
     */
    private List<MicrosoftGraphRecipient> ccRecipients;

    /*
     * Indicates whether any of the posts within this thread has at least one attachment.
     */
    private Boolean hasAttachments;

    /*
     * Indicates if the thread is locked.
     */
    private Boolean isLocked;

    /*
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For
     * example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    private OffsetDateTime lastDeliveredDateTime;

    /*
     * A short summary from the body of the latest post in this conversation.
     */
    private String preview;

    /*
     * The topic of the conversation. This property can be set when the conversation is created, but it cannot be
     * updated.
     */
    private String topic;

    /*
     * The To: recipients for the thread.
     */
    private List<MicrosoftGraphRecipient> toRecipients;

    /*
     * All the users that sent a message to this thread.
     */
    private List<String> uniqueSenders;

    /*
     * Read-only. Nullable.
     */
    private List<MicrosoftGraphPost> posts;

    /*
     * conversationThread
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphConversationThread class.
     */
    public MicrosoftGraphConversationThread() {
    }

    /**
     * Get the ccRecipients property: The Cc: recipients for the thread.
     * 
     * @return the ccRecipients value.
     */
    public List<MicrosoftGraphRecipient> ccRecipients() {
        return this.ccRecipients;
    }

    /**
     * Set the ccRecipients property: The Cc: recipients for the thread.
     * 
     * @param ccRecipients the ccRecipients value to set.
     * @return the MicrosoftGraphConversationThread object itself.
     */
    public MicrosoftGraphConversationThread withCcRecipients(List<MicrosoftGraphRecipient> ccRecipients) {
        this.ccRecipients = ccRecipients;
        return this;
    }

    /**
     * Get the hasAttachments property: Indicates whether any of the posts within this thread has at least one
     * attachment.
     * 
     * @return the hasAttachments value.
     */
    public Boolean hasAttachments() {
        return this.hasAttachments;
    }

    /**
     * Set the hasAttachments property: Indicates whether any of the posts within this thread has at least one
     * attachment.
     * 
     * @param hasAttachments the hasAttachments value to set.
     * @return the MicrosoftGraphConversationThread object itself.
     */
    public MicrosoftGraphConversationThread withHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    /**
     * Get the isLocked property: Indicates if the thread is locked.
     * 
     * @return the isLocked value.
     */
    public Boolean isLocked() {
        return this.isLocked;
    }

    /**
     * Set the isLocked property: Indicates if the thread is locked.
     * 
     * @param isLocked the isLocked value to set.
     * @return the MicrosoftGraphConversationThread object itself.
     */
    public MicrosoftGraphConversationThread withIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    /**
     * Get the lastDeliveredDateTime property: The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     * 
     * @return the lastDeliveredDateTime value.
     */
    public OffsetDateTime lastDeliveredDateTime() {
        return this.lastDeliveredDateTime;
    }

    /**
     * Set the lastDeliveredDateTime property: The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     * 
     * @param lastDeliveredDateTime the lastDeliveredDateTime value to set.
     * @return the MicrosoftGraphConversationThread object itself.
     */
    public MicrosoftGraphConversationThread withLastDeliveredDateTime(OffsetDateTime lastDeliveredDateTime) {
        this.lastDeliveredDateTime = lastDeliveredDateTime;
        return this;
    }

    /**
     * Get the preview property: A short summary from the body of the latest post in this conversation.
     * 
     * @return the preview value.
     */
    public String preview() {
        return this.preview;
    }

    /**
     * Set the preview property: A short summary from the body of the latest post in this conversation.
     * 
     * @param preview the preview value to set.
     * @return the MicrosoftGraphConversationThread object itself.
     */
    public MicrosoftGraphConversationThread withPreview(String preview) {
        this.preview = preview;
        return this;
    }

    /**
     * Get the topic property: The topic of the conversation. This property can be set when the conversation is created,
     * but it cannot be updated.
     * 
     * @return the topic value.
     */
    public String topic() {
        return this.topic;
    }

    /**
     * Set the topic property: The topic of the conversation. This property can be set when the conversation is created,
     * but it cannot be updated.
     * 
     * @param topic the topic value to set.
     * @return the MicrosoftGraphConversationThread object itself.
     */
    public MicrosoftGraphConversationThread withTopic(String topic) {
        this.topic = topic;
        return this;
    }

    /**
     * Get the toRecipients property: The To: recipients for the thread.
     * 
     * @return the toRecipients value.
     */
    public List<MicrosoftGraphRecipient> toRecipients() {
        return this.toRecipients;
    }

    /**
     * Set the toRecipients property: The To: recipients for the thread.
     * 
     * @param toRecipients the toRecipients value to set.
     * @return the MicrosoftGraphConversationThread object itself.
     */
    public MicrosoftGraphConversationThread withToRecipients(List<MicrosoftGraphRecipient> toRecipients) {
        this.toRecipients = toRecipients;
        return this;
    }

    /**
     * Get the uniqueSenders property: All the users that sent a message to this thread.
     * 
     * @return the uniqueSenders value.
     */
    public List<String> uniqueSenders() {
        return this.uniqueSenders;
    }

    /**
     * Set the uniqueSenders property: All the users that sent a message to this thread.
     * 
     * @param uniqueSenders the uniqueSenders value to set.
     * @return the MicrosoftGraphConversationThread object itself.
     */
    public MicrosoftGraphConversationThread withUniqueSenders(List<String> uniqueSenders) {
        this.uniqueSenders = uniqueSenders;
        return this;
    }

    /**
     * Get the posts property: Read-only. Nullable.
     * 
     * @return the posts value.
     */
    public List<MicrosoftGraphPost> posts() {
        return this.posts;
    }

    /**
     * Set the posts property: Read-only. Nullable.
     * 
     * @param posts the posts value to set.
     * @return the MicrosoftGraphConversationThread object itself.
     */
    public MicrosoftGraphConversationThread withPosts(List<MicrosoftGraphPost> posts) {
        this.posts = posts;
        return this;
    }

    /**
     * Get the additionalProperties property: conversationThread.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: conversationThread.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphConversationThread object itself.
     */
    public MicrosoftGraphConversationThread withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphConversationThread withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (ccRecipients() != null) {
            ccRecipients().forEach(e -> e.validate());
        }
        if (toRecipients() != null) {
            toRecipients().forEach(e -> e.validate());
        }
        if (posts() != null) {
            posts().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeArrayField("ccRecipients", this.ccRecipients, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("hasAttachments", this.hasAttachments);
        jsonWriter.writeBooleanField("isLocked", this.isLocked);
        jsonWriter.writeStringField("lastDeliveredDateTime",
            this.lastDeliveredDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastDeliveredDateTime));
        jsonWriter.writeStringField("preview", this.preview);
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeArrayField("toRecipients", this.toRecipients, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("uniqueSenders", this.uniqueSenders,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("posts", this.posts, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphConversationThread from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphConversationThread if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphConversationThread.
     */
    public static MicrosoftGraphConversationThread fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphConversationThread deserializedMicrosoftGraphConversationThread
                = new MicrosoftGraphConversationThread();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphConversationThread.withId(reader.getString());
                } else if ("ccRecipients".equals(fieldName)) {
                    List<MicrosoftGraphRecipient> ccRecipients
                        = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    deserializedMicrosoftGraphConversationThread.ccRecipients = ccRecipients;
                } else if ("hasAttachments".equals(fieldName)) {
                    deserializedMicrosoftGraphConversationThread.hasAttachments
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("isLocked".equals(fieldName)) {
                    deserializedMicrosoftGraphConversationThread.isLocked = reader.getNullable(JsonReader::getBoolean);
                } else if ("lastDeliveredDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphConversationThread.lastDeliveredDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("preview".equals(fieldName)) {
                    deserializedMicrosoftGraphConversationThread.preview = reader.getString();
                } else if ("topic".equals(fieldName)) {
                    deserializedMicrosoftGraphConversationThread.topic = reader.getString();
                } else if ("toRecipients".equals(fieldName)) {
                    List<MicrosoftGraphRecipient> toRecipients
                        = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    deserializedMicrosoftGraphConversationThread.toRecipients = toRecipients;
                } else if ("uniqueSenders".equals(fieldName)) {
                    List<String> uniqueSenders = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphConversationThread.uniqueSenders = uniqueSenders;
                } else if ("posts".equals(fieldName)) {
                    List<MicrosoftGraphPost> posts = reader.readArray(reader1 -> MicrosoftGraphPost.fromJson(reader1));
                    deserializedMicrosoftGraphConversationThread.posts = posts;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphConversationThread.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphConversationThread;
        });
    }
}
