// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a content type order.
 */
@Fluent
public final class MicrosoftGraphContentTypeOrder implements JsonSerializable<MicrosoftGraphContentTypeOrder> {
    /*
     * Whether this is the default Content Type
     */
    private Boolean defaultProperty;

    /*
     * Specifies the position in which the Content Type appears in the selection UI.
     */
    private Integer position;

    /*
     * contentTypeOrder
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphContentTypeOrder class.
     */
    public MicrosoftGraphContentTypeOrder() {
    }

    /**
     * Get the defaultProperty property: Whether this is the default Content Type.
     * 
     * @return the defaultProperty value.
     */
    public Boolean defaultProperty() {
        return this.defaultProperty;
    }

    /**
     * Set the defaultProperty property: Whether this is the default Content Type.
     * 
     * @param defaultProperty the defaultProperty value to set.
     * @return the MicrosoftGraphContentTypeOrder object itself.
     */
    public MicrosoftGraphContentTypeOrder withDefaultProperty(Boolean defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    /**
     * Get the position property: Specifies the position in which the Content Type appears in the selection UI.
     * 
     * @return the position value.
     */
    public Integer position() {
        return this.position;
    }

    /**
     * Set the position property: Specifies the position in which the Content Type appears in the selection UI.
     * 
     * @param position the position value to set.
     * @return the MicrosoftGraphContentTypeOrder object itself.
     */
    public MicrosoftGraphContentTypeOrder withPosition(Integer position) {
        this.position = position;
        return this;
    }

    /**
     * Get the additionalProperties property: contentTypeOrder.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: contentTypeOrder.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphContentTypeOrder object itself.
     */
    public MicrosoftGraphContentTypeOrder withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("default", this.defaultProperty);
        jsonWriter.writeNumberField("position", this.position);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphContentTypeOrder from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphContentTypeOrder if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphContentTypeOrder.
     */
    public static MicrosoftGraphContentTypeOrder fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphContentTypeOrder deserializedMicrosoftGraphContentTypeOrder
                = new MicrosoftGraphContentTypeOrder();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("default".equals(fieldName)) {
                    deserializedMicrosoftGraphContentTypeOrder.defaultProperty
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("position".equals(fieldName)) {
                    deserializedMicrosoftGraphContentTypeOrder.position = reader.getNullable(JsonReader::getInt);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphContentTypeOrder.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphContentTypeOrder;
        });
    }
}
