// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Represents a contact folder.
 */
@Fluent
public final class MicrosoftGraphContactFolder extends MicrosoftGraphEntity {
    /*
     * The folder's display name.
     */
    private String displayName;

    /*
     * The ID of the folder's parent folder.
     */
    private String parentFolderId;

    /*
     * The collection of child folders in the folder. Navigation property. Read-only. Nullable.
     */
    private List<MicrosoftGraphContactFolder> childFolders;

    /*
     * The contacts in the folder. Navigation property. Read-only. Nullable.
     */
    private List<MicrosoftGraphContact> contacts;

    /*
     * The collection of multi-value extended properties defined for the contactFolder. Read-only. Nullable.
     */
    private List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    /*
     * The collection of single-value extended properties defined for the contactFolder. Read-only. Nullable.
     */
    private List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    /*
     * contactFolder
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphContactFolder class.
     */
    public MicrosoftGraphContactFolder() {
    }

    /**
     * Get the displayName property: The folder's display name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The folder's display name.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphContactFolder object itself.
     */
    public MicrosoftGraphContactFolder withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the parentFolderId property: The ID of the folder's parent folder.
     * 
     * @return the parentFolderId value.
     */
    public String parentFolderId() {
        return this.parentFolderId;
    }

    /**
     * Set the parentFolderId property: The ID of the folder's parent folder.
     * 
     * @param parentFolderId the parentFolderId value to set.
     * @return the MicrosoftGraphContactFolder object itself.
     */
    public MicrosoftGraphContactFolder withParentFolderId(String parentFolderId) {
        this.parentFolderId = parentFolderId;
        return this;
    }

    /**
     * Get the childFolders property: The collection of child folders in the folder. Navigation property. Read-only.
     * Nullable.
     * 
     * @return the childFolders value.
     */
    public List<MicrosoftGraphContactFolder> childFolders() {
        return this.childFolders;
    }

    /**
     * Set the childFolders property: The collection of child folders in the folder. Navigation property. Read-only.
     * Nullable.
     * 
     * @param childFolders the childFolders value to set.
     * @return the MicrosoftGraphContactFolder object itself.
     */
    public MicrosoftGraphContactFolder withChildFolders(List<MicrosoftGraphContactFolder> childFolders) {
        this.childFolders = childFolders;
        return this;
    }

    /**
     * Get the contacts property: The contacts in the folder. Navigation property. Read-only. Nullable.
     * 
     * @return the contacts value.
     */
    public List<MicrosoftGraphContact> contacts() {
        return this.contacts;
    }

    /**
     * Set the contacts property: The contacts in the folder. Navigation property. Read-only. Nullable.
     * 
     * @param contacts the contacts value to set.
     * @return the MicrosoftGraphContactFolder object itself.
     */
    public MicrosoftGraphContactFolder withContacts(List<MicrosoftGraphContact> contacts) {
        this.contacts = contacts;
        return this;
    }

    /**
     * Get the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * contactFolder. Read-only. Nullable.
     * 
     * @return the multiValueExtendedProperties value.
     */
    public List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties() {
        return this.multiValueExtendedProperties;
    }

    /**
     * Set the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * contactFolder. Read-only. Nullable.
     * 
     * @param multiValueExtendedProperties the multiValueExtendedProperties value to set.
     * @return the MicrosoftGraphContactFolder object itself.
     */
    public MicrosoftGraphContactFolder withMultiValueExtendedProperties(
        List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        this.multiValueExtendedProperties = multiValueExtendedProperties;
        return this;
    }

    /**
     * Get the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the contactFolder. Read-only. Nullable.
     * 
     * @return the singleValueExtendedProperties value.
     */
    public List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties() {
        return this.singleValueExtendedProperties;
    }

    /**
     * Set the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the contactFolder. Read-only. Nullable.
     * 
     * @param singleValueExtendedProperties the singleValueExtendedProperties value to set.
     * @return the MicrosoftGraphContactFolder object itself.
     */
    public MicrosoftGraphContactFolder withSingleValueExtendedProperties(
        List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        this.singleValueExtendedProperties = singleValueExtendedProperties;
        return this;
    }

    /**
     * Get the additionalProperties property: contactFolder.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: contactFolder.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphContactFolder object itself.
     */
    public MicrosoftGraphContactFolder withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphContactFolder withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (childFolders() != null) {
            childFolders().forEach(e -> e.validate());
        }
        if (contacts() != null) {
            contacts().forEach(e -> e.validate());
        }
        if (multiValueExtendedProperties() != null) {
            multiValueExtendedProperties().forEach(e -> e.validate());
        }
        if (singleValueExtendedProperties() != null) {
            singleValueExtendedProperties().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("parentFolderId", this.parentFolderId);
        jsonWriter.writeArrayField("childFolders", this.childFolders, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("contacts", this.contacts, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("multiValueExtendedProperties", this.multiValueExtendedProperties,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("singleValueExtendedProperties", this.singleValueExtendedProperties,
            (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphContactFolder from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphContactFolder if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphContactFolder.
     */
    public static MicrosoftGraphContactFolder fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphContactFolder deserializedMicrosoftGraphContactFolder = new MicrosoftGraphContactFolder();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphContactFolder.withId(reader.getString());
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphContactFolder.displayName = reader.getString();
                } else if ("parentFolderId".equals(fieldName)) {
                    deserializedMicrosoftGraphContactFolder.parentFolderId = reader.getString();
                } else if ("childFolders".equals(fieldName)) {
                    List<MicrosoftGraphContactFolder> childFolders
                        = reader.readArray(reader1 -> MicrosoftGraphContactFolder.fromJson(reader1));
                    deserializedMicrosoftGraphContactFolder.childFolders = childFolders;
                } else if ("contacts".equals(fieldName)) {
                    List<MicrosoftGraphContact> contacts
                        = reader.readArray(reader1 -> MicrosoftGraphContact.fromJson(reader1));
                    deserializedMicrosoftGraphContactFolder.contacts = contacts;
                } else if ("multiValueExtendedProperties".equals(fieldName)) {
                    List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties
                        = reader.readArray(reader1 -> MicrosoftGraphMultiValueLegacyExtendedProperty.fromJson(reader1));
                    deserializedMicrosoftGraphContactFolder.multiValueExtendedProperties = multiValueExtendedProperties;
                } else if ("singleValueExtendedProperties".equals(fieldName)) {
                    List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties = reader
                        .readArray(reader1 -> MicrosoftGraphSingleValueLegacyExtendedProperty.fromJson(reader1));
                    deserializedMicrosoftGraphContactFolder.singleValueExtendedProperties
                        = singleValueExtendedProperties;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphContactFolder.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphContactFolder;
        });
    }
}
