// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents configuration Manager client enabled features.
 * <p>
 * Configuration Manager client enabled features.
 */
@Fluent
public final class MicrosoftGraphConfigurationManagerClientEnabledFeatures
    implements JsonSerializable<MicrosoftGraphConfigurationManagerClientEnabledFeatures> {
    /*
     * Whether compliance policy is managed by Intune
     */
    private Boolean compliancePolicy;

    /*
     * Whether device configuration is managed by Intune
     */
    private Boolean deviceConfiguration;

    /*
     * Whether inventory is managed by Intune
     */
    private Boolean inventory;

    /*
     * Whether modern application is managed by Intune
     */
    private Boolean modernApps;

    /*
     * Whether resource access is managed by Intune
     */
    private Boolean resourceAccess;

    /*
     * Whether Windows Update for Business is managed by Intune
     */
    private Boolean windowsUpdateForBusiness;

    /*
     * configuration Manager client enabled features
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphConfigurationManagerClientEnabledFeatures class.
     */
    public MicrosoftGraphConfigurationManagerClientEnabledFeatures() {
    }

    /**
     * Get the compliancePolicy property: Whether compliance policy is managed by Intune.
     * 
     * @return the compliancePolicy value.
     */
    public Boolean compliancePolicy() {
        return this.compliancePolicy;
    }

    /**
     * Set the compliancePolicy property: Whether compliance policy is managed by Intune.
     * 
     * @param compliancePolicy the compliancePolicy value to set.
     * @return the MicrosoftGraphConfigurationManagerClientEnabledFeatures object itself.
     */
    public MicrosoftGraphConfigurationManagerClientEnabledFeatures withCompliancePolicy(Boolean compliancePolicy) {
        this.compliancePolicy = compliancePolicy;
        return this;
    }

    /**
     * Get the deviceConfiguration property: Whether device configuration is managed by Intune.
     * 
     * @return the deviceConfiguration value.
     */
    public Boolean deviceConfiguration() {
        return this.deviceConfiguration;
    }

    /**
     * Set the deviceConfiguration property: Whether device configuration is managed by Intune.
     * 
     * @param deviceConfiguration the deviceConfiguration value to set.
     * @return the MicrosoftGraphConfigurationManagerClientEnabledFeatures object itself.
     */
    public MicrosoftGraphConfigurationManagerClientEnabledFeatures
        withDeviceConfiguration(Boolean deviceConfiguration) {
        this.deviceConfiguration = deviceConfiguration;
        return this;
    }

    /**
     * Get the inventory property: Whether inventory is managed by Intune.
     * 
     * @return the inventory value.
     */
    public Boolean inventory() {
        return this.inventory;
    }

    /**
     * Set the inventory property: Whether inventory is managed by Intune.
     * 
     * @param inventory the inventory value to set.
     * @return the MicrosoftGraphConfigurationManagerClientEnabledFeatures object itself.
     */
    public MicrosoftGraphConfigurationManagerClientEnabledFeatures withInventory(Boolean inventory) {
        this.inventory = inventory;
        return this;
    }

    /**
     * Get the modernApps property: Whether modern application is managed by Intune.
     * 
     * @return the modernApps value.
     */
    public Boolean modernApps() {
        return this.modernApps;
    }

    /**
     * Set the modernApps property: Whether modern application is managed by Intune.
     * 
     * @param modernApps the modernApps value to set.
     * @return the MicrosoftGraphConfigurationManagerClientEnabledFeatures object itself.
     */
    public MicrosoftGraphConfigurationManagerClientEnabledFeatures withModernApps(Boolean modernApps) {
        this.modernApps = modernApps;
        return this;
    }

    /**
     * Get the resourceAccess property: Whether resource access is managed by Intune.
     * 
     * @return the resourceAccess value.
     */
    public Boolean resourceAccess() {
        return this.resourceAccess;
    }

    /**
     * Set the resourceAccess property: Whether resource access is managed by Intune.
     * 
     * @param resourceAccess the resourceAccess value to set.
     * @return the MicrosoftGraphConfigurationManagerClientEnabledFeatures object itself.
     */
    public MicrosoftGraphConfigurationManagerClientEnabledFeatures withResourceAccess(Boolean resourceAccess) {
        this.resourceAccess = resourceAccess;
        return this;
    }

    /**
     * Get the windowsUpdateForBusiness property: Whether Windows Update for Business is managed by Intune.
     * 
     * @return the windowsUpdateForBusiness value.
     */
    public Boolean windowsUpdateForBusiness() {
        return this.windowsUpdateForBusiness;
    }

    /**
     * Set the windowsUpdateForBusiness property: Whether Windows Update for Business is managed by Intune.
     * 
     * @param windowsUpdateForBusiness the windowsUpdateForBusiness value to set.
     * @return the MicrosoftGraphConfigurationManagerClientEnabledFeatures object itself.
     */
    public MicrosoftGraphConfigurationManagerClientEnabledFeatures
        withWindowsUpdateForBusiness(Boolean windowsUpdateForBusiness) {
        this.windowsUpdateForBusiness = windowsUpdateForBusiness;
        return this;
    }

    /**
     * Get the additionalProperties property: configuration Manager client enabled features.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: configuration Manager client enabled features.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphConfigurationManagerClientEnabledFeatures object itself.
     */
    public MicrosoftGraphConfigurationManagerClientEnabledFeatures
        withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("compliancePolicy", this.compliancePolicy);
        jsonWriter.writeBooleanField("deviceConfiguration", this.deviceConfiguration);
        jsonWriter.writeBooleanField("inventory", this.inventory);
        jsonWriter.writeBooleanField("modernApps", this.modernApps);
        jsonWriter.writeBooleanField("resourceAccess", this.resourceAccess);
        jsonWriter.writeBooleanField("windowsUpdateForBusiness", this.windowsUpdateForBusiness);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphConfigurationManagerClientEnabledFeatures from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphConfigurationManagerClientEnabledFeatures if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphConfigurationManagerClientEnabledFeatures.
     */
    public static MicrosoftGraphConfigurationManagerClientEnabledFeatures fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphConfigurationManagerClientEnabledFeatures deserializedMicrosoftGraphConfigurationManagerClientEnabledFeatures
                = new MicrosoftGraphConfigurationManagerClientEnabledFeatures();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("compliancePolicy".equals(fieldName)) {
                    deserializedMicrosoftGraphConfigurationManagerClientEnabledFeatures.compliancePolicy
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("deviceConfiguration".equals(fieldName)) {
                    deserializedMicrosoftGraphConfigurationManagerClientEnabledFeatures.deviceConfiguration
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("inventory".equals(fieldName)) {
                    deserializedMicrosoftGraphConfigurationManagerClientEnabledFeatures.inventory
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("modernApps".equals(fieldName)) {
                    deserializedMicrosoftGraphConfigurationManagerClientEnabledFeatures.modernApps
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("resourceAccess".equals(fieldName)) {
                    deserializedMicrosoftGraphConfigurationManagerClientEnabledFeatures.resourceAccess
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("windowsUpdateForBusiness".equals(fieldName)) {
                    deserializedMicrosoftGraphConfigurationManagerClientEnabledFeatures.windowsUpdateForBusiness
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphConfigurationManagerClientEnabledFeatures.additionalProperties
                = additionalProperties;

            return deserializedMicrosoftGraphConfigurationManagerClientEnabledFeatures;
        });
    }
}
