// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a column link.
 */
@Fluent
public final class MicrosoftGraphColumnLink extends MicrosoftGraphEntity {
    /*
     * The name of the column in this content type.
     */
    private String name;

    /*
     * columnLink
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphColumnLink class.
     */
    public MicrosoftGraphColumnLink() {
    }

    /**
     * Get the name property: The name of the column in this content type.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the column in this content type.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphColumnLink object itself.
     */
    public MicrosoftGraphColumnLink withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the additionalProperties property: columnLink.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: columnLink.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphColumnLink object itself.
     */
    public MicrosoftGraphColumnLink withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphColumnLink withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("name", this.name);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphColumnLink from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphColumnLink if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphColumnLink.
     */
    public static MicrosoftGraphColumnLink fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphColumnLink deserializedMicrosoftGraphColumnLink = new MicrosoftGraphColumnLink();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnLink.withId(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnLink.name = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphColumnLink.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphColumnLink;
        });
    }
}
