// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a column definition.
 */
@Fluent
public final class MicrosoftGraphColumnDefinition extends MicrosoftGraphEntity {
    /*
     * booleanColumn
     */
    private Map<String, Object> booleanProperty;

    /*
     * calculatedColumn
     */
    private MicrosoftGraphCalculatedColumn calculated;

    /*
     * choiceColumn
     */
    private MicrosoftGraphChoiceColumn choice;

    /*
     * For site columns, the name of the group this column belongs to. Helps organize related columns.
     */
    private String columnGroup;

    /*
     * currencyColumn
     */
    private MicrosoftGraphCurrencyColumn currency;

    /*
     * dateTimeColumn
     */
    private MicrosoftGraphDateTimeColumn dateTime;

    /*
     * defaultColumnValue
     */
    private MicrosoftGraphDefaultColumnValue defaultValue;

    /*
     * The user-facing description of the column.
     */
    private String description;

    /*
     * The user-facing name of the column.
     */
    private String displayName;

    /*
     * If true, no two list items may have the same value for this column.
     */
    private Boolean enforceUniqueValues;

    /*
     * geolocationColumn
     */
    private Map<String, Object> geolocation;

    /*
     * Specifies whether the column is displayed in the user interface.
     */
    private Boolean hidden;

    /*
     * Specifies whether the column values can used for sorting and searching.
     */
    private Boolean indexed;

    /*
     * lookupColumn
     */
    private MicrosoftGraphLookupColumn lookup;

    /*
     * The API-facing name of the column as it appears in the [fields][] on a [listItem][]. For the user-facing name,
     * see displayName.
     */
    private String name;

    /*
     * numberColumn
     */
    private MicrosoftGraphNumberColumn number;

    /*
     * personOrGroupColumn
     */
    private MicrosoftGraphPersonOrGroupColumn personOrGroup;

    /*
     * Specifies whether the column values can be modified.
     */
    private Boolean readOnly;

    /*
     * Specifies whether the column value is not optional.
     */
    private Boolean required;

    /*
     * textColumn
     */
    private MicrosoftGraphTextColumn text;

    /*
     * columnDefinition
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphColumnDefinition class.
     */
    public MicrosoftGraphColumnDefinition() {
    }

    /**
     * Get the booleanProperty property: booleanColumn.
     * 
     * @return the booleanProperty value.
     */
    public Map<String, Object> booleanProperty() {
        return this.booleanProperty;
    }

    /**
     * Set the booleanProperty property: booleanColumn.
     * 
     * @param booleanProperty the booleanProperty value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withBooleanProperty(Map<String, Object> booleanProperty) {
        this.booleanProperty = booleanProperty;
        return this;
    }

    /**
     * Get the calculated property: calculatedColumn.
     * 
     * @return the calculated value.
     */
    public MicrosoftGraphCalculatedColumn calculated() {
        return this.calculated;
    }

    /**
     * Set the calculated property: calculatedColumn.
     * 
     * @param calculated the calculated value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withCalculated(MicrosoftGraphCalculatedColumn calculated) {
        this.calculated = calculated;
        return this;
    }

    /**
     * Get the choice property: choiceColumn.
     * 
     * @return the choice value.
     */
    public MicrosoftGraphChoiceColumn choice() {
        return this.choice;
    }

    /**
     * Set the choice property: choiceColumn.
     * 
     * @param choice the choice value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withChoice(MicrosoftGraphChoiceColumn choice) {
        this.choice = choice;
        return this;
    }

    /**
     * Get the columnGroup property: For site columns, the name of the group this column belongs to. Helps organize
     * related columns.
     * 
     * @return the columnGroup value.
     */
    public String columnGroup() {
        return this.columnGroup;
    }

    /**
     * Set the columnGroup property: For site columns, the name of the group this column belongs to. Helps organize
     * related columns.
     * 
     * @param columnGroup the columnGroup value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withColumnGroup(String columnGroup) {
        this.columnGroup = columnGroup;
        return this;
    }

    /**
     * Get the currency property: currencyColumn.
     * 
     * @return the currency value.
     */
    public MicrosoftGraphCurrencyColumn currency() {
        return this.currency;
    }

    /**
     * Set the currency property: currencyColumn.
     * 
     * @param currency the currency value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withCurrency(MicrosoftGraphCurrencyColumn currency) {
        this.currency = currency;
        return this;
    }

    /**
     * Get the dateTime property: dateTimeColumn.
     * 
     * @return the dateTime value.
     */
    public MicrosoftGraphDateTimeColumn dateTime() {
        return this.dateTime;
    }

    /**
     * Set the dateTime property: dateTimeColumn.
     * 
     * @param dateTime the dateTime value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withDateTime(MicrosoftGraphDateTimeColumn dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    /**
     * Get the defaultValue property: defaultColumnValue.
     * 
     * @return the defaultValue value.
     */
    public MicrosoftGraphDefaultColumnValue defaultValue() {
        return this.defaultValue;
    }

    /**
     * Set the defaultValue property: defaultColumnValue.
     * 
     * @param defaultValue the defaultValue value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withDefaultValue(MicrosoftGraphDefaultColumnValue defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Get the description property: The user-facing description of the column.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The user-facing description of the column.
     * 
     * @param description the description value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: The user-facing name of the column.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The user-facing name of the column.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the enforceUniqueValues property: If true, no two list items may have the same value for this column.
     * 
     * @return the enforceUniqueValues value.
     */
    public Boolean enforceUniqueValues() {
        return this.enforceUniqueValues;
    }

    /**
     * Set the enforceUniqueValues property: If true, no two list items may have the same value for this column.
     * 
     * @param enforceUniqueValues the enforceUniqueValues value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withEnforceUniqueValues(Boolean enforceUniqueValues) {
        this.enforceUniqueValues = enforceUniqueValues;
        return this;
    }

    /**
     * Get the geolocation property: geolocationColumn.
     * 
     * @return the geolocation value.
     */
    public Map<String, Object> geolocation() {
        return this.geolocation;
    }

    /**
     * Set the geolocation property: geolocationColumn.
     * 
     * @param geolocation the geolocation value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withGeolocation(Map<String, Object> geolocation) {
        this.geolocation = geolocation;
        return this;
    }

    /**
     * Get the hidden property: Specifies whether the column is displayed in the user interface.
     * 
     * @return the hidden value.
     */
    public Boolean hidden() {
        return this.hidden;
    }

    /**
     * Set the hidden property: Specifies whether the column is displayed in the user interface.
     * 
     * @param hidden the hidden value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    /**
     * Get the indexed property: Specifies whether the column values can used for sorting and searching.
     * 
     * @return the indexed value.
     */
    public Boolean indexed() {
        return this.indexed;
    }

    /**
     * Set the indexed property: Specifies whether the column values can used for sorting and searching.
     * 
     * @param indexed the indexed value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withIndexed(Boolean indexed) {
        this.indexed = indexed;
        return this;
    }

    /**
     * Get the lookup property: lookupColumn.
     * 
     * @return the lookup value.
     */
    public MicrosoftGraphLookupColumn lookup() {
        return this.lookup;
    }

    /**
     * Set the lookup property: lookupColumn.
     * 
     * @param lookup the lookup value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withLookup(MicrosoftGraphLookupColumn lookup) {
        this.lookup = lookup;
        return this;
    }

    /**
     * Get the name property: The API-facing name of the column as it appears in the [fields][] on a [listItem][]. For
     * the user-facing name, see displayName.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The API-facing name of the column as it appears in the [fields][] on a [listItem][]. For
     * the user-facing name, see displayName.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the number property: numberColumn.
     * 
     * @return the number value.
     */
    public MicrosoftGraphNumberColumn number() {
        return this.number;
    }

    /**
     * Set the number property: numberColumn.
     * 
     * @param number the number value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withNumber(MicrosoftGraphNumberColumn number) {
        this.number = number;
        return this;
    }

    /**
     * Get the personOrGroup property: personOrGroupColumn.
     * 
     * @return the personOrGroup value.
     */
    public MicrosoftGraphPersonOrGroupColumn personOrGroup() {
        return this.personOrGroup;
    }

    /**
     * Set the personOrGroup property: personOrGroupColumn.
     * 
     * @param personOrGroup the personOrGroup value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withPersonOrGroup(MicrosoftGraphPersonOrGroupColumn personOrGroup) {
        this.personOrGroup = personOrGroup;
        return this;
    }

    /**
     * Get the readOnly property: Specifies whether the column values can be modified.
     * 
     * @return the readOnly value.
     */
    public Boolean readOnly() {
        return this.readOnly;
    }

    /**
     * Set the readOnly property: Specifies whether the column values can be modified.
     * 
     * @param readOnly the readOnly value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    /**
     * Get the required property: Specifies whether the column value is not optional.
     * 
     * @return the required value.
     */
    public Boolean required() {
        return this.required;
    }

    /**
     * Set the required property: Specifies whether the column value is not optional.
     * 
     * @param required the required value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    /**
     * Get the text property: textColumn.
     * 
     * @return the text value.
     */
    public MicrosoftGraphTextColumn text() {
        return this.text;
    }

    /**
     * Set the text property: textColumn.
     * 
     * @param text the text value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withText(MicrosoftGraphTextColumn text) {
        this.text = text;
        return this;
    }

    /**
     * Get the additionalProperties property: columnDefinition.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: columnDefinition.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphColumnDefinition object itself.
     */
    public MicrosoftGraphColumnDefinition withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphColumnDefinition withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (calculated() != null) {
            calculated().validate();
        }
        if (choice() != null) {
            choice().validate();
        }
        if (currency() != null) {
            currency().validate();
        }
        if (dateTime() != null) {
            dateTime().validate();
        }
        if (defaultValue() != null) {
            defaultValue().validate();
        }
        if (lookup() != null) {
            lookup().validate();
        }
        if (number() != null) {
            number().validate();
        }
        if (personOrGroup() != null) {
            personOrGroup().validate();
        }
        if (text() != null) {
            text().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeMapField("boolean", this.booleanProperty, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("calculated", this.calculated);
        jsonWriter.writeJsonField("choice", this.choice);
        jsonWriter.writeStringField("columnGroup", this.columnGroup);
        jsonWriter.writeJsonField("currency", this.currency);
        jsonWriter.writeJsonField("dateTime", this.dateTime);
        jsonWriter.writeJsonField("defaultValue", this.defaultValue);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeBooleanField("enforceUniqueValues", this.enforceUniqueValues);
        jsonWriter.writeMapField("geolocation", this.geolocation, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeBooleanField("hidden", this.hidden);
        jsonWriter.writeBooleanField("indexed", this.indexed);
        jsonWriter.writeJsonField("lookup", this.lookup);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("number", this.number);
        jsonWriter.writeJsonField("personOrGroup", this.personOrGroup);
        jsonWriter.writeBooleanField("readOnly", this.readOnly);
        jsonWriter.writeBooleanField("required", this.required);
        jsonWriter.writeJsonField("text", this.text);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphColumnDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphColumnDefinition if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphColumnDefinition.
     */
    public static MicrosoftGraphColumnDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphColumnDefinition deserializedMicrosoftGraphColumnDefinition
                = new MicrosoftGraphColumnDefinition();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.withId(reader.getString());
                } else if ("boolean".equals(fieldName)) {
                    Map<String, Object> booleanProperty = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphColumnDefinition.booleanProperty = booleanProperty;
                } else if ("calculated".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.calculated
                        = MicrosoftGraphCalculatedColumn.fromJson(reader);
                } else if ("choice".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.choice = MicrosoftGraphChoiceColumn.fromJson(reader);
                } else if ("columnGroup".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.columnGroup = reader.getString();
                } else if ("currency".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.currency = MicrosoftGraphCurrencyColumn.fromJson(reader);
                } else if ("dateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.dateTime = MicrosoftGraphDateTimeColumn.fromJson(reader);
                } else if ("defaultValue".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.defaultValue
                        = MicrosoftGraphDefaultColumnValue.fromJson(reader);
                } else if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.description = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.displayName = reader.getString();
                } else if ("enforceUniqueValues".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.enforceUniqueValues
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("geolocation".equals(fieldName)) {
                    Map<String, Object> geolocation = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphColumnDefinition.geolocation = geolocation;
                } else if ("hidden".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.hidden = reader.getNullable(JsonReader::getBoolean);
                } else if ("indexed".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.indexed = reader.getNullable(JsonReader::getBoolean);
                } else if ("lookup".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.lookup = MicrosoftGraphLookupColumn.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.name = reader.getString();
                } else if ("number".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.number = MicrosoftGraphNumberColumn.fromJson(reader);
                } else if ("personOrGroup".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.personOrGroup
                        = MicrosoftGraphPersonOrGroupColumn.fromJson(reader);
                } else if ("readOnly".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.readOnly = reader.getNullable(JsonReader::getBoolean);
                } else if ("required".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.required = reader.getNullable(JsonReader::getBoolean);
                } else if ("text".equals(fieldName)) {
                    deserializedMicrosoftGraphColumnDefinition.text = MicrosoftGraphTextColumn.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphColumnDefinition.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphColumnDefinition;
        });
    }
}
