// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Represents a chat message type.
 */
public final class MicrosoftGraphChatMessageType extends ExpandableStringEnum<MicrosoftGraphChatMessageType> {
    /**
     * Static value message for MicrosoftGraphChatMessageType.
     */
    public static final MicrosoftGraphChatMessageType MESSAGE = fromString("message");

    /**
     * Static value chatEvent for MicrosoftGraphChatMessageType.
     */
    public static final MicrosoftGraphChatMessageType CHAT_EVENT = fromString("chatEvent");

    /**
     * Static value typing for MicrosoftGraphChatMessageType.
     */
    public static final MicrosoftGraphChatMessageType TYPING = fromString("typing");

    /**
     * Static value unknownFutureValue for MicrosoftGraphChatMessageType.
     */
    public static final MicrosoftGraphChatMessageType UNKNOWN_FUTURE_VALUE = fromString("unknownFutureValue");

    /**
     * Creates a new instance of MicrosoftGraphChatMessageType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public MicrosoftGraphChatMessageType() {
    }

    /**
     * Creates or finds a MicrosoftGraphChatMessageType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding MicrosoftGraphChatMessageType.
     */
    public static MicrosoftGraphChatMessageType fromString(String name) {
        return fromString(name, MicrosoftGraphChatMessageType.class);
    }

    /**
     * Gets known MicrosoftGraphChatMessageType values.
     * 
     * @return known MicrosoftGraphChatMessageType values.
     */
    public static Collection<MicrosoftGraphChatMessageType> values() {
        return values(MicrosoftGraphChatMessageType.class);
    }
}
