// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a chat message policy violation.
 */
@Fluent
public final class MicrosoftGraphChatMessagePolicyViolation
    implements JsonSerializable<MicrosoftGraphChatMessagePolicyViolation> {
    /*
     * chatMessagePolicyViolationDlpActionTypes
     */
    private MicrosoftGraphChatMessagePolicyViolationDlpActionTypes dlpAction;

    /*
     * Justification text provided by the sender of the message when overriding a policy violation.
     */
    private String justificationText;

    /*
     * chatMessagePolicyViolationPolicyTip
     */
    private MicrosoftGraphChatMessagePolicyViolationPolicyTip policyTip;

    /*
     * chatMessagePolicyViolationUserActionTypes
     */
    private MicrosoftGraphChatMessagePolicyViolationUserActionTypes userAction;

    /*
     * chatMessagePolicyViolationVerdictDetailsTypes
     */
    private MicrosoftGraphChatMessagePolicyViolationVerdictDetailsTypes verdictDetails;

    /*
     * chatMessagePolicyViolation
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphChatMessagePolicyViolation class.
     */
    public MicrosoftGraphChatMessagePolicyViolation() {
    }

    /**
     * Get the dlpAction property: chatMessagePolicyViolationDlpActionTypes.
     * 
     * @return the dlpAction value.
     */
    public MicrosoftGraphChatMessagePolicyViolationDlpActionTypes dlpAction() {
        return this.dlpAction;
    }

    /**
     * Set the dlpAction property: chatMessagePolicyViolationDlpActionTypes.
     * 
     * @param dlpAction the dlpAction value to set.
     * @return the MicrosoftGraphChatMessagePolicyViolation object itself.
     */
    public MicrosoftGraphChatMessagePolicyViolation
        withDlpAction(MicrosoftGraphChatMessagePolicyViolationDlpActionTypes dlpAction) {
        this.dlpAction = dlpAction;
        return this;
    }

    /**
     * Get the justificationText property: Justification text provided by the sender of the message when overriding a
     * policy violation.
     * 
     * @return the justificationText value.
     */
    public String justificationText() {
        return this.justificationText;
    }

    /**
     * Set the justificationText property: Justification text provided by the sender of the message when overriding a
     * policy violation.
     * 
     * @param justificationText the justificationText value to set.
     * @return the MicrosoftGraphChatMessagePolicyViolation object itself.
     */
    public MicrosoftGraphChatMessagePolicyViolation withJustificationText(String justificationText) {
        this.justificationText = justificationText;
        return this;
    }

    /**
     * Get the policyTip property: chatMessagePolicyViolationPolicyTip.
     * 
     * @return the policyTip value.
     */
    public MicrosoftGraphChatMessagePolicyViolationPolicyTip policyTip() {
        return this.policyTip;
    }

    /**
     * Set the policyTip property: chatMessagePolicyViolationPolicyTip.
     * 
     * @param policyTip the policyTip value to set.
     * @return the MicrosoftGraphChatMessagePolicyViolation object itself.
     */
    public MicrosoftGraphChatMessagePolicyViolation
        withPolicyTip(MicrosoftGraphChatMessagePolicyViolationPolicyTip policyTip) {
        this.policyTip = policyTip;
        return this;
    }

    /**
     * Get the userAction property: chatMessagePolicyViolationUserActionTypes.
     * 
     * @return the userAction value.
     */
    public MicrosoftGraphChatMessagePolicyViolationUserActionTypes userAction() {
        return this.userAction;
    }

    /**
     * Set the userAction property: chatMessagePolicyViolationUserActionTypes.
     * 
     * @param userAction the userAction value to set.
     * @return the MicrosoftGraphChatMessagePolicyViolation object itself.
     */
    public MicrosoftGraphChatMessagePolicyViolation
        withUserAction(MicrosoftGraphChatMessagePolicyViolationUserActionTypes userAction) {
        this.userAction = userAction;
        return this;
    }

    /**
     * Get the verdictDetails property: chatMessagePolicyViolationVerdictDetailsTypes.
     * 
     * @return the verdictDetails value.
     */
    public MicrosoftGraphChatMessagePolicyViolationVerdictDetailsTypes verdictDetails() {
        return this.verdictDetails;
    }

    /**
     * Set the verdictDetails property: chatMessagePolicyViolationVerdictDetailsTypes.
     * 
     * @param verdictDetails the verdictDetails value to set.
     * @return the MicrosoftGraphChatMessagePolicyViolation object itself.
     */
    public MicrosoftGraphChatMessagePolicyViolation
        withVerdictDetails(MicrosoftGraphChatMessagePolicyViolationVerdictDetailsTypes verdictDetails) {
        this.verdictDetails = verdictDetails;
        return this;
    }

    /**
     * Get the additionalProperties property: chatMessagePolicyViolation.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: chatMessagePolicyViolation.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphChatMessagePolicyViolation object itself.
     */
    public MicrosoftGraphChatMessagePolicyViolation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (policyTip() != null) {
            policyTip().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dlpAction", this.dlpAction == null ? null : this.dlpAction.toString());
        jsonWriter.writeStringField("justificationText", this.justificationText);
        jsonWriter.writeJsonField("policyTip", this.policyTip);
        jsonWriter.writeStringField("userAction", this.userAction == null ? null : this.userAction.toString());
        jsonWriter.writeStringField("verdictDetails",
            this.verdictDetails == null ? null : this.verdictDetails.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphChatMessagePolicyViolation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphChatMessagePolicyViolation if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphChatMessagePolicyViolation.
     */
    public static MicrosoftGraphChatMessagePolicyViolation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphChatMessagePolicyViolation deserializedMicrosoftGraphChatMessagePolicyViolation
                = new MicrosoftGraphChatMessagePolicyViolation();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dlpAction".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessagePolicyViolation.dlpAction
                        = MicrosoftGraphChatMessagePolicyViolationDlpActionTypes.fromString(reader.getString());
                } else if ("justificationText".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessagePolicyViolation.justificationText = reader.getString();
                } else if ("policyTip".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessagePolicyViolation.policyTip
                        = MicrosoftGraphChatMessagePolicyViolationPolicyTip.fromJson(reader);
                } else if ("userAction".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessagePolicyViolation.userAction
                        = MicrosoftGraphChatMessagePolicyViolationUserActionTypes.fromString(reader.getString());
                } else if ("verdictDetails".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessagePolicyViolation.verdictDetails
                        = MicrosoftGraphChatMessagePolicyViolationVerdictDetailsTypes.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphChatMessagePolicyViolation.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphChatMessagePolicyViolation;
        });
    }
}
