// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a chat message mention.
 */
@Fluent
public final class MicrosoftGraphChatMessageMention implements JsonSerializable<MicrosoftGraphChatMessageMention> {
    /*
     * Index of an entity being mentioned in the specified chatMessage. Matches the {index} value in the corresponding
     * <at id='{index}'> tag in the message body.
     */
    private Integer id;

    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet mentioned;

    /*
     * String used to represent the mention. For example, a user's display name, a team name.
     */
    private String mentionText;

    /*
     * chatMessageMention
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphChatMessageMention class.
     */
    public MicrosoftGraphChatMessageMention() {
    }

    /**
     * Get the id property: Index of an entity being mentioned in the specified chatMessage. Matches the {index} value
     * in the corresponding &lt;at id='{index}'&gt; tag in the message body.
     * 
     * @return the id value.
     */
    public Integer id() {
        return this.id;
    }

    /**
     * Set the id property: Index of an entity being mentioned in the specified chatMessage. Matches the {index} value
     * in the corresponding &lt;at id='{index}'&gt; tag in the message body.
     * 
     * @param id the id value to set.
     * @return the MicrosoftGraphChatMessageMention object itself.
     */
    public MicrosoftGraphChatMessageMention withId(Integer id) {
        this.id = id;
        return this;
    }

    /**
     * Get the mentioned property: identitySet.
     * 
     * @return the mentioned value.
     */
    public MicrosoftGraphIdentitySet mentioned() {
        return this.mentioned;
    }

    /**
     * Set the mentioned property: identitySet.
     * 
     * @param mentioned the mentioned value to set.
     * @return the MicrosoftGraphChatMessageMention object itself.
     */
    public MicrosoftGraphChatMessageMention withMentioned(MicrosoftGraphIdentitySet mentioned) {
        this.mentioned = mentioned;
        return this;
    }

    /**
     * Get the mentionText property: String used to represent the mention. For example, a user's display name, a team
     * name.
     * 
     * @return the mentionText value.
     */
    public String mentionText() {
        return this.mentionText;
    }

    /**
     * Set the mentionText property: String used to represent the mention. For example, a user's display name, a team
     * name.
     * 
     * @param mentionText the mentionText value to set.
     * @return the MicrosoftGraphChatMessageMention object itself.
     */
    public MicrosoftGraphChatMessageMention withMentionText(String mentionText) {
        this.mentionText = mentionText;
        return this;
    }

    /**
     * Get the additionalProperties property: chatMessageMention.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: chatMessageMention.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphChatMessageMention object itself.
     */
    public MicrosoftGraphChatMessageMention withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (mentioned() != null) {
            mentioned().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("id", this.id);
        jsonWriter.writeJsonField("mentioned", this.mentioned);
        jsonWriter.writeStringField("mentionText", this.mentionText);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphChatMessageMention from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphChatMessageMention if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphChatMessageMention.
     */
    public static MicrosoftGraphChatMessageMention fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphChatMessageMention deserializedMicrosoftGraphChatMessageMention
                = new MicrosoftGraphChatMessageMention();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessageMention.id = reader.getNullable(JsonReader::getInt);
                } else if ("mentioned".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessageMention.mentioned = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("mentionText".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessageMention.mentionText = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphChatMessageMention.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphChatMessageMention;
        });
    }
}
