// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents chat message hosted content.
 */
@Fluent
public final class MicrosoftGraphChatMessageHostedContent extends MicrosoftGraphEntity {
    /*
     * chatMessageHostedContent
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphChatMessageHostedContent class.
     */
    public MicrosoftGraphChatMessageHostedContent() {
    }

    /**
     * Get the additionalProperties property: chatMessageHostedContent.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: chatMessageHostedContent.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphChatMessageHostedContent object itself.
     */
    public MicrosoftGraphChatMessageHostedContent withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphChatMessageHostedContent withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphChatMessageHostedContent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphChatMessageHostedContent if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphChatMessageHostedContent.
     */
    public static MicrosoftGraphChatMessageHostedContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphChatMessageHostedContent deserializedMicrosoftGraphChatMessageHostedContent
                = new MicrosoftGraphChatMessageHostedContent();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessageHostedContent.withId(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphChatMessageHostedContent.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphChatMessageHostedContent;
        });
    }
}
