// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents a chat message attachment.
 */
@Fluent
public final class MicrosoftGraphChatMessageAttachment
    implements JsonSerializable<MicrosoftGraphChatMessageAttachment> {
    /*
     * The content of the attachment. If the attachment is a rich card, set the property to the rich card object. This
     * property and contentUrl are mutually exclusive.
     */
    private String content;

    /*
     * The media type of the content attachment. It can have the following values: reference: Attachment is a link to
     * another file. Populate the contentURL with the link to the object.file: Raw file attachment. Populate the
     * contenturl field with the base64 encoding of the file in data: format.image/: Image type with the type of the
     * image specified ex: image/png, image/jpeg, image/gif. Populate the contentUrl field with the base64 encoding of
     * the file in data: format.video/: Video type with the format specified. Ex: video/mp4. Populate the contentUrl
     * field with the base64 encoding of the file in data: format.audio/: Audio type with the format specified. Ex:
     * audio/wmw. Populate the contentUrl field with the base64 encoding of the file in data: format.application/card
     * type: Rich card attachment type with the card type specifying the exact card format to use. Set content with the
     * json format of the card. Supported values for card type include:application/vnd.microsoft.card.adaptive: A rich
     * card that can contain any combination of text, speech, images,,buttons, and input fields. Set the content
     * property to,an AdaptiveCard object.application/vnd.microsoft.card.animation: A rich card that plays animation.
     * Set the content property,to an AnimationCardobject.application/vnd.microsoft.card.audio: A rich card that plays
     * audio files. Set the content property,to an AudioCard object.application/vnd.microsoft.card.video: A rich card
     * that plays videos. Set the content property,to a VideoCard object.application/vnd.microsoft.card.hero: A Hero
     * card. Set the content property to a HeroCard object.application/vnd.microsoft.card.thumbnail: A Thumbnail card.
     * Set the content property to a ThumbnailCard object.application/vnd.microsoft.com.card.receipt: A Receipt card.
     * Set the content property to a ReceiptCard object.application/vnd.microsoft.com.card.signin: A user Sign In card.
     * Set the content property to a SignInCard object.
     */
    private String contentType;

    /*
     * URL for the content of the attachment. Supported protocols: http, https, file and data.
     */
    private String contentUrl;

    /*
     * Read-only. Unique id of the attachment.
     */
    private String id;

    /*
     * Name of the attachment.
     */
    private String name;

    /*
     * URL to a thumbnail image that the channel can use if it supports using an alternative, smaller form of content or
     * contentUrl. For example, if you set contentType to application/word and set contentUrl to the location of the
     * Word document, you might include a thumbnail image that represents the document. The channel could display the
     * thumbnail image instead of the document. When the user clicks the image, the channel would open the document.
     */
    private String thumbnailUrl;

    /*
     * chatMessageAttachment
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphChatMessageAttachment class.
     */
    public MicrosoftGraphChatMessageAttachment() {
    }

    /**
     * Get the content property: The content of the attachment. If the attachment is a rich card, set the property to
     * the rich card object. This property and contentUrl are mutually exclusive.
     * 
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: The content of the attachment. If the attachment is a rich card, set the property to
     * the rich card object. This property and contentUrl are mutually exclusive.
     * 
     * @param content the content value to set.
     * @return the MicrosoftGraphChatMessageAttachment object itself.
     */
    public MicrosoftGraphChatMessageAttachment withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the contentType property: The media type of the content attachment. It can have the following values:
     * reference: Attachment is a link to another file. Populate the contentURL with the link to the object.file: Raw
     * file attachment. Populate the contenturl field with the base64 encoding of the file in data: format.image/: Image
     * type with the type of the image specified ex: image/png, image/jpeg, image/gif. Populate the contentUrl field
     * with the base64 encoding of the file in data: format.video/: Video type with the format specified. Ex: video/mp4.
     * Populate the contentUrl field with the base64 encoding of the file in data: format.audio/: Audio type with the
     * format specified. Ex: audio/wmw. Populate the contentUrl field with the base64 encoding of the file in data:
     * format.application/card type: Rich card attachment type with the card type specifying the exact card format to
     * use. Set content with the json format of the card. Supported values for card type
     * include:application/vnd.microsoft.card.adaptive: A rich card that can contain any combination of text, speech,
     * images,,buttons, and input fields. Set the content property to,an AdaptiveCard
     * object.application/vnd.microsoft.card.animation: A rich card that plays animation. Set the content property,to an
     * AnimationCardobject.application/vnd.microsoft.card.audio: A rich card that plays audio files. Set the content
     * property,to an AudioCard object.application/vnd.microsoft.card.video: A rich card that plays videos. Set the
     * content property,to a VideoCard object.application/vnd.microsoft.card.hero: A Hero card. Set the content property
     * to a HeroCard object.application/vnd.microsoft.card.thumbnail: A Thumbnail card. Set the content property to a
     * ThumbnailCard object.application/vnd.microsoft.com.card.receipt: A Receipt card. Set the content property to a
     * ReceiptCard object.application/vnd.microsoft.com.card.signin: A user Sign In card. Set the content property to a
     * SignInCard object.
     * 
     * @return the contentType value.
     */
    public String contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The media type of the content attachment. It can have the following values:
     * reference: Attachment is a link to another file. Populate the contentURL with the link to the object.file: Raw
     * file attachment. Populate the contenturl field with the base64 encoding of the file in data: format.image/: Image
     * type with the type of the image specified ex: image/png, image/jpeg, image/gif. Populate the contentUrl field
     * with the base64 encoding of the file in data: format.video/: Video type with the format specified. Ex: video/mp4.
     * Populate the contentUrl field with the base64 encoding of the file in data: format.audio/: Audio type with the
     * format specified. Ex: audio/wmw. Populate the contentUrl field with the base64 encoding of the file in data:
     * format.application/card type: Rich card attachment type with the card type specifying the exact card format to
     * use. Set content with the json format of the card. Supported values for card type
     * include:application/vnd.microsoft.card.adaptive: A rich card that can contain any combination of text, speech,
     * images,,buttons, and input fields. Set the content property to,an AdaptiveCard
     * object.application/vnd.microsoft.card.animation: A rich card that plays animation. Set the content property,to an
     * AnimationCardobject.application/vnd.microsoft.card.audio: A rich card that plays audio files. Set the content
     * property,to an AudioCard object.application/vnd.microsoft.card.video: A rich card that plays videos. Set the
     * content property,to a VideoCard object.application/vnd.microsoft.card.hero: A Hero card. Set the content property
     * to a HeroCard object.application/vnd.microsoft.card.thumbnail: A Thumbnail card. Set the content property to a
     * ThumbnailCard object.application/vnd.microsoft.com.card.receipt: A Receipt card. Set the content property to a
     * ReceiptCard object.application/vnd.microsoft.com.card.signin: A user Sign In card. Set the content property to a
     * SignInCard object.
     * 
     * @param contentType the contentType value to set.
     * @return the MicrosoftGraphChatMessageAttachment object itself.
     */
    public MicrosoftGraphChatMessageAttachment withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the contentUrl property: URL for the content of the attachment. Supported protocols: http, https, file and
     * data.
     * 
     * @return the contentUrl value.
     */
    public String contentUrl() {
        return this.contentUrl;
    }

    /**
     * Set the contentUrl property: URL for the content of the attachment. Supported protocols: http, https, file and
     * data.
     * 
     * @param contentUrl the contentUrl value to set.
     * @return the MicrosoftGraphChatMessageAttachment object itself.
     */
    public MicrosoftGraphChatMessageAttachment withContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
        return this;
    }

    /**
     * Get the id property: Read-only. Unique id of the attachment.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Read-only. Unique id of the attachment.
     * 
     * @param id the id value to set.
     * @return the MicrosoftGraphChatMessageAttachment object itself.
     */
    public MicrosoftGraphChatMessageAttachment withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Name of the attachment.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the attachment.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphChatMessageAttachment object itself.
     */
    public MicrosoftGraphChatMessageAttachment withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the thumbnailUrl property: URL to a thumbnail image that the channel can use if it supports using an
     * alternative, smaller form of content or contentUrl. For example, if you set contentType to application/word and
     * set contentUrl to the location of the Word document, you might include a thumbnail image that represents the
     * document. The channel could display the thumbnail image instead of the document. When the user clicks the image,
     * the channel would open the document.
     * 
     * @return the thumbnailUrl value.
     */
    public String thumbnailUrl() {
        return this.thumbnailUrl;
    }

    /**
     * Set the thumbnailUrl property: URL to a thumbnail image that the channel can use if it supports using an
     * alternative, smaller form of content or contentUrl. For example, if you set contentType to application/word and
     * set contentUrl to the location of the Word document, you might include a thumbnail image that represents the
     * document. The channel could display the thumbnail image instead of the document. When the user clicks the image,
     * the channel would open the document.
     * 
     * @param thumbnailUrl the thumbnailUrl value to set.
     * @return the MicrosoftGraphChatMessageAttachment object itself.
     */
    public MicrosoftGraphChatMessageAttachment withThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: chatMessageAttachment.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: chatMessageAttachment.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphChatMessageAttachment object itself.
     */
    public MicrosoftGraphChatMessageAttachment withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("contentUrl", this.contentUrl);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("thumbnailUrl", this.thumbnailUrl);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphChatMessageAttachment from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphChatMessageAttachment if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphChatMessageAttachment.
     */
    public static MicrosoftGraphChatMessageAttachment fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphChatMessageAttachment deserializedMicrosoftGraphChatMessageAttachment
                = new MicrosoftGraphChatMessageAttachment();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("content".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessageAttachment.content = reader.getString();
                } else if ("contentType".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessageAttachment.contentType = reader.getString();
                } else if ("contentUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessageAttachment.contentUrl = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessageAttachment.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessageAttachment.name = reader.getString();
                } else if ("thumbnailUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphChatMessageAttachment.thumbnailUrl = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphChatMessageAttachment.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphChatMessageAttachment;
        });
    }
}
