// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Represents a certificate authority.
 */
@Fluent
public final class MicrosoftGraphCertificateAuthority implements JsonSerializable<MicrosoftGraphCertificateAuthority> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    /*
     * Required. The base64 encoded string representing the public certificate.
     */
    private Base64Url certificate;

    /*
     * The URL of the certificate revocation list.
     */
    private String certificateRevocationListUrl;

    /*
     * The URL contains the list of all revoked certificates since the last time a full certificate revocaton list was
     * created.
     */
    private String deltaCertificateRevocationListUrl;

    /*
     * Required. true if the trusted certificate is a root authority, false if the trusted certificate is an
     * intermediate authority.
     */
    private Boolean isRootAuthority;

    /*
     * The issuer of the certificate, calculated from the certificate value. Read-only.
     */
    private String issuer;

    /*
     * The subject key identifier of the certificate, calculated from the certificate value. Read-only.
     */
    private String issuerSki;

    /*
     * certificateAuthority
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphCertificateAuthority class.
     */
    public MicrosoftGraphCertificateAuthority() {
    }

    /**
     * Get the certificate property: Required. The base64 encoded string representing the public certificate.
     * 
     * @return the certificate value.
     */
    public byte[] certificate() {
        if (this.certificate == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.certificate.decodedBytes();
    }

    /**
     * Set the certificate property: Required. The base64 encoded string representing the public certificate.
     * 
     * @param certificate the certificate value to set.
     * @return the MicrosoftGraphCertificateAuthority object itself.
     */
    public MicrosoftGraphCertificateAuthority withCertificate(byte[] certificate) {
        if (certificate == null) {
            this.certificate = null;
        } else {
            this.certificate = Base64Url.encode(CoreUtils.clone(certificate));
        }
        return this;
    }

    /**
     * Get the certificateRevocationListUrl property: The URL of the certificate revocation list.
     * 
     * @return the certificateRevocationListUrl value.
     */
    public String certificateRevocationListUrl() {
        return this.certificateRevocationListUrl;
    }

    /**
     * Set the certificateRevocationListUrl property: The URL of the certificate revocation list.
     * 
     * @param certificateRevocationListUrl the certificateRevocationListUrl value to set.
     * @return the MicrosoftGraphCertificateAuthority object itself.
     */
    public MicrosoftGraphCertificateAuthority withCertificateRevocationListUrl(String certificateRevocationListUrl) {
        this.certificateRevocationListUrl = certificateRevocationListUrl;
        return this;
    }

    /**
     * Get the deltaCertificateRevocationListUrl property: The URL contains the list of all revoked certificates since
     * the last time a full certificate revocaton list was created.
     * 
     * @return the deltaCertificateRevocationListUrl value.
     */
    public String deltaCertificateRevocationListUrl() {
        return this.deltaCertificateRevocationListUrl;
    }

    /**
     * Set the deltaCertificateRevocationListUrl property: The URL contains the list of all revoked certificates since
     * the last time a full certificate revocaton list was created.
     * 
     * @param deltaCertificateRevocationListUrl the deltaCertificateRevocationListUrl value to set.
     * @return the MicrosoftGraphCertificateAuthority object itself.
     */
    public MicrosoftGraphCertificateAuthority
        withDeltaCertificateRevocationListUrl(String deltaCertificateRevocationListUrl) {
        this.deltaCertificateRevocationListUrl = deltaCertificateRevocationListUrl;
        return this;
    }

    /**
     * Get the isRootAuthority property: Required. true if the trusted certificate is a root authority, false if the
     * trusted certificate is an intermediate authority.
     * 
     * @return the isRootAuthority value.
     */
    public Boolean isRootAuthority() {
        return this.isRootAuthority;
    }

    /**
     * Set the isRootAuthority property: Required. true if the trusted certificate is a root authority, false if the
     * trusted certificate is an intermediate authority.
     * 
     * @param isRootAuthority the isRootAuthority value to set.
     * @return the MicrosoftGraphCertificateAuthority object itself.
     */
    public MicrosoftGraphCertificateAuthority withIsRootAuthority(Boolean isRootAuthority) {
        this.isRootAuthority = isRootAuthority;
        return this;
    }

    /**
     * Get the issuer property: The issuer of the certificate, calculated from the certificate value. Read-only.
     * 
     * @return the issuer value.
     */
    public String issuer() {
        return this.issuer;
    }

    /**
     * Set the issuer property: The issuer of the certificate, calculated from the certificate value. Read-only.
     * 
     * @param issuer the issuer value to set.
     * @return the MicrosoftGraphCertificateAuthority object itself.
     */
    public MicrosoftGraphCertificateAuthority withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    /**
     * Get the issuerSki property: The subject key identifier of the certificate, calculated from the certificate value.
     * Read-only.
     * 
     * @return the issuerSki value.
     */
    public String issuerSki() {
        return this.issuerSki;
    }

    /**
     * Set the issuerSki property: The subject key identifier of the certificate, calculated from the certificate value.
     * Read-only.
     * 
     * @param issuerSki the issuerSki value to set.
     * @return the MicrosoftGraphCertificateAuthority object itself.
     */
    public MicrosoftGraphCertificateAuthority withIssuerSki(String issuerSki) {
        this.issuerSki = issuerSki;
        return this;
    }

    /**
     * Get the additionalProperties property: certificateAuthority.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: certificateAuthority.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphCertificateAuthority object itself.
     */
    public MicrosoftGraphCertificateAuthority withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("certificate", Objects.toString(this.certificate, null));
        jsonWriter.writeStringField("certificateRevocationListUrl", this.certificateRevocationListUrl);
        jsonWriter.writeStringField("deltaCertificateRevocationListUrl", this.deltaCertificateRevocationListUrl);
        jsonWriter.writeBooleanField("isRootAuthority", this.isRootAuthority);
        jsonWriter.writeStringField("issuer", this.issuer);
        jsonWriter.writeStringField("issuerSki", this.issuerSki);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphCertificateAuthority from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphCertificateAuthority if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphCertificateAuthority.
     */
    public static MicrosoftGraphCertificateAuthority fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphCertificateAuthority deserializedMicrosoftGraphCertificateAuthority
                = new MicrosoftGraphCertificateAuthority();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("certificate".equals(fieldName)) {
                    deserializedMicrosoftGraphCertificateAuthority.certificate
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("certificateRevocationListUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphCertificateAuthority.certificateRevocationListUrl = reader.getString();
                } else if ("deltaCertificateRevocationListUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphCertificateAuthority.deltaCertificateRevocationListUrl
                        = reader.getString();
                } else if ("isRootAuthority".equals(fieldName)) {
                    deserializedMicrosoftGraphCertificateAuthority.isRootAuthority
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("issuer".equals(fieldName)) {
                    deserializedMicrosoftGraphCertificateAuthority.issuer = reader.getString();
                } else if ("issuerSki".equals(fieldName)) {
                    deserializedMicrosoftGraphCertificateAuthority.issuerSki = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphCertificateAuthority.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphCertificateAuthority;
        });
    }
}
