// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Represents an attendee base.
 */
@Fluent
public class MicrosoftGraphAttendeeBase extends MicrosoftGraphRecipient {
    /*
     * attendeeType
     */
    private MicrosoftGraphAttendeeType type;

    /*
     * attendeeBase
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphAttendeeBase class.
     */
    public MicrosoftGraphAttendeeBase() {
    }

    /**
     * Get the type property: attendeeType.
     * 
     * @return the type value.
     */
    public MicrosoftGraphAttendeeType type() {
        return this.type;
    }

    /**
     * Set the type property: attendeeType.
     * 
     * @param type the type value to set.
     * @return the MicrosoftGraphAttendeeBase object itself.
     */
    public MicrosoftGraphAttendeeBase withType(MicrosoftGraphAttendeeType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: attendeeBase.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: attendeeBase.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAttendeeBase object itself.
     */
    public MicrosoftGraphAttendeeBase withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphAttendeeBase withEmailAddress(MicrosoftGraphEmailAddress emailAddress) {
        super.withEmailAddress(emailAddress);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("emailAddress", emailAddress());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphAttendeeBase from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphAttendeeBase if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphAttendeeBase.
     */
    public static MicrosoftGraphAttendeeBase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphAttendeeBase deserializedMicrosoftGraphAttendeeBase = new MicrosoftGraphAttendeeBase();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("emailAddress".equals(fieldName)) {
                    deserializedMicrosoftGraphAttendeeBase
                        .withEmailAddress(MicrosoftGraphEmailAddress.fromJson(reader));
                } else if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphAttendeeBase.type
                        = MicrosoftGraphAttendeeType.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphAttendeeBase.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphAttendeeBase;
        });
    }
}
