// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * The ApplicationsCheckMemberGroupsRequestBody model.
 */
@Fluent
public final class ApplicationsCheckMemberGroupsRequestBody
    implements JsonSerializable<ApplicationsCheckMemberGroupsRequestBody> {
    /*
     * The groupIds property.
     */
    private List<String> groupIds;

    /*
     * Dictionary of <AnyObject>
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of ApplicationsCheckMemberGroupsRequestBody class.
     */
    public ApplicationsCheckMemberGroupsRequestBody() {
    }

    /**
     * Get the groupIds property: The groupIds property.
     * 
     * @return the groupIds value.
     */
    public List<String> groupIds() {
        return this.groupIds;
    }

    /**
     * Set the groupIds property: The groupIds property.
     * 
     * @param groupIds the groupIds value to set.
     * @return the ApplicationsCheckMemberGroupsRequestBody object itself.
     */
    public ApplicationsCheckMemberGroupsRequestBody withGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    /**
     * Get the additionalProperties property: Dictionary of &lt;AnyObject&gt;.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Dictionary of &lt;AnyObject&gt;.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the ApplicationsCheckMemberGroupsRequestBody object itself.
     */
    public ApplicationsCheckMemberGroupsRequestBody withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("groupIds", this.groupIds, (writer, element) -> writer.writeString(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationsCheckMemberGroupsRequestBody from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationsCheckMemberGroupsRequestBody if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationsCheckMemberGroupsRequestBody.
     */
    public static ApplicationsCheckMemberGroupsRequestBody fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationsCheckMemberGroupsRequestBody deserializedApplicationsCheckMemberGroupsRequestBody
                = new ApplicationsCheckMemberGroupsRequestBody();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("groupIds".equals(fieldName)) {
                    List<String> groupIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedApplicationsCheckMemberGroupsRequestBody.groupIds = groupIds;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedApplicationsCheckMemberGroupsRequestBody.additionalProperties = additionalProperties;

            return deserializedApplicationsCheckMemberGroupsRequestBody;
        });
    }
}
