// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Details of the principal.
 */
@Fluent
public final class ExpandedPropertiesPrincipal implements JsonSerializable<ExpandedPropertiesPrincipal> {
    /*
     * Id of the principal
     */
    private String id;

    /*
     * Display name of the principal
     */
    private String displayName;

    /*
     * Email id of the principal
     */
    private String email;

    /*
     * Type of the principal
     */
    private String type;

    /**
     * Creates an instance of ExpandedPropertiesPrincipal class.
     */
    public ExpandedPropertiesPrincipal() {
    }

    /**
     * Get the id property: Id of the principal.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Id of the principal.
     * 
     * @param id the id value to set.
     * @return the ExpandedPropertiesPrincipal object itself.
     */
    public ExpandedPropertiesPrincipal withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the displayName property: Display name of the principal.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Display name of the principal.
     * 
     * @param displayName the displayName value to set.
     * @return the ExpandedPropertiesPrincipal object itself.
     */
    public ExpandedPropertiesPrincipal withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the email property: Email id of the principal.
     * 
     * @return the email value.
     */
    public String email() {
        return this.email;
    }

    /**
     * Set the email property: Email id of the principal.
     * 
     * @param email the email value to set.
     * @return the ExpandedPropertiesPrincipal object itself.
     */
    public ExpandedPropertiesPrincipal withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Get the type property: Type of the principal.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Type of the principal.
     * 
     * @param type the type value to set.
     * @return the ExpandedPropertiesPrincipal object itself.
     */
    public ExpandedPropertiesPrincipal withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpandedPropertiesPrincipal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpandedPropertiesPrincipal if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpandedPropertiesPrincipal.
     */
    public static ExpandedPropertiesPrincipal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpandedPropertiesPrincipal deserializedExpandedPropertiesPrincipal = new ExpandedPropertiesPrincipal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedExpandedPropertiesPrincipal.id = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedExpandedPropertiesPrincipal.displayName = reader.getString();
                } else if ("email".equals(fieldName)) {
                    deserializedExpandedPropertiesPrincipal.email = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedExpandedPropertiesPrincipal.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpandedPropertiesPrincipal;
        });
    }
}
