// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

/**
 * keyCredential.
 */
@Fluent
public final class MicrosoftGraphKeyCredentialInner implements JsonSerializable<MicrosoftGraphKeyCredentialInner> {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    /*
     * Custom key identifier
     */
    private Base64Url customKeyIdentifier;

    /*
     * Friendly name for the key. Optional.
     */
    private String displayName;

    /*
     * The date and time at which the credential expires.The Timestamp type represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'
     */
    private OffsetDateTime endDateTime;

    /*
     * The certificate's raw data in byte array converted to Base64 string; for example,
     * [System.Convert]::ToBase64String($Cert.GetRawCertData()).
     */
    private Base64Url key;

    /*
     * The unique identifier (GUID) for the key.
     */
    private UUID keyId;

    /*
     * The date and time at which the credential becomes valid.The Timestamp type represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'
     */
    private OffsetDateTime startDateTime;

    /*
     * The type of key credential; for example, 'Symmetric'.
     */
    private String type;

    /*
     * A string that describes the purpose for which the key can be used; for example, 'Verify'.
     */
    private String usage;

    /*
     * keyCredential
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphKeyCredentialInner class.
     */
    public MicrosoftGraphKeyCredentialInner() {
    }

    /**
     * Get the customKeyIdentifier property: Custom key identifier.
     * 
     * @return the customKeyIdentifier value.
     */
    public byte[] customKeyIdentifier() {
        if (this.customKeyIdentifier == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.customKeyIdentifier.decodedBytes();
    }

    /**
     * Set the customKeyIdentifier property: Custom key identifier.
     * 
     * @param customKeyIdentifier the customKeyIdentifier value to set.
     * @return the MicrosoftGraphKeyCredentialInner object itself.
     */
    public MicrosoftGraphKeyCredentialInner withCustomKeyIdentifier(byte[] customKeyIdentifier) {
        if (customKeyIdentifier == null) {
            this.customKeyIdentifier = null;
        } else {
            this.customKeyIdentifier = Base64Url.encode(CoreUtils.clone(customKeyIdentifier));
        }
        return this;
    }

    /**
     * Get the displayName property: Friendly name for the key. Optional.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Friendly name for the key. Optional.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphKeyCredentialInner object itself.
     */
    public MicrosoftGraphKeyCredentialInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the endDateTime property: The date and time at which the credential expires.The Timestamp type represents
     * date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1,
     * 2014 would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @return the endDateTime value.
     */
    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    /**
     * Set the endDateTime property: The date and time at which the credential expires.The Timestamp type represents
     * date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1,
     * 2014 would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @param endDateTime the endDateTime value to set.
     * @return the MicrosoftGraphKeyCredentialInner object itself.
     */
    public MicrosoftGraphKeyCredentialInner withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    /**
     * Get the key property: The certificate's raw data in byte array converted to Base64 string; for example,
     * [System.Convert]::ToBase64String($Cert.GetRawCertData()).
     * 
     * @return the key value.
     */
    public byte[] key() {
        if (this.key == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.key.decodedBytes();
    }

    /**
     * Set the key property: The certificate's raw data in byte array converted to Base64 string; for example,
     * [System.Convert]::ToBase64String($Cert.GetRawCertData()).
     * 
     * @param key the key value to set.
     * @return the MicrosoftGraphKeyCredentialInner object itself.
     */
    public MicrosoftGraphKeyCredentialInner withKey(byte[] key) {
        if (key == null) {
            this.key = null;
        } else {
            this.key = Base64Url.encode(CoreUtils.clone(key));
        }
        return this;
    }

    /**
     * Get the keyId property: The unique identifier (GUID) for the key.
     * 
     * @return the keyId value.
     */
    public UUID keyId() {
        return this.keyId;
    }

    /**
     * Set the keyId property: The unique identifier (GUID) for the key.
     * 
     * @param keyId the keyId value to set.
     * @return the MicrosoftGraphKeyCredentialInner object itself.
     */
    public MicrosoftGraphKeyCredentialInner withKeyId(UUID keyId) {
        this.keyId = keyId;
        return this;
    }

    /**
     * Get the startDateTime property: The date and time at which the credential becomes valid.The Timestamp type
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: The date and time at which the credential becomes valid.The Timestamp type
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphKeyCredentialInner object itself.
     */
    public MicrosoftGraphKeyCredentialInner withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the type property: The type of key credential; for example, 'Symmetric'.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of key credential; for example, 'Symmetric'.
     * 
     * @param type the type value to set.
     * @return the MicrosoftGraphKeyCredentialInner object itself.
     */
    public MicrosoftGraphKeyCredentialInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the usage property: A string that describes the purpose for which the key can be used; for example, 'Verify'.
     * 
     * @return the usage value.
     */
    public String usage() {
        return this.usage;
    }

    /**
     * Set the usage property: A string that describes the purpose for which the key can be used; for example, 'Verify'.
     * 
     * @param usage the usage value to set.
     * @return the MicrosoftGraphKeyCredentialInner object itself.
     */
    public MicrosoftGraphKeyCredentialInner withUsage(String usage) {
        this.usage = usage;
        return this;
    }

    /**
     * Get the additionalProperties property: keyCredential.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: keyCredential.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphKeyCredentialInner object itself.
     */
    public MicrosoftGraphKeyCredentialInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("customKeyIdentifier", Objects.toString(this.customKeyIdentifier, null));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("endDateTime",
            this.endDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime));
        jsonWriter.writeStringField("key", Objects.toString(this.key, null));
        jsonWriter.writeStringField("keyId", Objects.toString(this.keyId, null));
        jsonWriter.writeStringField("startDateTime",
            this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("usage", this.usage);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphKeyCredentialInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphKeyCredentialInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphKeyCredentialInner.
     */
    public static MicrosoftGraphKeyCredentialInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphKeyCredentialInner deserializedMicrosoftGraphKeyCredentialInner
                = new MicrosoftGraphKeyCredentialInner();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("customKeyIdentifier".equals(fieldName)) {
                    deserializedMicrosoftGraphKeyCredentialInner.customKeyIdentifier
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphKeyCredentialInner.displayName = reader.getString();
                } else if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphKeyCredentialInner.endDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("key".equals(fieldName)) {
                    deserializedMicrosoftGraphKeyCredentialInner.key
                        = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                } else if ("keyId".equals(fieldName)) {
                    deserializedMicrosoftGraphKeyCredentialInner.keyId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphKeyCredentialInner.startDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphKeyCredentialInner.type = reader.getString();
                } else if ("usage".equals(fieldName)) {
                    deserializedMicrosoftGraphKeyCredentialInner.usage = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphKeyCredentialInner.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphKeyCredentialInner;
        });
    }
}
