// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * emailAddress.
 */
@Fluent
public final class MicrosoftGraphEmailAddress implements JsonSerializable<MicrosoftGraphEmailAddress> {
    /*
     * The email address of the person or entity.
     */
    private String address;

    /*
     * The display name of the person or entity.
     */
    private String name;

    /*
     * emailAddress
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphEmailAddress class.
     */
    public MicrosoftGraphEmailAddress() {
    }

    /**
     * Get the address property: The email address of the person or entity.
     * 
     * @return the address value.
     */
    public String address() {
        return this.address;
    }

    /**
     * Set the address property: The email address of the person or entity.
     * 
     * @param address the address value to set.
     * @return the MicrosoftGraphEmailAddress object itself.
     */
    public MicrosoftGraphEmailAddress withAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * Get the name property: The display name of the person or entity.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The display name of the person or entity.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphEmailAddress object itself.
     */
    public MicrosoftGraphEmailAddress withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the additionalProperties property: emailAddress.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: emailAddress.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphEmailAddress object itself.
     */
    public MicrosoftGraphEmailAddress withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeStringField("name", this.name);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphEmailAddress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphEmailAddress if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphEmailAddress.
     */
    public static MicrosoftGraphEmailAddress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphEmailAddress deserializedMicrosoftGraphEmailAddress = new MicrosoftGraphEmailAddress();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("address".equals(fieldName)) {
                    deserializedMicrosoftGraphEmailAddress.address = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphEmailAddress.name = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphEmailAddress.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphEmailAddress;
        });
    }
}
