// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The detail of a user.
 */
@Fluent
public final class UserSet implements JsonSerializable<UserSet> {
    /*
     * The type of user.
     */
    private UserType userType;

    /*
     * The value indicating whether the user is a backup fallback approver
     */
    private Boolean isBackup;

    /*
     * The object id of the user.
     */
    private String id;

    /*
     * The description of the user.
     */
    private String description;

    /**
     * Creates an instance of UserSet class.
     */
    public UserSet() {
    }

    /**
     * Get the userType property: The type of user.
     * 
     * @return the userType value.
     */
    public UserType userType() {
        return this.userType;
    }

    /**
     * Set the userType property: The type of user.
     * 
     * @param userType the userType value to set.
     * @return the UserSet object itself.
     */
    public UserSet withUserType(UserType userType) {
        this.userType = userType;
        return this;
    }

    /**
     * Get the isBackup property: The value indicating whether the user is a backup fallback approver.
     * 
     * @return the isBackup value.
     */
    public Boolean isBackup() {
        return this.isBackup;
    }

    /**
     * Set the isBackup property: The value indicating whether the user is a backup fallback approver.
     * 
     * @param isBackup the isBackup value to set.
     * @return the UserSet object itself.
     */
    public UserSet withIsBackup(Boolean isBackup) {
        this.isBackup = isBackup;
        return this;
    }

    /**
     * Get the id property: The object id of the user.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The object id of the user.
     * 
     * @param id the id value to set.
     * @return the UserSet object itself.
     */
    public UserSet withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the description property: The description of the user.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of the user.
     * 
     * @param description the description value to set.
     * @return the UserSet object itself.
     */
    public UserSet withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userType", this.userType == null ? null : this.userType.toString());
        jsonWriter.writeBooleanField("isBackup", this.isBackup);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserSet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserSet if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the UserSet.
     */
    public static UserSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserSet deserializedUserSet = new UserSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("userType".equals(fieldName)) {
                    deserializedUserSet.userType = UserType.fromString(reader.getString());
                } else if ("isBackup".equals(fieldName)) {
                    deserializedUserSet.isBackup = reader.getNullable(JsonReader::getBoolean);
                } else if ("id".equals(fieldName)) {
                    deserializedUserSet.id = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedUserSet.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserSet;
        });
    }
}
