// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Expanded info of resource scope.
 */
@Immutable
public final class PolicyProperties implements JsonSerializable<PolicyProperties> {
    /*
     * Details of the resource scope
     */
    private PolicyPropertiesScope scope;

    /**
     * Creates an instance of PolicyProperties class.
     */
    public PolicyProperties() {
    }

    /**
     * Get the scope property: Details of the resource scope.
     * 
     * @return the scope value.
     */
    public PolicyPropertiesScope scope() {
        return this.scope;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scope() != null) {
            scope().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicyProperties.
     */
    public static PolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyProperties deserializedPolicyProperties = new PolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scope".equals(fieldName)) {
                    deserializedPolicyProperties.scope = PolicyPropertiesScope.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyProperties;
        });
    }
}
