// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * workbookTable.
 */
@Fluent
public final class MicrosoftGraphWorkbookTable extends MicrosoftGraphEntity {
    /*
     * Indicates whether the first column contains special formatting.
     */
    private Boolean highlightFirstColumn;

    /*
     * Indicates whether the last column contains special formatting.
     */
    private Boolean highlightLastColumn;

    /*
     * Legacy Id used in older Excle clients. The value of the identifier remains the same even when the table is
     * renamed. This property should be interpreted as an opaque string value and should not be parsed to any other
     * type. Read-only.
     */
    private String legacyId;

    /*
     * Name of the table.
     */
    private String name;

    /*
     * Indicates whether the columns show banded formatting in which odd columns are highlighted differently from even
     * ones to make reading the table easier.
     */
    private Boolean showBandedColumns;

    /*
     * Indicates whether the rows show banded formatting in which odd rows are highlighted differently from even ones to
     * make reading the table easier.
     */
    private Boolean showBandedRows;

    /*
     * Indicates whether the filter buttons are visible at the top of each column header. Setting this is only allowed
     * if the table contains a header row.
     */
    private Boolean showFilterButton;

    /*
     * Indicates whether the header row is visible or not. This value can be set to show or remove the header row.
     */
    private Boolean showHeaders;

    /*
     * Indicates whether the total row is visible or not. This value can be set to show or remove the total row.
     */
    private Boolean showTotals;

    /*
     * Constant value that represents the Table style. The possible values are: TableStyleLight1 thru TableStyleLight21,
     * TableStyleMedium1 thru TableStyleMedium28, TableStyleStyleDark1 thru TableStyleStyleDark11. A custom user-defined
     * style present in the workbook can also be specified.
     */
    private String style;

    /*
     * Represents a collection of all the columns in the table. Read-only.
     */
    private List<MicrosoftGraphWorkbookTableColumn> columns;

    /*
     * Represents a collection of all the rows in the table. Read-only.
     */
    private List<MicrosoftGraphWorkbookTableRow> rows;

    /*
     * workbookTableSort
     */
    private MicrosoftGraphWorkbookTableSort sort;

    /*
     * workbookWorksheet
     */
    private MicrosoftGraphWorkbookWorksheet worksheet;

    /*
     * workbookTable
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookTable class.
     */
    public MicrosoftGraphWorkbookTable() {
    }

    /**
     * Get the highlightFirstColumn property: Indicates whether the first column contains special formatting.
     * 
     * @return the highlightFirstColumn value.
     */
    public Boolean highlightFirstColumn() {
        return this.highlightFirstColumn;
    }

    /**
     * Set the highlightFirstColumn property: Indicates whether the first column contains special formatting.
     * 
     * @param highlightFirstColumn the highlightFirstColumn value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withHighlightFirstColumn(Boolean highlightFirstColumn) {
        this.highlightFirstColumn = highlightFirstColumn;
        return this;
    }

    /**
     * Get the highlightLastColumn property: Indicates whether the last column contains special formatting.
     * 
     * @return the highlightLastColumn value.
     */
    public Boolean highlightLastColumn() {
        return this.highlightLastColumn;
    }

    /**
     * Set the highlightLastColumn property: Indicates whether the last column contains special formatting.
     * 
     * @param highlightLastColumn the highlightLastColumn value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withHighlightLastColumn(Boolean highlightLastColumn) {
        this.highlightLastColumn = highlightLastColumn;
        return this;
    }

    /**
     * Get the legacyId property: Legacy Id used in older Excle clients. The value of the identifier remains the same
     * even when the table is renamed. This property should be interpreted as an opaque string value and should not be
     * parsed to any other type. Read-only.
     * 
     * @return the legacyId value.
     */
    public String legacyId() {
        return this.legacyId;
    }

    /**
     * Set the legacyId property: Legacy Id used in older Excle clients. The value of the identifier remains the same
     * even when the table is renamed. This property should be interpreted as an opaque string value and should not be
     * parsed to any other type. Read-only.
     * 
     * @param legacyId the legacyId value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withLegacyId(String legacyId) {
        this.legacyId = legacyId;
        return this;
    }

    /**
     * Get the name property: Name of the table.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the table.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the showBandedColumns property: Indicates whether the columns show banded formatting in which odd columns are
     * highlighted differently from even ones to make reading the table easier.
     * 
     * @return the showBandedColumns value.
     */
    public Boolean showBandedColumns() {
        return this.showBandedColumns;
    }

    /**
     * Set the showBandedColumns property: Indicates whether the columns show banded formatting in which odd columns are
     * highlighted differently from even ones to make reading the table easier.
     * 
     * @param showBandedColumns the showBandedColumns value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withShowBandedColumns(Boolean showBandedColumns) {
        this.showBandedColumns = showBandedColumns;
        return this;
    }

    /**
     * Get the showBandedRows property: Indicates whether the rows show banded formatting in which odd rows are
     * highlighted differently from even ones to make reading the table easier.
     * 
     * @return the showBandedRows value.
     */
    public Boolean showBandedRows() {
        return this.showBandedRows;
    }

    /**
     * Set the showBandedRows property: Indicates whether the rows show banded formatting in which odd rows are
     * highlighted differently from even ones to make reading the table easier.
     * 
     * @param showBandedRows the showBandedRows value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withShowBandedRows(Boolean showBandedRows) {
        this.showBandedRows = showBandedRows;
        return this;
    }

    /**
     * Get the showFilterButton property: Indicates whether the filter buttons are visible at the top of each column
     * header. Setting this is only allowed if the table contains a header row.
     * 
     * @return the showFilterButton value.
     */
    public Boolean showFilterButton() {
        return this.showFilterButton;
    }

    /**
     * Set the showFilterButton property: Indicates whether the filter buttons are visible at the top of each column
     * header. Setting this is only allowed if the table contains a header row.
     * 
     * @param showFilterButton the showFilterButton value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withShowFilterButton(Boolean showFilterButton) {
        this.showFilterButton = showFilterButton;
        return this;
    }

    /**
     * Get the showHeaders property: Indicates whether the header row is visible or not. This value can be set to show
     * or remove the header row.
     * 
     * @return the showHeaders value.
     */
    public Boolean showHeaders() {
        return this.showHeaders;
    }

    /**
     * Set the showHeaders property: Indicates whether the header row is visible or not. This value can be set to show
     * or remove the header row.
     * 
     * @param showHeaders the showHeaders value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withShowHeaders(Boolean showHeaders) {
        this.showHeaders = showHeaders;
        return this;
    }

    /**
     * Get the showTotals property: Indicates whether the total row is visible or not. This value can be set to show or
     * remove the total row.
     * 
     * @return the showTotals value.
     */
    public Boolean showTotals() {
        return this.showTotals;
    }

    /**
     * Set the showTotals property: Indicates whether the total row is visible or not. This value can be set to show or
     * remove the total row.
     * 
     * @param showTotals the showTotals value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withShowTotals(Boolean showTotals) {
        this.showTotals = showTotals;
        return this;
    }

    /**
     * Get the style property: Constant value that represents the Table style. The possible values are: TableStyleLight1
     * thru TableStyleLight21, TableStyleMedium1 thru TableStyleMedium28, TableStyleStyleDark1 thru
     * TableStyleStyleDark11. A custom user-defined style present in the workbook can also be specified.
     * 
     * @return the style value.
     */
    public String style() {
        return this.style;
    }

    /**
     * Set the style property: Constant value that represents the Table style. The possible values are: TableStyleLight1
     * thru TableStyleLight21, TableStyleMedium1 thru TableStyleMedium28, TableStyleStyleDark1 thru
     * TableStyleStyleDark11. A custom user-defined style present in the workbook can also be specified.
     * 
     * @param style the style value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withStyle(String style) {
        this.style = style;
        return this;
    }

    /**
     * Get the columns property: Represents a collection of all the columns in the table. Read-only.
     * 
     * @return the columns value.
     */
    public List<MicrosoftGraphWorkbookTableColumn> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: Represents a collection of all the columns in the table. Read-only.
     * 
     * @param columns the columns value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withColumns(List<MicrosoftGraphWorkbookTableColumn> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Get the rows property: Represents a collection of all the rows in the table. Read-only.
     * 
     * @return the rows value.
     */
    public List<MicrosoftGraphWorkbookTableRow> rows() {
        return this.rows;
    }

    /**
     * Set the rows property: Represents a collection of all the rows in the table. Read-only.
     * 
     * @param rows the rows value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withRows(List<MicrosoftGraphWorkbookTableRow> rows) {
        this.rows = rows;
        return this;
    }

    /**
     * Get the sort property: workbookTableSort.
     * 
     * @return the sort value.
     */
    public MicrosoftGraphWorkbookTableSort sort() {
        return this.sort;
    }

    /**
     * Set the sort property: workbookTableSort.
     * 
     * @param sort the sort value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withSort(MicrosoftGraphWorkbookTableSort sort) {
        this.sort = sort;
        return this;
    }

    /**
     * Get the worksheet property: workbookWorksheet.
     * 
     * @return the worksheet value.
     */
    public MicrosoftGraphWorkbookWorksheet worksheet() {
        return this.worksheet;
    }

    /**
     * Set the worksheet property: workbookWorksheet.
     * 
     * @param worksheet the worksheet value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withWorksheet(MicrosoftGraphWorkbookWorksheet worksheet) {
        this.worksheet = worksheet;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookTable.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookTable.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookTable object itself.
     */
    public MicrosoftGraphWorkbookTable withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookTable withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (columns() != null) {
            columns().forEach(e -> e.validate());
        }
        if (rows() != null) {
            rows().forEach(e -> e.validate());
        }
        if (sort() != null) {
            sort().validate();
        }
        if (worksheet() != null) {
            worksheet().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeBooleanField("highlightFirstColumn", this.highlightFirstColumn);
        jsonWriter.writeBooleanField("highlightLastColumn", this.highlightLastColumn);
        jsonWriter.writeStringField("legacyId", this.legacyId);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("showBandedColumns", this.showBandedColumns);
        jsonWriter.writeBooleanField("showBandedRows", this.showBandedRows);
        jsonWriter.writeBooleanField("showFilterButton", this.showFilterButton);
        jsonWriter.writeBooleanField("showHeaders", this.showHeaders);
        jsonWriter.writeBooleanField("showTotals", this.showTotals);
        jsonWriter.writeStringField("style", this.style);
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("rows", this.rows, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("sort", this.sort);
        jsonWriter.writeJsonField("worksheet", this.worksheet);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookTable from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookTable if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookTable.
     */
    public static MicrosoftGraphWorkbookTable fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookTable deserializedMicrosoftGraphWorkbookTable = new MicrosoftGraphWorkbookTable();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.withId(reader.getString());
                } else if ("highlightFirstColumn".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.highlightFirstColumn
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("highlightLastColumn".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.highlightLastColumn
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("legacyId".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.legacyId = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.name = reader.getString();
                } else if ("showBandedColumns".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.showBandedColumns
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("showBandedRows".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.showBandedRows = reader.getNullable(JsonReader::getBoolean);
                } else if ("showFilterButton".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.showFilterButton
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("showHeaders".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.showHeaders = reader.getNullable(JsonReader::getBoolean);
                } else if ("showTotals".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.showTotals = reader.getNullable(JsonReader::getBoolean);
                } else if ("style".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.style = reader.getString();
                } else if ("columns".equals(fieldName)) {
                    List<MicrosoftGraphWorkbookTableColumn> columns
                        = reader.readArray(reader1 -> MicrosoftGraphWorkbookTableColumn.fromJson(reader1));
                    deserializedMicrosoftGraphWorkbookTable.columns = columns;
                } else if ("rows".equals(fieldName)) {
                    List<MicrosoftGraphWorkbookTableRow> rows
                        = reader.readArray(reader1 -> MicrosoftGraphWorkbookTableRow.fromJson(reader1));
                    deserializedMicrosoftGraphWorkbookTable.rows = rows;
                } else if ("sort".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.sort = MicrosoftGraphWorkbookTableSort.fromJson(reader);
                } else if ("worksheet".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookTable.worksheet
                        = MicrosoftGraphWorkbookWorksheet.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookTable.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookTable;
        });
    }
}
