// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * workbookChartLineFormat.
 */
@Fluent
public final class MicrosoftGraphWorkbookChartLineFormat extends MicrosoftGraphEntity {
    /*
     * HTML color code representing the color of lines in the chart.
     */
    private String color;

    /*
     * workbookChartLineFormat
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookChartLineFormat class.
     */
    public MicrosoftGraphWorkbookChartLineFormat() {
    }

    /**
     * Get the color property: HTML color code representing the color of lines in the chart.
     * 
     * @return the color value.
     */
    public String color() {
        return this.color;
    }

    /**
     * Set the color property: HTML color code representing the color of lines in the chart.
     * 
     * @param color the color value to set.
     * @return the MicrosoftGraphWorkbookChartLineFormat object itself.
     */
    public MicrosoftGraphWorkbookChartLineFormat withColor(String color) {
        this.color = color;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartLineFormat.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartLineFormat.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartLineFormat object itself.
     */
    public MicrosoftGraphWorkbookChartLineFormat withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookChartLineFormat withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("color", this.color);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookChartLineFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookChartLineFormat if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookChartLineFormat.
     */
    public static MicrosoftGraphWorkbookChartLineFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookChartLineFormat deserializedMicrosoftGraphWorkbookChartLineFormat
                = new MicrosoftGraphWorkbookChartLineFormat();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartLineFormat.withId(reader.getString());
                } else if ("color".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartLineFormat.color = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookChartLineFormat.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookChartLineFormat;
        });
    }
}
