// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * sectionGroup.
 */
@Fluent
public final class MicrosoftGraphSectionGroup extends MicrosoftGraphOnenoteEntityHierarchyModel {
    /*
     * The URL for the sectionGroups navigation property, which returns all the section groups in the section group.
     * Read-only.
     */
    private String sectionGroupsUrl;

    /*
     * The URL for the sections navigation property, which returns all the sections in the section group. Read-only.
     */
    private String sectionsUrl;

    /*
     * notebook
     */
    private MicrosoftGraphNotebook parentNotebook;

    /*
     * sectionGroup
     */
    private MicrosoftGraphSectionGroup parentSectionGroup;

    /*
     * The section groups in the section. Read-only. Nullable.
     */
    private List<MicrosoftGraphSectionGroup> sectionGroups;

    /*
     * The sections in the section group. Read-only. Nullable.
     */
    private List<MicrosoftGraphOnenoteSection> sections;

    /*
     * sectionGroup
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSectionGroup class.
     */
    public MicrosoftGraphSectionGroup() {
    }

    /**
     * Get the sectionGroupsUrl property: The URL for the sectionGroups navigation property, which returns all the
     * section groups in the section group. Read-only.
     * 
     * @return the sectionGroupsUrl value.
     */
    public String sectionGroupsUrl() {
        return this.sectionGroupsUrl;
    }

    /**
     * Set the sectionGroupsUrl property: The URL for the sectionGroups navigation property, which returns all the
     * section groups in the section group. Read-only.
     * 
     * @param sectionGroupsUrl the sectionGroupsUrl value to set.
     * @return the MicrosoftGraphSectionGroup object itself.
     */
    public MicrosoftGraphSectionGroup withSectionGroupsUrl(String sectionGroupsUrl) {
        this.sectionGroupsUrl = sectionGroupsUrl;
        return this;
    }

    /**
     * Get the sectionsUrl property: The URL for the sections navigation property, which returns all the sections in the
     * section group. Read-only.
     * 
     * @return the sectionsUrl value.
     */
    public String sectionsUrl() {
        return this.sectionsUrl;
    }

    /**
     * Set the sectionsUrl property: The URL for the sections navigation property, which returns all the sections in the
     * section group. Read-only.
     * 
     * @param sectionsUrl the sectionsUrl value to set.
     * @return the MicrosoftGraphSectionGroup object itself.
     */
    public MicrosoftGraphSectionGroup withSectionsUrl(String sectionsUrl) {
        this.sectionsUrl = sectionsUrl;
        return this;
    }

    /**
     * Get the parentNotebook property: notebook.
     * 
     * @return the parentNotebook value.
     */
    public MicrosoftGraphNotebook parentNotebook() {
        return this.parentNotebook;
    }

    /**
     * Set the parentNotebook property: notebook.
     * 
     * @param parentNotebook the parentNotebook value to set.
     * @return the MicrosoftGraphSectionGroup object itself.
     */
    public MicrosoftGraphSectionGroup withParentNotebook(MicrosoftGraphNotebook parentNotebook) {
        this.parentNotebook = parentNotebook;
        return this;
    }

    /**
     * Get the parentSectionGroup property: sectionGroup.
     * 
     * @return the parentSectionGroup value.
     */
    public MicrosoftGraphSectionGroup parentSectionGroup() {
        return this.parentSectionGroup;
    }

    /**
     * Set the parentSectionGroup property: sectionGroup.
     * 
     * @param parentSectionGroup the parentSectionGroup value to set.
     * @return the MicrosoftGraphSectionGroup object itself.
     */
    public MicrosoftGraphSectionGroup withParentSectionGroup(MicrosoftGraphSectionGroup parentSectionGroup) {
        this.parentSectionGroup = parentSectionGroup;
        return this;
    }

    /**
     * Get the sectionGroups property: The section groups in the section. Read-only. Nullable.
     * 
     * @return the sectionGroups value.
     */
    public List<MicrosoftGraphSectionGroup> sectionGroups() {
        return this.sectionGroups;
    }

    /**
     * Set the sectionGroups property: The section groups in the section. Read-only. Nullable.
     * 
     * @param sectionGroups the sectionGroups value to set.
     * @return the MicrosoftGraphSectionGroup object itself.
     */
    public MicrosoftGraphSectionGroup withSectionGroups(List<MicrosoftGraphSectionGroup> sectionGroups) {
        this.sectionGroups = sectionGroups;
        return this;
    }

    /**
     * Get the sections property: The sections in the section group. Read-only. Nullable.
     * 
     * @return the sections value.
     */
    public List<MicrosoftGraphOnenoteSection> sections() {
        return this.sections;
    }

    /**
     * Set the sections property: The sections in the section group. Read-only. Nullable.
     * 
     * @param sections the sections value to set.
     * @return the MicrosoftGraphSectionGroup object itself.
     */
    public MicrosoftGraphSectionGroup withSections(List<MicrosoftGraphOnenoteSection> sections) {
        this.sections = sections;
        return this;
    }

    /**
     * Get the additionalProperties property: sectionGroup.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: sectionGroup.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSectionGroup object itself.
     */
    public MicrosoftGraphSectionGroup withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSectionGroup withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSectionGroup withDisplayName(String displayName) {
        super.withDisplayName(displayName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSectionGroup withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSectionGroup withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSectionGroup withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSectionGroup withSelf(String self) {
        super.withSelf(self);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSectionGroup withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (parentNotebook() != null) {
            parentNotebook().validate();
        }
        if (parentSectionGroup() != null) {
            parentSectionGroup().validate();
        }
        if (sectionGroups() != null) {
            sectionGroups().forEach(e -> e.validate());
        }
        if (sections() != null) {
            sections().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("self", self());
        jsonWriter.writeStringField("createdDateTime",
            createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(createdDateTime()));
        jsonWriter.writeJsonField("createdBy", createdBy());
        jsonWriter.writeStringField("displayName", displayName());
        jsonWriter.writeJsonField("lastModifiedBy", lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime",
            lastModifiedDateTime() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(lastModifiedDateTime()));
        jsonWriter.writeStringField("sectionGroupsUrl", this.sectionGroupsUrl);
        jsonWriter.writeStringField("sectionsUrl", this.sectionsUrl);
        jsonWriter.writeJsonField("parentNotebook", this.parentNotebook);
        jsonWriter.writeJsonField("parentSectionGroup", this.parentSectionGroup);
        jsonWriter.writeArrayField("sectionGroups", this.sectionGroups, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("sections", this.sections, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSectionGroup from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSectionGroup if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSectionGroup.
     */
    public static MicrosoftGraphSectionGroup fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSectionGroup deserializedMicrosoftGraphSectionGroup = new MicrosoftGraphSectionGroup();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withId(reader.getString());
                } else if ("self".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withSelf(reader.getString());
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withCreatedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withCreatedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withDisplayName(reader.getString());
                } else if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup
                        .withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.withLastModifiedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("sectionGroupsUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.sectionGroupsUrl = reader.getString();
                } else if ("sectionsUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.sectionsUrl = reader.getString();
                } else if ("parentNotebook".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.parentNotebook = MicrosoftGraphNotebook.fromJson(reader);
                } else if ("parentSectionGroup".equals(fieldName)) {
                    deserializedMicrosoftGraphSectionGroup.parentSectionGroup
                        = MicrosoftGraphSectionGroup.fromJson(reader);
                } else if ("sectionGroups".equals(fieldName)) {
                    List<MicrosoftGraphSectionGroup> sectionGroups
                        = reader.readArray(reader1 -> MicrosoftGraphSectionGroup.fromJson(reader1));
                    deserializedMicrosoftGraphSectionGroup.sectionGroups = sectionGroups;
                } else if ("sections".equals(fieldName)) {
                    List<MicrosoftGraphOnenoteSection> sections
                        = reader.readArray(reader1 -> MicrosoftGraphOnenoteSection.fromJson(reader1));
                    deserializedMicrosoftGraphSectionGroup.sections = sections;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSectionGroup.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSectionGroup;
        });
    }
}
