// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * recurrenceRange.
 */
@Fluent
public final class MicrosoftGraphRecurrenceRange implements JsonSerializable<MicrosoftGraphRecurrenceRange> {
    /*
     * The date to stop applying the recurrence pattern. Depending on the recurrence pattern of the event, the last
     * occurrence of the meeting may not be this date. Required if type is endDate.
     */
    private LocalDate endDate;

    /*
     * The number of times to repeat the event. Required and must be positive if type is numbered.
     */
    private Integer numberOfOccurrences;

    /*
     * Time zone for the startDate and endDate properties. Optional. If not specified, the time zone of the event is
     * used.
     */
    private String recurrenceTimeZone;

    /*
     * The date to start applying the recurrence pattern. The first occurrence of the meeting may be this date or later,
     * depending on the recurrence pattern of the event. Must be the same value as the start property of the recurring
     * event. Required.
     */
    private LocalDate startDate;

    /*
     * recurrenceRangeType
     */
    private MicrosoftGraphRecurrenceRangeType type;

    /*
     * recurrenceRange
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphRecurrenceRange class.
     */
    public MicrosoftGraphRecurrenceRange() {
    }

    /**
     * Get the endDate property: The date to stop applying the recurrence pattern. Depending on the recurrence pattern
     * of the event, the last occurrence of the meeting may not be this date. Required if type is endDate.
     * 
     * @return the endDate value.
     */
    public LocalDate endDate() {
        return this.endDate;
    }

    /**
     * Set the endDate property: The date to stop applying the recurrence pattern. Depending on the recurrence pattern
     * of the event, the last occurrence of the meeting may not be this date. Required if type is endDate.
     * 
     * @param endDate the endDate value to set.
     * @return the MicrosoftGraphRecurrenceRange object itself.
     */
    public MicrosoftGraphRecurrenceRange withEndDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    /**
     * Get the numberOfOccurrences property: The number of times to repeat the event. Required and must be positive if
     * type is numbered.
     * 
     * @return the numberOfOccurrences value.
     */
    public Integer numberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    /**
     * Set the numberOfOccurrences property: The number of times to repeat the event. Required and must be positive if
     * type is numbered.
     * 
     * @param numberOfOccurrences the numberOfOccurrences value to set.
     * @return the MicrosoftGraphRecurrenceRange object itself.
     */
    public MicrosoftGraphRecurrenceRange withNumberOfOccurrences(Integer numberOfOccurrences) {
        this.numberOfOccurrences = numberOfOccurrences;
        return this;
    }

    /**
     * Get the recurrenceTimeZone property: Time zone for the startDate and endDate properties. Optional. If not
     * specified, the time zone of the event is used.
     * 
     * @return the recurrenceTimeZone value.
     */
    public String recurrenceTimeZone() {
        return this.recurrenceTimeZone;
    }

    /**
     * Set the recurrenceTimeZone property: Time zone for the startDate and endDate properties. Optional. If not
     * specified, the time zone of the event is used.
     * 
     * @param recurrenceTimeZone the recurrenceTimeZone value to set.
     * @return the MicrosoftGraphRecurrenceRange object itself.
     */
    public MicrosoftGraphRecurrenceRange withRecurrenceTimeZone(String recurrenceTimeZone) {
        this.recurrenceTimeZone = recurrenceTimeZone;
        return this;
    }

    /**
     * Get the startDate property: The date to start applying the recurrence pattern. The first occurrence of the
     * meeting may be this date or later, depending on the recurrence pattern of the event. Must be the same value as
     * the start property of the recurring event. Required.
     * 
     * @return the startDate value.
     */
    public LocalDate startDate() {
        return this.startDate;
    }

    /**
     * Set the startDate property: The date to start applying the recurrence pattern. The first occurrence of the
     * meeting may be this date or later, depending on the recurrence pattern of the event. Must be the same value as
     * the start property of the recurring event. Required.
     * 
     * @param startDate the startDate value to set.
     * @return the MicrosoftGraphRecurrenceRange object itself.
     */
    public MicrosoftGraphRecurrenceRange withStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    /**
     * Get the type property: recurrenceRangeType.
     * 
     * @return the type value.
     */
    public MicrosoftGraphRecurrenceRangeType type() {
        return this.type;
    }

    /**
     * Set the type property: recurrenceRangeType.
     * 
     * @param type the type value to set.
     * @return the MicrosoftGraphRecurrenceRange object itself.
     */
    public MicrosoftGraphRecurrenceRange withType(MicrosoftGraphRecurrenceRangeType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: recurrenceRange.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: recurrenceRange.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphRecurrenceRange object itself.
     */
    public MicrosoftGraphRecurrenceRange withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endDate", Objects.toString(this.endDate, null));
        jsonWriter.writeNumberField("numberOfOccurrences", this.numberOfOccurrences);
        jsonWriter.writeStringField("recurrenceTimeZone", this.recurrenceTimeZone);
        jsonWriter.writeStringField("startDate", Objects.toString(this.startDate, null));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphRecurrenceRange from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphRecurrenceRange if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphRecurrenceRange.
     */
    public static MicrosoftGraphRecurrenceRange fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphRecurrenceRange deserializedMicrosoftGraphRecurrenceRange
                = new MicrosoftGraphRecurrenceRange();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("endDate".equals(fieldName)) {
                    deserializedMicrosoftGraphRecurrenceRange.endDate
                        = reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                } else if ("numberOfOccurrences".equals(fieldName)) {
                    deserializedMicrosoftGraphRecurrenceRange.numberOfOccurrences
                        = reader.getNullable(JsonReader::getInt);
                } else if ("recurrenceTimeZone".equals(fieldName)) {
                    deserializedMicrosoftGraphRecurrenceRange.recurrenceTimeZone = reader.getString();
                } else if ("startDate".equals(fieldName)) {
                    deserializedMicrosoftGraphRecurrenceRange.startDate
                        = reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                } else if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphRecurrenceRange.type
                        = MicrosoftGraphRecurrenceRangeType.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphRecurrenceRange.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphRecurrenceRange;
        });
    }
}
