/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphResponseType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphResponseStatus
implements JsonSerializable<MicrosoftGraphResponseStatus> {
    private MicrosoftGraphResponseType response;
    private OffsetDateTime time;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphResponseType response() {
        return this.response;
    }

    public MicrosoftGraphResponseStatus withResponse(MicrosoftGraphResponseType response) {
        this.response = response;
        return this;
    }

    public OffsetDateTime time() {
        return this.time;
    }

    public MicrosoftGraphResponseStatus withTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphResponseStatus withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("response", this.response == null ? null : this.response.toString());
        jsonWriter.writeStringField("time", this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphResponseStatus fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphResponseStatus)jsonReader.readObject(reader -> {
            MicrosoftGraphResponseStatus deserializedMicrosoftGraphResponseStatus = new MicrosoftGraphResponseStatus();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("response".equals(fieldName)) {
                    deserializedMicrosoftGraphResponseStatus.response = MicrosoftGraphResponseType.fromString(reader.getString());
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedMicrosoftGraphResponseStatus.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphResponseStatus.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphResponseStatus;
        });
    }
}

