// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * domain.
 */
@Fluent
public final class MicrosoftGraphDomainInner extends MicrosoftGraphEntity {
    /*
     * Indicates the configured authentication type for the domain. The value is either Managed or Federated. Managed
     * indicates a cloud managed domain where Azure AD performs user authentication.Federated indicates authentication
     * is federated with an identity provider such as the tenant's on-premises Active Directory via Active Directory
     * Federation Services. This property is read-only and is not nullable.
     */
    private String authenticationType;

    /*
     * This property is always null except when the verify action is used. When the verify action is used, a domain
     * entity is returned in the response. The availabilityStatus property of the domain entity in the response is
     * either AvailableImmediately or EmailVerifiedDomainTakeoverScheduled.
     */
    private String availabilityStatus;

    /*
     * The value of the property is false if the DNS record management of the domain has been delegated to Microsoft
     * 365. Otherwise, the value is true. Not nullable
     */
    private Boolean isAdminManaged;

    /*
     * True if this is the default domain that is used for user creation. There is only one default domain per company.
     * Not nullable
     */
    private Boolean isDefault;

    /*
     * True if this is the initial domain created by Microsoft Online Services (companyname.onmicrosoft.com). There is
     * only one initial domain per company. Not nullable
     */
    private Boolean isInitial;

    /*
     * True if the domain is a verified root domain. Otherwise, false if the domain is a subdomain or unverified. Not
     * nullable
     */
    private Boolean isRoot;

    /*
     * True if the domain has completed domain ownership verification. Not nullable
     */
    private Boolean isVerified;

    /*
     * The manufacturer property.
     */
    private String manufacturer;

    /*
     * The model property.
     */
    private String model;

    /*
     * Specifies the number of days before a user receives notification that their password will expire. If the property
     * is not set, a default value of 14 days will be used.
     */
    private Integer passwordNotificationWindowInDays;

    /*
     * Specifies the length of time that a password is valid before it must be changed. If the property is not set, a
     * default value of 90 days will be used.
     */
    private Integer passwordValidityPeriodInDays;

    /*
     * domainState
     */
    private MicrosoftGraphDomainState state;

    /*
     * The capabilities assigned to the domain.Can include 0, 1 or more of following values: Email, Sharepoint,
     * EmailInternalRelayOnly, OfficeCommunicationsOnline, SharePointDefaultDomain, FullRedelegation, SharePointPublic,
     * OrgIdAuthentication, Yammer, Intune The values which you can add/remove using Graph API include: Email,
     * OfficeCommunicationsOnline, YammerNot nullable
     */
    private List<String> supportedServices;

    /*
     * Read-only, Nullable
     */
    private List<MicrosoftGraphDirectoryObjectInner> domainNameReferences;

    /*
     * DNS records the customer adds to the DNS zone file of the domain before the domain can be used by Microsoft
     * Online services.Read-only, Nullable
     */
    private List<MicrosoftGraphDomainDnsRecord> serviceConfigurationRecords;

    /*
     * DNS records that the customer adds to the DNS zone file of the domain before the customer can complete domain
     * ownership verification with Azure AD.Read-only, Nullable
     */
    private List<MicrosoftGraphDomainDnsRecord> verificationDnsRecords;

    /*
     * domain
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphDomainInner class.
     */
    public MicrosoftGraphDomainInner() {
    }

    /**
     * Get the authenticationType property: Indicates the configured authentication type for the domain. The value is
     * either Managed or Federated. Managed indicates a cloud managed domain where Azure AD performs user
     * authentication.Federated indicates authentication is federated with an identity provider such as the tenant's
     * on-premises Active Directory via Active Directory Federation Services. This property is read-only and is not
     * nullable.
     * 
     * @return the authenticationType value.
     */
    public String authenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType property: Indicates the configured authentication type for the domain. The value is
     * either Managed or Federated. Managed indicates a cloud managed domain where Azure AD performs user
     * authentication.Federated indicates authentication is federated with an identity provider such as the tenant's
     * on-premises Active Directory via Active Directory Federation Services. This property is read-only and is not
     * nullable.
     * 
     * @param authenticationType the authenticationType value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the availabilityStatus property: This property is always null except when the verify action is used. When the
     * verify action is used, a domain entity is returned in the response. The availabilityStatus property of the domain
     * entity in the response is either AvailableImmediately or EmailVerifiedDomainTakeoverScheduled.
     * 
     * @return the availabilityStatus value.
     */
    public String availabilityStatus() {
        return this.availabilityStatus;
    }

    /**
     * Set the availabilityStatus property: This property is always null except when the verify action is used. When the
     * verify action is used, a domain entity is returned in the response. The availabilityStatus property of the domain
     * entity in the response is either AvailableImmediately or EmailVerifiedDomainTakeoverScheduled.
     * 
     * @param availabilityStatus the availabilityStatus value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withAvailabilityStatus(String availabilityStatus) {
        this.availabilityStatus = availabilityStatus;
        return this;
    }

    /**
     * Get the isAdminManaged property: The value of the property is false if the DNS record management of the domain
     * has been delegated to Microsoft 365. Otherwise, the value is true. Not nullable.
     * 
     * @return the isAdminManaged value.
     */
    public Boolean isAdminManaged() {
        return this.isAdminManaged;
    }

    /**
     * Set the isAdminManaged property: The value of the property is false if the DNS record management of the domain
     * has been delegated to Microsoft 365. Otherwise, the value is true. Not nullable.
     * 
     * @param isAdminManaged the isAdminManaged value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withIsAdminManaged(Boolean isAdminManaged) {
        this.isAdminManaged = isAdminManaged;
        return this;
    }

    /**
     * Get the isDefault property: True if this is the default domain that is used for user creation. There is only one
     * default domain per company. Not nullable.
     * 
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Set the isDefault property: True if this is the default domain that is used for user creation. There is only one
     * default domain per company. Not nullable.
     * 
     * @param isDefault the isDefault value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    /**
     * Get the isInitial property: True if this is the initial domain created by Microsoft Online Services
     * (companyname.onmicrosoft.com). There is only one initial domain per company. Not nullable.
     * 
     * @return the isInitial value.
     */
    public Boolean isInitial() {
        return this.isInitial;
    }

    /**
     * Set the isInitial property: True if this is the initial domain created by Microsoft Online Services
     * (companyname.onmicrosoft.com). There is only one initial domain per company. Not nullable.
     * 
     * @param isInitial the isInitial value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withIsInitial(Boolean isInitial) {
        this.isInitial = isInitial;
        return this;
    }

    /**
     * Get the isRoot property: True if the domain is a verified root domain. Otherwise, false if the domain is a
     * subdomain or unverified. Not nullable.
     * 
     * @return the isRoot value.
     */
    public Boolean isRoot() {
        return this.isRoot;
    }

    /**
     * Set the isRoot property: True if the domain is a verified root domain. Otherwise, false if the domain is a
     * subdomain or unverified. Not nullable.
     * 
     * @param isRoot the isRoot value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withIsRoot(Boolean isRoot) {
        this.isRoot = isRoot;
        return this;
    }

    /**
     * Get the isVerified property: True if the domain has completed domain ownership verification. Not nullable.
     * 
     * @return the isVerified value.
     */
    public Boolean isVerified() {
        return this.isVerified;
    }

    /**
     * Set the isVerified property: True if the domain has completed domain ownership verification. Not nullable.
     * 
     * @param isVerified the isVerified value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withIsVerified(Boolean isVerified) {
        this.isVerified = isVerified;
        return this;
    }

    /**
     * Get the manufacturer property: The manufacturer property.
     * 
     * @return the manufacturer value.
     */
    public String manufacturer() {
        return this.manufacturer;
    }

    /**
     * Set the manufacturer property: The manufacturer property.
     * 
     * @param manufacturer the manufacturer value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    /**
     * Get the model property: The model property.
     * 
     * @return the model value.
     */
    public String model() {
        return this.model;
    }

    /**
     * Set the model property: The model property.
     * 
     * @param model the model value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withModel(String model) {
        this.model = model;
        return this;
    }

    /**
     * Get the passwordNotificationWindowInDays property: Specifies the number of days before a user receives
     * notification that their password will expire. If the property is not set, a default value of 14 days will be
     * used.
     * 
     * @return the passwordNotificationWindowInDays value.
     */
    public Integer passwordNotificationWindowInDays() {
        return this.passwordNotificationWindowInDays;
    }

    /**
     * Set the passwordNotificationWindowInDays property: Specifies the number of days before a user receives
     * notification that their password will expire. If the property is not set, a default value of 14 days will be
     * used.
     * 
     * @param passwordNotificationWindowInDays the passwordNotificationWindowInDays value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withPasswordNotificationWindowInDays(Integer passwordNotificationWindowInDays) {
        this.passwordNotificationWindowInDays = passwordNotificationWindowInDays;
        return this;
    }

    /**
     * Get the passwordValidityPeriodInDays property: Specifies the length of time that a password is valid before it
     * must be changed. If the property is not set, a default value of 90 days will be used.
     * 
     * @return the passwordValidityPeriodInDays value.
     */
    public Integer passwordValidityPeriodInDays() {
        return this.passwordValidityPeriodInDays;
    }

    /**
     * Set the passwordValidityPeriodInDays property: Specifies the length of time that a password is valid before it
     * must be changed. If the property is not set, a default value of 90 days will be used.
     * 
     * @param passwordValidityPeriodInDays the passwordValidityPeriodInDays value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withPasswordValidityPeriodInDays(Integer passwordValidityPeriodInDays) {
        this.passwordValidityPeriodInDays = passwordValidityPeriodInDays;
        return this;
    }

    /**
     * Get the state property: domainState.
     * 
     * @return the state value.
     */
    public MicrosoftGraphDomainState state() {
        return this.state;
    }

    /**
     * Set the state property: domainState.
     * 
     * @param state the state value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withState(MicrosoftGraphDomainState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the supportedServices property: The capabilities assigned to the domain.Can include 0, 1 or more of following
     * values: Email, Sharepoint, EmailInternalRelayOnly, OfficeCommunicationsOnline, SharePointDefaultDomain,
     * FullRedelegation, SharePointPublic, OrgIdAuthentication, Yammer, Intune The values which you can add/remove using
     * Graph API include: Email, OfficeCommunicationsOnline, YammerNot nullable.
     * 
     * @return the supportedServices value.
     */
    public List<String> supportedServices() {
        return this.supportedServices;
    }

    /**
     * Set the supportedServices property: The capabilities assigned to the domain.Can include 0, 1 or more of following
     * values: Email, Sharepoint, EmailInternalRelayOnly, OfficeCommunicationsOnline, SharePointDefaultDomain,
     * FullRedelegation, SharePointPublic, OrgIdAuthentication, Yammer, Intune The values which you can add/remove using
     * Graph API include: Email, OfficeCommunicationsOnline, YammerNot nullable.
     * 
     * @param supportedServices the supportedServices value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withSupportedServices(List<String> supportedServices) {
        this.supportedServices = supportedServices;
        return this;
    }

    /**
     * Get the domainNameReferences property: Read-only, Nullable.
     * 
     * @return the domainNameReferences value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> domainNameReferences() {
        return this.domainNameReferences;
    }

    /**
     * Set the domainNameReferences property: Read-only, Nullable.
     * 
     * @param domainNameReferences the domainNameReferences value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner
        withDomainNameReferences(List<MicrosoftGraphDirectoryObjectInner> domainNameReferences) {
        this.domainNameReferences = domainNameReferences;
        return this;
    }

    /**
     * Get the serviceConfigurationRecords property: DNS records the customer adds to the DNS zone file of the domain
     * before the domain can be used by Microsoft Online services.Read-only, Nullable.
     * 
     * @return the serviceConfigurationRecords value.
     */
    public List<MicrosoftGraphDomainDnsRecord> serviceConfigurationRecords() {
        return this.serviceConfigurationRecords;
    }

    /**
     * Set the serviceConfigurationRecords property: DNS records the customer adds to the DNS zone file of the domain
     * before the domain can be used by Microsoft Online services.Read-only, Nullable.
     * 
     * @param serviceConfigurationRecords the serviceConfigurationRecords value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner
        withServiceConfigurationRecords(List<MicrosoftGraphDomainDnsRecord> serviceConfigurationRecords) {
        this.serviceConfigurationRecords = serviceConfigurationRecords;
        return this;
    }

    /**
     * Get the verificationDnsRecords property: DNS records that the customer adds to the DNS zone file of the domain
     * before the customer can complete domain ownership verification with Azure AD.Read-only, Nullable.
     * 
     * @return the verificationDnsRecords value.
     */
    public List<MicrosoftGraphDomainDnsRecord> verificationDnsRecords() {
        return this.verificationDnsRecords;
    }

    /**
     * Set the verificationDnsRecords property: DNS records that the customer adds to the DNS zone file of the domain
     * before the customer can complete domain ownership verification with Azure AD.Read-only, Nullable.
     * 
     * @param verificationDnsRecords the verificationDnsRecords value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner
        withVerificationDnsRecords(List<MicrosoftGraphDomainDnsRecord> verificationDnsRecords) {
        this.verificationDnsRecords = verificationDnsRecords;
        return this;
    }

    /**
     * Get the additionalProperties property: domain.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: domain.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDomainInner object itself.
     */
    public MicrosoftGraphDomainInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDomainInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (state() != null) {
            state().validate();
        }
        if (domainNameReferences() != null) {
            domainNameReferences().forEach(e -> e.validate());
        }
        if (serviceConfigurationRecords() != null) {
            serviceConfigurationRecords().forEach(e -> e.validate());
        }
        if (verificationDnsRecords() != null) {
            verificationDnsRecords().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("authenticationType", this.authenticationType);
        jsonWriter.writeStringField("availabilityStatus", this.availabilityStatus);
        jsonWriter.writeBooleanField("isAdminManaged", this.isAdminManaged);
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeBooleanField("isInitial", this.isInitial);
        jsonWriter.writeBooleanField("isRoot", this.isRoot);
        jsonWriter.writeBooleanField("isVerified", this.isVerified);
        jsonWriter.writeStringField("manufacturer", this.manufacturer);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeNumberField("passwordNotificationWindowInDays", this.passwordNotificationWindowInDays);
        jsonWriter.writeNumberField("passwordValidityPeriodInDays", this.passwordValidityPeriodInDays);
        jsonWriter.writeJsonField("state", this.state);
        jsonWriter.writeArrayField("supportedServices", this.supportedServices,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("domainNameReferences", this.domainNameReferences,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("serviceConfigurationRecords", this.serviceConfigurationRecords,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("verificationDnsRecords", this.verificationDnsRecords,
            (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphDomainInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphDomainInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphDomainInner.
     */
    public static MicrosoftGraphDomainInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphDomainInner deserializedMicrosoftGraphDomainInner = new MicrosoftGraphDomainInner();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.withId(reader.getString());
                } else if ("authenticationType".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.authenticationType = reader.getString();
                } else if ("availabilityStatus".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.availabilityStatus = reader.getString();
                } else if ("isAdminManaged".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.isAdminManaged = reader.getNullable(JsonReader::getBoolean);
                } else if ("isDefault".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.isDefault = reader.getNullable(JsonReader::getBoolean);
                } else if ("isInitial".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.isInitial = reader.getNullable(JsonReader::getBoolean);
                } else if ("isRoot".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.isRoot = reader.getNullable(JsonReader::getBoolean);
                } else if ("isVerified".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.isVerified = reader.getNullable(JsonReader::getBoolean);
                } else if ("manufacturer".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.manufacturer = reader.getString();
                } else if ("model".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.model = reader.getString();
                } else if ("passwordNotificationWindowInDays".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.passwordNotificationWindowInDays
                        = reader.getNullable(JsonReader::getInt);
                } else if ("passwordValidityPeriodInDays".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.passwordValidityPeriodInDays
                        = reader.getNullable(JsonReader::getInt);
                } else if ("state".equals(fieldName)) {
                    deserializedMicrosoftGraphDomainInner.state = MicrosoftGraphDomainState.fromJson(reader);
                } else if ("supportedServices".equals(fieldName)) {
                    List<String> supportedServices = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphDomainInner.supportedServices = supportedServices;
                } else if ("domainNameReferences".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> domainNameReferences
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphDomainInner.domainNameReferences = domainNameReferences;
                } else if ("serviceConfigurationRecords".equals(fieldName)) {
                    List<MicrosoftGraphDomainDnsRecord> serviceConfigurationRecords
                        = reader.readArray(reader1 -> MicrosoftGraphDomainDnsRecord.fromJson(reader1));
                    deserializedMicrosoftGraphDomainInner.serviceConfigurationRecords = serviceConfigurationRecords;
                } else if ("verificationDnsRecords".equals(fieldName)) {
                    List<MicrosoftGraphDomainDnsRecord> verificationDnsRecords
                        = reader.readArray(reader1 -> MicrosoftGraphDomainDnsRecord.fromJson(reader1));
                    deserializedMicrosoftGraphDomainInner.verificationDnsRecords = verificationDnsRecords;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphDomainInner.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphDomainInner;
        });
    }
}
