// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * The ApplicationsGetMemberGroupsRequestBody model.
 */
@Fluent
public final class ApplicationsGetMemberGroupsRequestBody
    implements JsonSerializable<ApplicationsGetMemberGroupsRequestBody> {
    /*
     * The securityEnabledOnly property.
     */
    private Boolean securityEnabledOnly;

    /*
     * Dictionary of <AnyObject>
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of ApplicationsGetMemberGroupsRequestBody class.
     */
    public ApplicationsGetMemberGroupsRequestBody() {
    }

    /**
     * Get the securityEnabledOnly property: The securityEnabledOnly property.
     * 
     * @return the securityEnabledOnly value.
     */
    public Boolean securityEnabledOnly() {
        return this.securityEnabledOnly;
    }

    /**
     * Set the securityEnabledOnly property: The securityEnabledOnly property.
     * 
     * @param securityEnabledOnly the securityEnabledOnly value to set.
     * @return the ApplicationsGetMemberGroupsRequestBody object itself.
     */
    public ApplicationsGetMemberGroupsRequestBody withSecurityEnabledOnly(Boolean securityEnabledOnly) {
        this.securityEnabledOnly = securityEnabledOnly;
        return this;
    }

    /**
     * Get the additionalProperties property: Dictionary of &lt;AnyObject&gt;.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Dictionary of &lt;AnyObject&gt;.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the ApplicationsGetMemberGroupsRequestBody object itself.
     */
    public ApplicationsGetMemberGroupsRequestBody withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("securityEnabledOnly", this.securityEnabledOnly);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationsGetMemberGroupsRequestBody from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationsGetMemberGroupsRequestBody if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationsGetMemberGroupsRequestBody.
     */
    public static ApplicationsGetMemberGroupsRequestBody fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationsGetMemberGroupsRequestBody deserializedApplicationsGetMemberGroupsRequestBody
                = new ApplicationsGetMemberGroupsRequestBody();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("securityEnabledOnly".equals(fieldName)) {
                    deserializedApplicationsGetMemberGroupsRequestBody.securityEnabledOnly
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedApplicationsGetMemberGroupsRequestBody.additionalProperties = additionalProperties;

            return deserializedApplicationsGetMemberGroupsRequestBody;
        });
    }
}
