/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOfferShiftRequest;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOpenShift;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOpenShiftChangeRequest;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOperationStatus;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSchedulingGroup;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphShift;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSwapShiftsChangeRequest;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTimeOff;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTimeOffReason;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTimeOffRequest;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphSchedule
extends MicrosoftGraphEntity {
    private Boolean enabled;
    private Boolean offerShiftRequestsEnabled;
    private Boolean openShiftsEnabled;
    private MicrosoftGraphOperationStatus provisionStatus;
    private String provisionStatusCode;
    private Boolean swapShiftsRequestsEnabled;
    private Boolean timeClockEnabled;
    private Boolean timeOffRequestsEnabled;
    private String timeZone;
    private List<String> workforceIntegrationIds;
    private List<MicrosoftGraphOfferShiftRequest> offerShiftRequests;
    private List<MicrosoftGraphOpenShiftChangeRequest> openShiftChangeRequests;
    private List<MicrosoftGraphOpenShift> openShifts;
    private List<MicrosoftGraphSchedulingGroup> schedulingGroups;
    private List<MicrosoftGraphShift> shifts;
    private List<MicrosoftGraphSwapShiftsChangeRequest> swapShiftsChangeRequests;
    private List<MicrosoftGraphTimeOffReason> timeOffReasons;
    private List<MicrosoftGraphTimeOffRequest> timeOffRequests;
    private List<MicrosoftGraphTimeOff> timesOff;
    private Map<String, Object> additionalProperties;

    public Boolean enabled() {
        return this.enabled;
    }

    public MicrosoftGraphSchedule withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean offerShiftRequestsEnabled() {
        return this.offerShiftRequestsEnabled;
    }

    public MicrosoftGraphSchedule withOfferShiftRequestsEnabled(Boolean offerShiftRequestsEnabled) {
        this.offerShiftRequestsEnabled = offerShiftRequestsEnabled;
        return this;
    }

    public Boolean openShiftsEnabled() {
        return this.openShiftsEnabled;
    }

    public MicrosoftGraphSchedule withOpenShiftsEnabled(Boolean openShiftsEnabled) {
        this.openShiftsEnabled = openShiftsEnabled;
        return this;
    }

    public MicrosoftGraphOperationStatus provisionStatus() {
        return this.provisionStatus;
    }

    public MicrosoftGraphSchedule withProvisionStatus(MicrosoftGraphOperationStatus provisionStatus) {
        this.provisionStatus = provisionStatus;
        return this;
    }

    public String provisionStatusCode() {
        return this.provisionStatusCode;
    }

    public MicrosoftGraphSchedule withProvisionStatusCode(String provisionStatusCode) {
        this.provisionStatusCode = provisionStatusCode;
        return this;
    }

    public Boolean swapShiftsRequestsEnabled() {
        return this.swapShiftsRequestsEnabled;
    }

    public MicrosoftGraphSchedule withSwapShiftsRequestsEnabled(Boolean swapShiftsRequestsEnabled) {
        this.swapShiftsRequestsEnabled = swapShiftsRequestsEnabled;
        return this;
    }

    public Boolean timeClockEnabled() {
        return this.timeClockEnabled;
    }

    public MicrosoftGraphSchedule withTimeClockEnabled(Boolean timeClockEnabled) {
        this.timeClockEnabled = timeClockEnabled;
        return this;
    }

    public Boolean timeOffRequestsEnabled() {
        return this.timeOffRequestsEnabled;
    }

    public MicrosoftGraphSchedule withTimeOffRequestsEnabled(Boolean timeOffRequestsEnabled) {
        this.timeOffRequestsEnabled = timeOffRequestsEnabled;
        return this;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public MicrosoftGraphSchedule withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public List<String> workforceIntegrationIds() {
        return this.workforceIntegrationIds;
    }

    public MicrosoftGraphSchedule withWorkforceIntegrationIds(List<String> workforceIntegrationIds) {
        this.workforceIntegrationIds = workforceIntegrationIds;
        return this;
    }

    public List<MicrosoftGraphOfferShiftRequest> offerShiftRequests() {
        return this.offerShiftRequests;
    }

    public MicrosoftGraphSchedule withOfferShiftRequests(List<MicrosoftGraphOfferShiftRequest> offerShiftRequests) {
        this.offerShiftRequests = offerShiftRequests;
        return this;
    }

    public List<MicrosoftGraphOpenShiftChangeRequest> openShiftChangeRequests() {
        return this.openShiftChangeRequests;
    }

    public MicrosoftGraphSchedule withOpenShiftChangeRequests(List<MicrosoftGraphOpenShiftChangeRequest> openShiftChangeRequests) {
        this.openShiftChangeRequests = openShiftChangeRequests;
        return this;
    }

    public List<MicrosoftGraphOpenShift> openShifts() {
        return this.openShifts;
    }

    public MicrosoftGraphSchedule withOpenShifts(List<MicrosoftGraphOpenShift> openShifts) {
        this.openShifts = openShifts;
        return this;
    }

    public List<MicrosoftGraphSchedulingGroup> schedulingGroups() {
        return this.schedulingGroups;
    }

    public MicrosoftGraphSchedule withSchedulingGroups(List<MicrosoftGraphSchedulingGroup> schedulingGroups) {
        this.schedulingGroups = schedulingGroups;
        return this;
    }

    public List<MicrosoftGraphShift> shifts() {
        return this.shifts;
    }

    public MicrosoftGraphSchedule withShifts(List<MicrosoftGraphShift> shifts) {
        this.shifts = shifts;
        return this;
    }

    public List<MicrosoftGraphSwapShiftsChangeRequest> swapShiftsChangeRequests() {
        return this.swapShiftsChangeRequests;
    }

    public MicrosoftGraphSchedule withSwapShiftsChangeRequests(List<MicrosoftGraphSwapShiftsChangeRequest> swapShiftsChangeRequests) {
        this.swapShiftsChangeRequests = swapShiftsChangeRequests;
        return this;
    }

    public List<MicrosoftGraphTimeOffReason> timeOffReasons() {
        return this.timeOffReasons;
    }

    public MicrosoftGraphSchedule withTimeOffReasons(List<MicrosoftGraphTimeOffReason> timeOffReasons) {
        this.timeOffReasons = timeOffReasons;
        return this;
    }

    public List<MicrosoftGraphTimeOffRequest> timeOffRequests() {
        return this.timeOffRequests;
    }

    public MicrosoftGraphSchedule withTimeOffRequests(List<MicrosoftGraphTimeOffRequest> timeOffRequests) {
        this.timeOffRequests = timeOffRequests;
        return this;
    }

    public List<MicrosoftGraphTimeOff> timesOff() {
        return this.timesOff;
    }

    public MicrosoftGraphSchedule withTimesOff(List<MicrosoftGraphTimeOff> timesOff) {
        this.timesOff = timesOff;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphSchedule withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphSchedule withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.offerShiftRequests() != null) {
            this.offerShiftRequests().forEach(e -> e.validate());
        }
        if (this.openShiftChangeRequests() != null) {
            this.openShiftChangeRequests().forEach(e -> e.validate());
        }
        if (this.openShifts() != null) {
            this.openShifts().forEach(e -> e.validate());
        }
        if (this.schedulingGroups() != null) {
            this.schedulingGroups().forEach(e -> e.validate());
        }
        if (this.shifts() != null) {
            this.shifts().forEach(e -> e.validate());
        }
        if (this.swapShiftsChangeRequests() != null) {
            this.swapShiftsChangeRequests().forEach(e -> e.validate());
        }
        if (this.timeOffReasons() != null) {
            this.timeOffReasons().forEach(e -> e.validate());
        }
        if (this.timeOffRequests() != null) {
            this.timeOffRequests().forEach(e -> e.validate());
        }
        if (this.timesOff() != null) {
            this.timesOff().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeBooleanField("offerShiftRequestsEnabled", this.offerShiftRequestsEnabled);
        jsonWriter.writeBooleanField("openShiftsEnabled", this.openShiftsEnabled);
        jsonWriter.writeStringField("provisionStatus", this.provisionStatus == null ? null : this.provisionStatus.toString());
        jsonWriter.writeStringField("provisionStatusCode", this.provisionStatusCode);
        jsonWriter.writeBooleanField("swapShiftsRequestsEnabled", this.swapShiftsRequestsEnabled);
        jsonWriter.writeBooleanField("timeClockEnabled", this.timeClockEnabled);
        jsonWriter.writeBooleanField("timeOffRequestsEnabled", this.timeOffRequestsEnabled);
        jsonWriter.writeStringField("timeZone", this.timeZone);
        jsonWriter.writeArrayField("workforceIntegrationIds", this.workforceIntegrationIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("offerShiftRequests", this.offerShiftRequests, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("openShiftChangeRequests", this.openShiftChangeRequests, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("openShifts", this.openShifts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("schedulingGroups", this.schedulingGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("shifts", this.shifts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("swapShiftsChangeRequests", this.swapShiftsChangeRequests, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("timeOffReasons", this.timeOffReasons, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("timeOffRequests", this.timeOffRequests, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("timesOff", this.timesOff, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphSchedule fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphSchedule)jsonReader.readObject(reader -> {
            MicrosoftGraphSchedule deserializedMicrosoftGraphSchedule = new MicrosoftGraphSchedule();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.withId(reader.getString());
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("offerShiftRequestsEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.offerShiftRequestsEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("openShiftsEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.openShiftsEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisionStatus".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.provisionStatus = MicrosoftGraphOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("provisionStatusCode".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.provisionStatusCode = reader.getString();
                    continue;
                }
                if ("swapShiftsRequestsEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.swapShiftsRequestsEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("timeClockEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.timeClockEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("timeOffRequestsEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.timeOffRequestsEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("timeZone".equals(fieldName)) {
                    deserializedMicrosoftGraphSchedule.timeZone = reader.getString();
                    continue;
                }
                if ("workforceIntegrationIds".equals(fieldName)) {
                    List workforceIntegrationIds;
                    deserializedMicrosoftGraphSchedule.workforceIntegrationIds = workforceIntegrationIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("offerShiftRequests".equals(fieldName)) {
                    List offerShiftRequests;
                    deserializedMicrosoftGraphSchedule.offerShiftRequests = offerShiftRequests = reader.readArray(reader1 -> MicrosoftGraphOfferShiftRequest.fromJson(reader1));
                    continue;
                }
                if ("openShiftChangeRequests".equals(fieldName)) {
                    List openShiftChangeRequests;
                    deserializedMicrosoftGraphSchedule.openShiftChangeRequests = openShiftChangeRequests = reader.readArray(reader1 -> MicrosoftGraphOpenShiftChangeRequest.fromJson(reader1));
                    continue;
                }
                if ("openShifts".equals(fieldName)) {
                    List openShifts;
                    deserializedMicrosoftGraphSchedule.openShifts = openShifts = reader.readArray(reader1 -> MicrosoftGraphOpenShift.fromJson(reader1));
                    continue;
                }
                if ("schedulingGroups".equals(fieldName)) {
                    List schedulingGroups;
                    deserializedMicrosoftGraphSchedule.schedulingGroups = schedulingGroups = reader.readArray(reader1 -> MicrosoftGraphSchedulingGroup.fromJson(reader1));
                    continue;
                }
                if ("shifts".equals(fieldName)) {
                    List shifts;
                    deserializedMicrosoftGraphSchedule.shifts = shifts = reader.readArray(reader1 -> MicrosoftGraphShift.fromJson(reader1));
                    continue;
                }
                if ("swapShiftsChangeRequests".equals(fieldName)) {
                    List swapShiftsChangeRequests;
                    deserializedMicrosoftGraphSchedule.swapShiftsChangeRequests = swapShiftsChangeRequests = reader.readArray(reader1 -> MicrosoftGraphSwapShiftsChangeRequest.fromJson(reader1));
                    continue;
                }
                if ("timeOffReasons".equals(fieldName)) {
                    List timeOffReasons;
                    deserializedMicrosoftGraphSchedule.timeOffReasons = timeOffReasons = reader.readArray(reader1 -> MicrosoftGraphTimeOffReason.fromJson(reader1));
                    continue;
                }
                if ("timeOffRequests".equals(fieldName)) {
                    List timeOffRequests;
                    deserializedMicrosoftGraphSchedule.timeOffRequests = timeOffRequests = reader.readArray(reader1 -> MicrosoftGraphTimeOffRequest.fromJson(reader1));
                    continue;
                }
                if ("timesOff".equals(fieldName)) {
                    List timesOff;
                    deserializedMicrosoftGraphSchedule.timesOff = timesOff = reader.readArray(reader1 -> MicrosoftGraphTimeOff.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphSchedule.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphSchedule;
        });
    }
}

