/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPlannerPlan;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPlannerTask;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphPlannerUser
extends MicrosoftGraphEntity {
    private List<MicrosoftGraphPlannerPlan> plans;
    private List<MicrosoftGraphPlannerTask> tasks;
    private Map<String, Object> additionalProperties;

    public List<MicrosoftGraphPlannerPlan> plans() {
        return this.plans;
    }

    public MicrosoftGraphPlannerUser withPlans(List<MicrosoftGraphPlannerPlan> plans) {
        this.plans = plans;
        return this;
    }

    public List<MicrosoftGraphPlannerTask> tasks() {
        return this.tasks;
    }

    public MicrosoftGraphPlannerUser withTasks(List<MicrosoftGraphPlannerTask> tasks) {
        this.tasks = tasks;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphPlannerUser withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphPlannerUser withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.plans() != null) {
            this.plans().forEach(e -> e.validate());
        }
        if (this.tasks() != null) {
            this.tasks().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeArrayField("plans", this.plans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("tasks", this.tasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphPlannerUser fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphPlannerUser)jsonReader.readObject(reader -> {
            MicrosoftGraphPlannerUser deserializedMicrosoftGraphPlannerUser = new MicrosoftGraphPlannerUser();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerUser.withId(reader.getString());
                    continue;
                }
                if ("plans".equals(fieldName)) {
                    List plans;
                    deserializedMicrosoftGraphPlannerUser.plans = plans = reader.readArray(reader1 -> MicrosoftGraphPlannerPlan.fromJson(reader1));
                    continue;
                }
                if ("tasks".equals(fieldName)) {
                    List tasks;
                    deserializedMicrosoftGraphPlannerUser.tasks = tasks = reader.readArray(reader1 -> MicrosoftGraphPlannerTask.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphPlannerUser.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphPlannerUser;
        });
    }
}

