// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.PolicyProperties;
import com.azure.resourcemanager.authorization.models.Principal;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRule;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Role management policy.
 */
@Fluent
public final class RoleManagementPolicyInner implements JsonSerializable<RoleManagementPolicyInner> {
    /*
     * The role management policy Id.
     */
    private String id;

    /*
     * The role management policy name.
     */
    private String name;

    /*
     * The role management policy type.
     */
    private String type;

    /*
     * Role management policy properties.
     */
    private RoleManagementPolicyProperties innerProperties;

    /**
     * Creates an instance of RoleManagementPolicyInner class.
     */
    public RoleManagementPolicyInner() {
    }

    /**
     * Get the id property: The role management policy Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The role management policy name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The role management policy type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: Role management policy properties.
     * 
     * @return the innerProperties value.
     */
    private RoleManagementPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the scope property: The role management policy scope.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Set the scope property: The role management policy scope.
     * 
     * @param scope the scope value to set.
     * @return the RoleManagementPolicyInner object itself.
     */
    public RoleManagementPolicyInner withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyProperties();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    /**
     * Get the displayName property: The role management policy display name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: The role management policy display name.
     * 
     * @param displayName the displayName value to set.
     * @return the RoleManagementPolicyInner object itself.
     */
    public RoleManagementPolicyInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the description property: The role management policy description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: The role management policy description.
     * 
     * @param description the description value to set.
     * @return the RoleManagementPolicyInner object itself.
     */
    public RoleManagementPolicyInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the isOrganizationDefault property: The role management policy is default policy.
     * 
     * @return the isOrganizationDefault value.
     */
    public Boolean isOrganizationDefault() {
        return this.innerProperties() == null ? null : this.innerProperties().isOrganizationDefault();
    }

    /**
     * Set the isOrganizationDefault property: The role management policy is default policy.
     * 
     * @param isOrganizationDefault the isOrganizationDefault value to set.
     * @return the RoleManagementPolicyInner object itself.
     */
    public RoleManagementPolicyInner withIsOrganizationDefault(Boolean isOrganizationDefault) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyProperties();
        }
        this.innerProperties().withIsOrganizationDefault(isOrganizationDefault);
        return this;
    }

    /**
     * Get the lastModifiedBy property: The name of the entity last modified it.
     * 
     * @return the lastModifiedBy value.
     */
    public Principal lastModifiedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedBy();
    }

    /**
     * Get the lastModifiedDateTime property: The last modified date time.
     * 
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedDateTime();
    }

    /**
     * Get the rules property: The rule applied to the policy.
     * 
     * @return the rules value.
     */
    public List<RoleManagementPolicyRule> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    /**
     * Set the rules property: The rule applied to the policy.
     * 
     * @param rules the rules value to set.
     * @return the RoleManagementPolicyInner object itself.
     */
    public RoleManagementPolicyInner withRules(List<RoleManagementPolicyRule> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleManagementPolicyProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    /**
     * Get the effectiveRules property: The readonly computed rule applied to the policy.
     * 
     * @return the effectiveRules value.
     */
    public List<RoleManagementPolicyRule> effectiveRules() {
        return this.innerProperties() == null ? null : this.innerProperties().effectiveRules();
    }

    /**
     * Get the policyProperties property: Additional properties of scope.
     * 
     * @return the policyProperties value.
     */
    public PolicyProperties policyProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().policyProperties();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleManagementPolicyInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleManagementPolicyInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleManagementPolicyInner.
     */
    public static RoleManagementPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleManagementPolicyInner deserializedRoleManagementPolicyInner = new RoleManagementPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRoleManagementPolicyInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRoleManagementPolicyInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRoleManagementPolicyInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRoleManagementPolicyInner.innerProperties
                        = RoleManagementPolicyProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleManagementPolicyInner;
        });
    }
}
