// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * resourceVisualization.
 */
@Fluent
public final class MicrosoftGraphResourceVisualization
    implements JsonSerializable<MicrosoftGraphResourceVisualization> {
    /*
     * A string describing where the item is stored. For example, the name of a SharePoint site or the user name
     * identifying the owner of the OneDrive storing the item.
     */
    private String containerDisplayName;

    /*
     * Can be used for filtering by the type of container in which the file is stored. Such as Site or OneDriveBusiness.
     */
    private String containerType;

    /*
     * A path leading to the folder in which the item is stored.
     */
    private String containerWebUrl;

    /*
     * The item's media type. Can be used for filtering for a specific type of file based on supported IANA Media Mime
     * Types. Note that not all Media Mime Types are supported.
     */
    private String mediaType;

    /*
     * A URL leading to the preview image for the item.
     */
    private String previewImageUrl;

    /*
     * A preview text for the item.
     */
    private String previewText;

    /*
     * The item's title text.
     */
    private String title;

    /*
     * The item's media type. Can be used for filtering for a specific file based on a specific type. See below for
     * supported types.
     */
    private String type;

    /*
     * resourceVisualization
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphResourceVisualization class.
     */
    public MicrosoftGraphResourceVisualization() {
    }

    /**
     * Get the containerDisplayName property: A string describing where the item is stored. For example, the name of a
     * SharePoint site or the user name identifying the owner of the OneDrive storing the item.
     * 
     * @return the containerDisplayName value.
     */
    public String containerDisplayName() {
        return this.containerDisplayName;
    }

    /**
     * Set the containerDisplayName property: A string describing where the item is stored. For example, the name of a
     * SharePoint site or the user name identifying the owner of the OneDrive storing the item.
     * 
     * @param containerDisplayName the containerDisplayName value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withContainerDisplayName(String containerDisplayName) {
        this.containerDisplayName = containerDisplayName;
        return this;
    }

    /**
     * Get the containerType property: Can be used for filtering by the type of container in which the file is stored.
     * Such as Site or OneDriveBusiness.
     * 
     * @return the containerType value.
     */
    public String containerType() {
        return this.containerType;
    }

    /**
     * Set the containerType property: Can be used for filtering by the type of container in which the file is stored.
     * Such as Site or OneDriveBusiness.
     * 
     * @param containerType the containerType value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withContainerType(String containerType) {
        this.containerType = containerType;
        return this;
    }

    /**
     * Get the containerWebUrl property: A path leading to the folder in which the item is stored.
     * 
     * @return the containerWebUrl value.
     */
    public String containerWebUrl() {
        return this.containerWebUrl;
    }

    /**
     * Set the containerWebUrl property: A path leading to the folder in which the item is stored.
     * 
     * @param containerWebUrl the containerWebUrl value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withContainerWebUrl(String containerWebUrl) {
        this.containerWebUrl = containerWebUrl;
        return this;
    }

    /**
     * Get the mediaType property: The item's media type. Can be used for filtering for a specific type of file based on
     * supported IANA Media Mime Types. Note that not all Media Mime Types are supported.
     * 
     * @return the mediaType value.
     */
    public String mediaType() {
        return this.mediaType;
    }

    /**
     * Set the mediaType property: The item's media type. Can be used for filtering for a specific type of file based on
     * supported IANA Media Mime Types. Note that not all Media Mime Types are supported.
     * 
     * @param mediaType the mediaType value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    /**
     * Get the previewImageUrl property: A URL leading to the preview image for the item.
     * 
     * @return the previewImageUrl value.
     */
    public String previewImageUrl() {
        return this.previewImageUrl;
    }

    /**
     * Set the previewImageUrl property: A URL leading to the preview image for the item.
     * 
     * @param previewImageUrl the previewImageUrl value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withPreviewImageUrl(String previewImageUrl) {
        this.previewImageUrl = previewImageUrl;
        return this;
    }

    /**
     * Get the previewText property: A preview text for the item.
     * 
     * @return the previewText value.
     */
    public String previewText() {
        return this.previewText;
    }

    /**
     * Set the previewText property: A preview text for the item.
     * 
     * @param previewText the previewText value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withPreviewText(String previewText) {
        this.previewText = previewText;
        return this;
    }

    /**
     * Get the title property: The item's title text.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: The item's title text.
     * 
     * @param title the title value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the type property: The item's media type. Can be used for filtering for a specific file based on a specific
     * type. See below for supported types.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The item's media type. Can be used for filtering for a specific file based on a specific
     * type. See below for supported types.
     * 
     * @param type the type value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: resourceVisualization.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: resourceVisualization.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphResourceVisualization object itself.
     */
    public MicrosoftGraphResourceVisualization withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerDisplayName", this.containerDisplayName);
        jsonWriter.writeStringField("containerType", this.containerType);
        jsonWriter.writeStringField("containerWebUrl", this.containerWebUrl);
        jsonWriter.writeStringField("mediaType", this.mediaType);
        jsonWriter.writeStringField("previewImageUrl", this.previewImageUrl);
        jsonWriter.writeStringField("previewText", this.previewText);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("type", this.type);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphResourceVisualization from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphResourceVisualization if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphResourceVisualization.
     */
    public static MicrosoftGraphResourceVisualization fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphResourceVisualization deserializedMicrosoftGraphResourceVisualization
                = new MicrosoftGraphResourceVisualization();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("containerDisplayName".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceVisualization.containerDisplayName = reader.getString();
                } else if ("containerType".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceVisualization.containerType = reader.getString();
                } else if ("containerWebUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceVisualization.containerWebUrl = reader.getString();
                } else if ("mediaType".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceVisualization.mediaType = reader.getString();
                } else if ("previewImageUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceVisualization.previewImageUrl = reader.getString();
                } else if ("previewText".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceVisualization.previewText = reader.getString();
                } else if ("title".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceVisualization.title = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphResourceVisualization.type = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphResourceVisualization.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphResourceVisualization;
        });
    }
}
