// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * followupFlag.
 */
@Fluent
public final class MicrosoftGraphFollowupFlag implements JsonSerializable<MicrosoftGraphFollowupFlag> {
    /*
     * dateTimeTimeZone
     */
    private MicrosoftGraphDateTimeZone completedDateTime;

    /*
     * dateTimeTimeZone
     */
    private MicrosoftGraphDateTimeZone dueDateTime;

    /*
     * followupFlagStatus
     */
    private MicrosoftGraphFollowupFlagStatus flagStatus;

    /*
     * dateTimeTimeZone
     */
    private MicrosoftGraphDateTimeZone startDateTime;

    /*
     * followupFlag
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphFollowupFlag class.
     */
    public MicrosoftGraphFollowupFlag() {
    }

    /**
     * Get the completedDateTime property: dateTimeTimeZone.
     * 
     * @return the completedDateTime value.
     */
    public MicrosoftGraphDateTimeZone completedDateTime() {
        return this.completedDateTime;
    }

    /**
     * Set the completedDateTime property: dateTimeTimeZone.
     * 
     * @param completedDateTime the completedDateTime value to set.
     * @return the MicrosoftGraphFollowupFlag object itself.
     */
    public MicrosoftGraphFollowupFlag withCompletedDateTime(MicrosoftGraphDateTimeZone completedDateTime) {
        this.completedDateTime = completedDateTime;
        return this;
    }

    /**
     * Get the dueDateTime property: dateTimeTimeZone.
     * 
     * @return the dueDateTime value.
     */
    public MicrosoftGraphDateTimeZone dueDateTime() {
        return this.dueDateTime;
    }

    /**
     * Set the dueDateTime property: dateTimeTimeZone.
     * 
     * @param dueDateTime the dueDateTime value to set.
     * @return the MicrosoftGraphFollowupFlag object itself.
     */
    public MicrosoftGraphFollowupFlag withDueDateTime(MicrosoftGraphDateTimeZone dueDateTime) {
        this.dueDateTime = dueDateTime;
        return this;
    }

    /**
     * Get the flagStatus property: followupFlagStatus.
     * 
     * @return the flagStatus value.
     */
    public MicrosoftGraphFollowupFlagStatus flagStatus() {
        return this.flagStatus;
    }

    /**
     * Set the flagStatus property: followupFlagStatus.
     * 
     * @param flagStatus the flagStatus value to set.
     * @return the MicrosoftGraphFollowupFlag object itself.
     */
    public MicrosoftGraphFollowupFlag withFlagStatus(MicrosoftGraphFollowupFlagStatus flagStatus) {
        this.flagStatus = flagStatus;
        return this;
    }

    /**
     * Get the startDateTime property: dateTimeTimeZone.
     * 
     * @return the startDateTime value.
     */
    public MicrosoftGraphDateTimeZone startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: dateTimeTimeZone.
     * 
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphFollowupFlag object itself.
     */
    public MicrosoftGraphFollowupFlag withStartDateTime(MicrosoftGraphDateTimeZone startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the additionalProperties property: followupFlag.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: followupFlag.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphFollowupFlag object itself.
     */
    public MicrosoftGraphFollowupFlag withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (completedDateTime() != null) {
            completedDateTime().validate();
        }
        if (dueDateTime() != null) {
            dueDateTime().validate();
        }
        if (startDateTime() != null) {
            startDateTime().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("completedDateTime", this.completedDateTime);
        jsonWriter.writeJsonField("dueDateTime", this.dueDateTime);
        jsonWriter.writeStringField("flagStatus", this.flagStatus == null ? null : this.flagStatus.toString());
        jsonWriter.writeJsonField("startDateTime", this.startDateTime);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphFollowupFlag from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphFollowupFlag if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphFollowupFlag.
     */
    public static MicrosoftGraphFollowupFlag fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphFollowupFlag deserializedMicrosoftGraphFollowupFlag = new MicrosoftGraphFollowupFlag();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("completedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphFollowupFlag.completedDateTime
                        = MicrosoftGraphDateTimeZone.fromJson(reader);
                } else if ("dueDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphFollowupFlag.dueDateTime = MicrosoftGraphDateTimeZone.fromJson(reader);
                } else if ("flagStatus".equals(fieldName)) {
                    deserializedMicrosoftGraphFollowupFlag.flagStatus
                        = MicrosoftGraphFollowupFlagStatus.fromString(reader.getString());
                } else if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphFollowupFlag.startDateTime = MicrosoftGraphDateTimeZone.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphFollowupFlag.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphFollowupFlag;
        });
    }
}
