// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * directory.
 */
@Fluent
public final class MicrosoftGraphDirectory extends MicrosoftGraphEntity {
    /*
     * The administrativeUnits property.
     */
    private List<MicrosoftGraphAdministrativeUnit> administrativeUnits;

    /*
     * Recently deleted items. Read-only. Nullable.
     */
    private List<MicrosoftGraphDirectoryObjectInner> deletedItems;

    /*
     * directory
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphDirectory class.
     */
    public MicrosoftGraphDirectory() {
    }

    /**
     * Get the administrativeUnits property: The administrativeUnits property.
     * 
     * @return the administrativeUnits value.
     */
    public List<MicrosoftGraphAdministrativeUnit> administrativeUnits() {
        return this.administrativeUnits;
    }

    /**
     * Set the administrativeUnits property: The administrativeUnits property.
     * 
     * @param administrativeUnits the administrativeUnits value to set.
     * @return the MicrosoftGraphDirectory object itself.
     */
    public MicrosoftGraphDirectory withAdministrativeUnits(List<MicrosoftGraphAdministrativeUnit> administrativeUnits) {
        this.administrativeUnits = administrativeUnits;
        return this;
    }

    /**
     * Get the deletedItems property: Recently deleted items. Read-only. Nullable.
     * 
     * @return the deletedItems value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> deletedItems() {
        return this.deletedItems;
    }

    /**
     * Set the deletedItems property: Recently deleted items. Read-only. Nullable.
     * 
     * @param deletedItems the deletedItems value to set.
     * @return the MicrosoftGraphDirectory object itself.
     */
    public MicrosoftGraphDirectory withDeletedItems(List<MicrosoftGraphDirectoryObjectInner> deletedItems) {
        this.deletedItems = deletedItems;
        return this;
    }

    /**
     * Get the additionalProperties property: directory.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: directory.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDirectory object itself.
     */
    public MicrosoftGraphDirectory withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDirectory withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (administrativeUnits() != null) {
            administrativeUnits().forEach(e -> e.validate());
        }
        if (deletedItems() != null) {
            deletedItems().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeArrayField("administrativeUnits", this.administrativeUnits,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("deletedItems", this.deletedItems, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphDirectory from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphDirectory if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphDirectory.
     */
    public static MicrosoftGraphDirectory fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphDirectory deserializedMicrosoftGraphDirectory = new MicrosoftGraphDirectory();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphDirectory.withId(reader.getString());
                } else if ("administrativeUnits".equals(fieldName)) {
                    List<MicrosoftGraphAdministrativeUnit> administrativeUnits
                        = reader.readArray(reader1 -> MicrosoftGraphAdministrativeUnit.fromJson(reader1));
                    deserializedMicrosoftGraphDirectory.administrativeUnits = administrativeUnits;
                } else if ("deletedItems".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> deletedItems
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphDirectory.deletedItems = deletedItems;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphDirectory.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphDirectory;
        });
    }
}
