/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.PrincipalType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RoleAssignmentProperties
implements JsonSerializable<RoleAssignmentProperties> {
    private String scope;
    private String roleDefinitionId;
    private String principalId;
    private PrincipalType principalType;
    private String description;
    private String condition;
    private String conditionVersion;
    private OffsetDateTime createdOn;
    private OffsetDateTime updatedOn;
    private String createdBy;
    private String updatedBy;
    private String delegatedManagedIdentityResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(RoleAssignmentProperties.class);

    public String scope() {
        return this.scope;
    }

    public String roleDefinitionId() {
        return this.roleDefinitionId;
    }

    public RoleAssignmentProperties withRoleDefinitionId(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public RoleAssignmentProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public PrincipalType principalType() {
        return this.principalType;
    }

    public RoleAssignmentProperties withPrincipalType(PrincipalType principalType) {
        this.principalType = principalType;
        return this;
    }

    public String description() {
        return this.description;
    }

    public RoleAssignmentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String condition() {
        return this.condition;
    }

    public RoleAssignmentProperties withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public String conditionVersion() {
        return this.conditionVersion;
    }

    public RoleAssignmentProperties withConditionVersion(String conditionVersion) {
        this.conditionVersion = conditionVersion;
        return this;
    }

    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    public OffsetDateTime updatedOn() {
        return this.updatedOn;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public String updatedBy() {
        return this.updatedBy;
    }

    public String delegatedManagedIdentityResourceId() {
        return this.delegatedManagedIdentityResourceId;
    }

    public RoleAssignmentProperties withDelegatedManagedIdentityResourceId(String delegatedManagedIdentityResourceId) {
        this.delegatedManagedIdentityResourceId = delegatedManagedIdentityResourceId;
        return this;
    }

    public void validate() {
        if (this.roleDefinitionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property roleDefinitionId in model RoleAssignmentProperties"));
        }
        if (this.principalId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property principalId in model RoleAssignmentProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("roleDefinitionId", this.roleDefinitionId);
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("principalType", this.principalType == null ? null : this.principalType.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("condition", this.condition);
        jsonWriter.writeStringField("conditionVersion", this.conditionVersion);
        jsonWriter.writeStringField("delegatedManagedIdentityResourceId", this.delegatedManagedIdentityResourceId);
        return jsonWriter.writeEndObject();
    }

    public static RoleAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoleAssignmentProperties)jsonReader.readObject(reader -> {
            RoleAssignmentProperties deserializedRoleAssignmentProperties = new RoleAssignmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("roleDefinitionId".equals(fieldName)) {
                    deserializedRoleAssignmentProperties.roleDefinitionId = reader.getString();
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedRoleAssignmentProperties.principalId = reader.getString();
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedRoleAssignmentProperties.scope = reader.getString();
                    continue;
                }
                if ("principalType".equals(fieldName)) {
                    deserializedRoleAssignmentProperties.principalType = PrincipalType.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRoleAssignmentProperties.description = reader.getString();
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedRoleAssignmentProperties.condition = reader.getString();
                    continue;
                }
                if ("conditionVersion".equals(fieldName)) {
                    deserializedRoleAssignmentProperties.conditionVersion = reader.getString();
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedRoleAssignmentProperties.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("updatedOn".equals(fieldName)) {
                    deserializedRoleAssignmentProperties.updatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedRoleAssignmentProperties.createdBy = reader.getString();
                    continue;
                }
                if ("updatedBy".equals(fieldName)) {
                    deserializedRoleAssignmentProperties.updatedBy = reader.getString();
                    continue;
                }
                if ("delegatedManagedIdentityResourceId".equals(fieldName)) {
                    deserializedRoleAssignmentProperties.delegatedManagedIdentityResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleAssignmentProperties;
        });
    }
}

