// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * thumbnailSet.
 */
@Fluent
public final class MicrosoftGraphThumbnailSet extends MicrosoftGraphEntity {
    /*
     * thumbnail
     */
    private MicrosoftGraphThumbnail large;

    /*
     * thumbnail
     */
    private MicrosoftGraphThumbnail medium;

    /*
     * thumbnail
     */
    private MicrosoftGraphThumbnail small;

    /*
     * thumbnail
     */
    private MicrosoftGraphThumbnail source;

    /*
     * thumbnailSet
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphThumbnailSet class.
     */
    public MicrosoftGraphThumbnailSet() {
    }

    /**
     * Get the large property: thumbnail.
     * 
     * @return the large value.
     */
    public MicrosoftGraphThumbnail large() {
        return this.large;
    }

    /**
     * Set the large property: thumbnail.
     * 
     * @param large the large value to set.
     * @return the MicrosoftGraphThumbnailSet object itself.
     */
    public MicrosoftGraphThumbnailSet withLarge(MicrosoftGraphThumbnail large) {
        this.large = large;
        return this;
    }

    /**
     * Get the medium property: thumbnail.
     * 
     * @return the medium value.
     */
    public MicrosoftGraphThumbnail medium() {
        return this.medium;
    }

    /**
     * Set the medium property: thumbnail.
     * 
     * @param medium the medium value to set.
     * @return the MicrosoftGraphThumbnailSet object itself.
     */
    public MicrosoftGraphThumbnailSet withMedium(MicrosoftGraphThumbnail medium) {
        this.medium = medium;
        return this;
    }

    /**
     * Get the small property: thumbnail.
     * 
     * @return the small value.
     */
    public MicrosoftGraphThumbnail small() {
        return this.small;
    }

    /**
     * Set the small property: thumbnail.
     * 
     * @param small the small value to set.
     * @return the MicrosoftGraphThumbnailSet object itself.
     */
    public MicrosoftGraphThumbnailSet withSmall(MicrosoftGraphThumbnail small) {
        this.small = small;
        return this;
    }

    /**
     * Get the source property: thumbnail.
     * 
     * @return the source value.
     */
    public MicrosoftGraphThumbnail source() {
        return this.source;
    }

    /**
     * Set the source property: thumbnail.
     * 
     * @param source the source value to set.
     * @return the MicrosoftGraphThumbnailSet object itself.
     */
    public MicrosoftGraphThumbnailSet withSource(MicrosoftGraphThumbnail source) {
        this.source = source;
        return this;
    }

    /**
     * Get the additionalProperties property: thumbnailSet.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: thumbnailSet.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphThumbnailSet object itself.
     */
    public MicrosoftGraphThumbnailSet withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphThumbnailSet withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (large() != null) {
            large().validate();
        }
        if (medium() != null) {
            medium().validate();
        }
        if (small() != null) {
            small().validate();
        }
        if (source() != null) {
            source().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("large", this.large);
        jsonWriter.writeJsonField("medium", this.medium);
        jsonWriter.writeJsonField("small", this.small);
        jsonWriter.writeJsonField("source", this.source);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphThumbnailSet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphThumbnailSet if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphThumbnailSet.
     */
    public static MicrosoftGraphThumbnailSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphThumbnailSet deserializedMicrosoftGraphThumbnailSet = new MicrosoftGraphThumbnailSet();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphThumbnailSet.withId(reader.getString());
                } else if ("large".equals(fieldName)) {
                    deserializedMicrosoftGraphThumbnailSet.large = MicrosoftGraphThumbnail.fromJson(reader);
                } else if ("medium".equals(fieldName)) {
                    deserializedMicrosoftGraphThumbnailSet.medium = MicrosoftGraphThumbnail.fromJson(reader);
                } else if ("small".equals(fieldName)) {
                    deserializedMicrosoftGraphThumbnailSet.small = MicrosoftGraphThumbnail.fromJson(reader);
                } else if ("source".equals(fieldName)) {
                    deserializedMicrosoftGraphThumbnailSet.source = MicrosoftGraphThumbnail.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphThumbnailSet.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphThumbnailSet;
        });
    }
}
