// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * teamFunSettings.
 */
@Fluent
public final class MicrosoftGraphTeamFunSettings implements JsonSerializable<MicrosoftGraphTeamFunSettings> {
    /*
     * If set to true, enables users to include custom memes.
     */
    private Boolean allowCustomMemes;

    /*
     * If set to true, enables Giphy use.
     */
    private Boolean allowGiphy;

    /*
     * If set to true, enables users to include stickers and memes.
     */
    private Boolean allowStickersAndMemes;

    /*
     * giphyRatingType
     */
    private MicrosoftGraphGiphyRatingType giphyContentRating;

    /*
     * teamFunSettings
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTeamFunSettings class.
     */
    public MicrosoftGraphTeamFunSettings() {
    }

    /**
     * Get the allowCustomMemes property: If set to true, enables users to include custom memes.
     * 
     * @return the allowCustomMemes value.
     */
    public Boolean allowCustomMemes() {
        return this.allowCustomMemes;
    }

    /**
     * Set the allowCustomMemes property: If set to true, enables users to include custom memes.
     * 
     * @param allowCustomMemes the allowCustomMemes value to set.
     * @return the MicrosoftGraphTeamFunSettings object itself.
     */
    public MicrosoftGraphTeamFunSettings withAllowCustomMemes(Boolean allowCustomMemes) {
        this.allowCustomMemes = allowCustomMemes;
        return this;
    }

    /**
     * Get the allowGiphy property: If set to true, enables Giphy use.
     * 
     * @return the allowGiphy value.
     */
    public Boolean allowGiphy() {
        return this.allowGiphy;
    }

    /**
     * Set the allowGiphy property: If set to true, enables Giphy use.
     * 
     * @param allowGiphy the allowGiphy value to set.
     * @return the MicrosoftGraphTeamFunSettings object itself.
     */
    public MicrosoftGraphTeamFunSettings withAllowGiphy(Boolean allowGiphy) {
        this.allowGiphy = allowGiphy;
        return this;
    }

    /**
     * Get the allowStickersAndMemes property: If set to true, enables users to include stickers and memes.
     * 
     * @return the allowStickersAndMemes value.
     */
    public Boolean allowStickersAndMemes() {
        return this.allowStickersAndMemes;
    }

    /**
     * Set the allowStickersAndMemes property: If set to true, enables users to include stickers and memes.
     * 
     * @param allowStickersAndMemes the allowStickersAndMemes value to set.
     * @return the MicrosoftGraphTeamFunSettings object itself.
     */
    public MicrosoftGraphTeamFunSettings withAllowStickersAndMemes(Boolean allowStickersAndMemes) {
        this.allowStickersAndMemes = allowStickersAndMemes;
        return this;
    }

    /**
     * Get the giphyContentRating property: giphyRatingType.
     * 
     * @return the giphyContentRating value.
     */
    public MicrosoftGraphGiphyRatingType giphyContentRating() {
        return this.giphyContentRating;
    }

    /**
     * Set the giphyContentRating property: giphyRatingType.
     * 
     * @param giphyContentRating the giphyContentRating value to set.
     * @return the MicrosoftGraphTeamFunSettings object itself.
     */
    public MicrosoftGraphTeamFunSettings withGiphyContentRating(MicrosoftGraphGiphyRatingType giphyContentRating) {
        this.giphyContentRating = giphyContentRating;
        return this;
    }

    /**
     * Get the additionalProperties property: teamFunSettings.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: teamFunSettings.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTeamFunSettings object itself.
     */
    public MicrosoftGraphTeamFunSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowCustomMemes", this.allowCustomMemes);
        jsonWriter.writeBooleanField("allowGiphy", this.allowGiphy);
        jsonWriter.writeBooleanField("allowStickersAndMemes", this.allowStickersAndMemes);
        jsonWriter.writeStringField("giphyContentRating",
            this.giphyContentRating == null ? null : this.giphyContentRating.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTeamFunSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTeamFunSettings if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTeamFunSettings.
     */
    public static MicrosoftGraphTeamFunSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTeamFunSettings deserializedMicrosoftGraphTeamFunSettings
                = new MicrosoftGraphTeamFunSettings();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowCustomMemes".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamFunSettings.allowCustomMemes
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowGiphy".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamFunSettings.allowGiphy = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowStickersAndMemes".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamFunSettings.allowStickersAndMemes
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("giphyContentRating".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamFunSettings.giphyContentRating
                        = MicrosoftGraphGiphyRatingType.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTeamFunSettings.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTeamFunSettings;
        });
    }
}
