// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Details of the policy.
 */
@Fluent
public final class PolicyAssignmentPropertiesPolicy implements JsonSerializable<PolicyAssignmentPropertiesPolicy> {
    /*
     * Id of the policy
     */
    private String id;

    /*
     * The name of the entity last modified it
     */
    private Principal lastModifiedBy;

    /*
     * The last modified date time.
     */
    private OffsetDateTime lastModifiedDateTime;

    /**
     * Creates an instance of PolicyAssignmentPropertiesPolicy class.
     */
    public PolicyAssignmentPropertiesPolicy() {
    }

    /**
     * Get the id property: Id of the policy.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Id of the policy.
     * 
     * @param id the id value to set.
     * @return the PolicyAssignmentPropertiesPolicy object itself.
     */
    public PolicyAssignmentPropertiesPolicy withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the lastModifiedBy property: The name of the entity last modified it.
     * 
     * @return the lastModifiedBy value.
     */
    public Principal lastModifiedBy() {
        return this.lastModifiedBy;
    }

    /**
     * Get the lastModifiedDateTime property: The last modified date time.
     * 
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Set the lastModifiedDateTime property: The last modified date time.
     * 
     * @param lastModifiedDateTime the lastModifiedDateTime value to set.
     * @return the PolicyAssignmentPropertiesPolicy object itself.
     */
    public PolicyAssignmentPropertiesPolicy withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (lastModifiedBy() != null) {
            lastModifiedBy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("lastModifiedDateTime",
            this.lastModifiedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyAssignmentPropertiesPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyAssignmentPropertiesPolicy if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicyAssignmentPropertiesPolicy.
     */
    public static PolicyAssignmentPropertiesPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyAssignmentPropertiesPolicy deserializedPolicyAssignmentPropertiesPolicy
                = new PolicyAssignmentPropertiesPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPolicyAssignmentPropertiesPolicy.id = reader.getString();
                } else if ("lastModifiedBy".equals(fieldName)) {
                    deserializedPolicyAssignmentPropertiesPolicy.lastModifiedBy = Principal.fromJson(reader);
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedPolicyAssignmentPropertiesPolicy.lastModifiedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyAssignmentPropertiesPolicy;
        });
    }
}
