// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * group
 * 
 * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
 * entity types.
 */
@Fluent
public final class MicrosoftGraphGroupInner extends MicrosoftGraphDirectoryObjectInner {
    /*
     * The list of sensitivity label pairs (label ID, label name) associated with an Microsoft 365 group. Returned only
     * on $select. Read-only.
     */
    private List<MicrosoftGraphAssignedLabel> assignedLabels;

    /*
     * The licenses that are assigned to the group. Returned only on $select. Read-only.
     */
    private List<MicrosoftGraphAssignedLicense> assignedLicenses;

    /*
     * Describes a classification for the group (such as low, medium or high business impact). Valid values for this
     * property are defined by creating a ClassificationList setting value, based on the template definition.Returned by
     * default.
     */
    private String classification;

    /*
     * Timestamp of when the group was created. The value cannot be modified and is automatically populated when the
     * group is created. The Timestamp type represents date and time information using ISO 8601 format and is always in
     * UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Returned by
     * default. Read-only.
     */
    private OffsetDateTime createdDateTime;

    /*
     * An optional description for the group. Returned by default.
     */
    private String description;

    /*
     * The display name for the group. This property is required when a group is created and cannot be cleared during
     * updates. Returned by default. Supports $filter and $orderby.
     */
    private String displayName;

    /*
     * Timestamp of when the group is set to expire. The value cannot be modified and is automatically populated when
     * the group is created. The Timestamp type represents date and time information using ISO 8601 format and is always
     * in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Returned by
     * default. Read-only.
     */
    private OffsetDateTime expirationDateTime;

    /*
     * Specifies the group type and its membership. If the collection contains Unified, the group is a Microsoft 365
     * group; otherwise, it's either a security group or distribution group. For details, see groups overview.If the
     * collection includes DynamicMembership, the group has dynamic membership; otherwise, membership is static.
     * Returned by default. Supports $filter.
     */
    private List<String> groupTypes;

    /*
     * Indicates whether there are members in this group that have license errors from its group-based license
     * assignment. This property is never returned on a GET operation. You can use it as a $filter argument to get
     * groups that have members with license errors (that is, filter for this property being true). See an example.
     */
    private Boolean hasMembersWithLicenseErrors;

    /*
     * licenseProcessingState
     */
    private MicrosoftGraphLicenseProcessingState licenseProcessingState;

    /*
     * The SMTP address for the group, for example, 'serviceadmins@contoso.onmicrosoft.com'. Returned by default.
     * Read-only. Supports $filter.
     */
    private String mail;

    /*
     * Specifies whether the group is mail-enabled. Returned by default.
     */
    private Boolean mailEnabled;

    /*
     * The mailNickname property.
     */
    private String mailNickname;

    /*
     * The rule that determines members for this group if the group is a dynamic group (groupTypes contains
     * DynamicMembership). For more information about the syntax of the membership rule, see Membership Rules syntax.
     * Returned by default.
     */
    private String membershipRule;

    /*
     * Indicates whether the dynamic membership processing is on or paused. Possible values are 'On' or 'Paused'.
     * Returned by default.
     */
    private String membershipRuleProcessingState;

    /*
     * The onPremisesDomainName property.
     */
    private String onPremisesDomainName;

    /*
     * The onPremisesLastSyncDateTime property.
     */
    private OffsetDateTime onPremisesLastSyncDateTime;

    /*
     * The onPremisesNetBiosName property.
     */
    private String onPremisesNetBiosName;

    /*
     * The onPremisesProvisioningErrors property.
     */
    private List<MicrosoftGraphOnPremisesProvisioningError> onPremisesProvisioningErrors;

    /*
     * Contains the on-premises SAM account name synchronized from the on-premises directory. The property is only
     * populated for customers who are synchronizing their on-premises directory to Azure Active Directory via Azure AD
     * Connect.Returned by default. Read-only.
     */
    private String onPremisesSamAccountName;

    /*
     * Contains the on-premises security identifier (SID) for the group that was synchronized from on-premises to the
     * cloud. Returned by default. Read-only.
     */
    private String onPremisesSecurityIdentifier;

    /*
     * true if this group is synced from an on-premises directory; false if this group was originally synced from an
     * on-premises directory but is no longer synced; null if this object has never been synced from an on-premises
     * directory (default). Returned by default. Read-only. Supports $filter.
     */
    private Boolean onPremisesSyncEnabled;

    /*
     * The preferred data location for the group. For more information, see OneDrive Online Multi-Geo. Returned by
     * default.
     */
    private String preferredDataLocation;

    /*
     * The preferred language for an Microsoft 365 group. Should follow ISO 639-1 Code; for example 'en-US'. Returned by
     * default.
     */
    private String preferredLanguage;

    /*
     * The proxyAddresses property.
     */
    private List<String> proxyAddresses;

    /*
     * Timestamp of when the group was last renewed. This cannot be modified directly and is only updated via the renew
     * service action. The Timestamp type represents date and time information using ISO 8601 format and is always in
     * UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Returned by
     * default. Read-only.
     */
    private OffsetDateTime renewedDateTime;

    /*
     * Specifies whether the group is a security group. Returned by default. Supports $filter.
     */
    private Boolean securityEnabled;

    /*
     * Security identifier of the group, used in Windows scenarios. Returned by default.
     */
    private String securityIdentifier;

    /*
     * Specifies an Microsoft 365 group's color theme. Possible values are Teal, Purple, Green, Blue, Pink, Orange or
     * Red. Returned by default.
     */
    private String theme;

    /*
     * Specifies the visibility of a Microsoft 365 group. Possible values are: Private, Public, or Hiddenmembership;
     * blank values are treated as public. See group visibility options to learn more.Visibility can be set only when a
     * group is created; it is not editable.Visibility is supported only for unified groups; it is not supported for
     * security groups. Returned by default.
     */
    private String visibility;

    /*
     * Indicates if people external to the organization can send messages to the group. Default value is false. Returned
     * only on $select.
     */
    private Boolean allowExternalSenders;

    /*
     * Indicates if new members added to the group will be auto-subscribed to receive email notifications. You can set
     * this property in a PATCH request for the group; do not set it in the initial POST request that creates the group.
     * Default value is false. Returned only on $select.
     */
    private Boolean autoSubscribeNewMembers;

    /*
     * True if the group is not displayed in certain parts of the Outlook UI: the Address Book, address lists for
     * selecting message recipients, and the Browse Groups dialog for searching groups; otherwise, false. Default value
     * is false. Returned only on $select.
     */
    private Boolean hideFromAddressLists;

    /*
     * True if the group is not displayed in Outlook clients, such as Outlook for Windows and Outlook on the web;
     * otherwise, false. Default value is false. Returned only on $select.
     */
    private Boolean hideFromOutlookClients;

    /*
     * Indicates whether the signed-in user is subscribed to receive email conversations. Default value is true.
     * Returned only on $select.
     */
    private Boolean isSubscribedByMail;

    /*
     * Count of conversations that have received new posts since the signed-in user last visited the group. Returned
     * only on $select.
     */
    private Integer unseenCount;

    /*
     * The isArchived property.
     */
    private Boolean isArchived;

    /*
     * The appRoleAssignments property.
     */
    private List<MicrosoftGraphAppRoleAssignment> appRoleAssignments;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
     * entity types.
     */
    private MicrosoftGraphDirectoryObjectInner createdOnBehalfOf;

    /*
     * Groups that this group is a member of. HTTP Methods: GET (supported for all groups). Read-only. Nullable.
     */
    private List<MicrosoftGraphDirectoryObjectInner> memberOf;

    /*
     * Users and groups that are members of this group. HTTP Methods: GET (supported for all groups), POST (supported
     * for Microsoft 365 groups, security groups and mail-enabled security groups), DELETE (supported for Microsoft 365
     * groups and security groups) Nullable.
     */
    private List<MicrosoftGraphDirectoryObjectInner> members;

    /*
     * A list of group members with license errors from this group-based license assignment. Read-only.
     */
    private List<MicrosoftGraphDirectoryObjectInner> membersWithLicenseErrors;

    /*
     * The owners of the group. The owners are a set of non-admin users who are allowed to modify this object. Limited
     * to 100 owners. HTTP Methods: GET (supported for all groups), POST (supported for Microsoft 365 groups, security
     * groups and mail-enabled security groups), DELETE (supported for Microsoft 365 groups and security groups).
     * Nullable.
     */
    private List<MicrosoftGraphDirectoryObjectInner> owners;

    /*
     * The permissionGrants property.
     */
    private List<MicrosoftGraphResourceSpecificPermissionGrant> permissionGrants;

    /*
     * Read-only. Nullable.
     */
    private List<MicrosoftGraphGroupSetting> settings;

    /*
     * The transitiveMemberOf property.
     */
    private List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf;

    /*
     * The transitiveMembers property.
     */
    private List<MicrosoftGraphDirectoryObjectInner> transitiveMembers;

    /*
     * The list of users or groups that are allowed to create post's or calendar events in this group. If this list is
     * non-empty then only users or groups listed here are allowed to post.
     */
    private List<MicrosoftGraphDirectoryObjectInner> acceptedSenders;

    /*
     * calendar
     */
    private MicrosoftGraphCalendar calendar;

    /*
     * The calendar view for the calendar. Read-only.
     */
    private List<MicrosoftGraphEvent> calendarView;

    /*
     * The group's conversations.
     */
    private List<MicrosoftGraphConversation> conversations;

    /*
     * The group's calendar events.
     */
    private List<MicrosoftGraphEvent> events;

    /*
     * profilePhoto
     */
    private MicrosoftGraphProfilePhoto photo;

    /*
     * The profile photos owned by the group. Read-only. Nullable.
     */
    private List<MicrosoftGraphProfilePhoto> photos;

    /*
     * The list of users or groups that are not allowed to create posts or calendar events in this group. Nullable
     */
    private List<MicrosoftGraphDirectoryObjectInner> rejectedSenders;

    /*
     * The group's conversation threads. Nullable.
     */
    private List<MicrosoftGraphConversationThread> threads;

    /*
     * drive
     */
    private MicrosoftGraphDrive drive;

    /*
     * The group's drives. Read-only.
     */
    private List<MicrosoftGraphDrive> drives;

    /*
     * The list of SharePoint sites in this group. Access the default site with /sites/root.
     */
    private List<MicrosoftGraphSite> sites;

    /*
     * The collection of open extensions defined for the group. Read-only. Nullable.
     */
    private List<MicrosoftGraphExtension> extensions;

    /*
     * The collection of lifecycle policies for this group. Read-only. Nullable.
     */
    private List<MicrosoftGraphGroupLifecyclePolicy> groupLifecyclePolicies;

    /*
     * plannerGroup
     */
    private MicrosoftGraphPlannerGroup planner;

    /*
     * onenote
     */
    private MicrosoftGraphOnenote onenote;

    /*
     * team
     */
    private MicrosoftGraphTeamInner team;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
     * entity types.
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphGroupInner class.
     */
    public MicrosoftGraphGroupInner() {
    }

    /**
     * Get the assignedLabels property: The list of sensitivity label pairs (label ID, label name) associated with an
     * Microsoft 365 group. Returned only on $select. Read-only.
     * 
     * @return the assignedLabels value.
     */
    public List<MicrosoftGraphAssignedLabel> assignedLabels() {
        return this.assignedLabels;
    }

    /**
     * Set the assignedLabels property: The list of sensitivity label pairs (label ID, label name) associated with an
     * Microsoft 365 group. Returned only on $select. Read-only.
     * 
     * @param assignedLabels the assignedLabels value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAssignedLabels(List<MicrosoftGraphAssignedLabel> assignedLabels) {
        this.assignedLabels = assignedLabels;
        return this;
    }

    /**
     * Get the assignedLicenses property: The licenses that are assigned to the group. Returned only on $select.
     * Read-only.
     * 
     * @return the assignedLicenses value.
     */
    public List<MicrosoftGraphAssignedLicense> assignedLicenses() {
        return this.assignedLicenses;
    }

    /**
     * Set the assignedLicenses property: The licenses that are assigned to the group. Returned only on $select.
     * Read-only.
     * 
     * @param assignedLicenses the assignedLicenses value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAssignedLicenses(List<MicrosoftGraphAssignedLicense> assignedLicenses) {
        this.assignedLicenses = assignedLicenses;
        return this;
    }

    /**
     * Get the classification property: Describes a classification for the group (such as low, medium or high business
     * impact). Valid values for this property are defined by creating a ClassificationList setting value, based on the
     * template definition.Returned by default.
     * 
     * @return the classification value.
     */
    public String classification() {
        return this.classification;
    }

    /**
     * Set the classification property: Describes a classification for the group (such as low, medium or high business
     * impact). Valid values for this property are defined by creating a ClassificationList setting value, based on the
     * template definition.Returned by default.
     * 
     * @param classification the classification value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withClassification(String classification) {
        this.classification = classification;
        return this;
    }

    /**
     * Get the createdDateTime property: Timestamp of when the group was created. The value cannot be modified and is
     * automatically populated when the group is created. The Timestamp type represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Timestamp of when the group was created. The value cannot be modified and is
     * automatically populated when the group is created. The Timestamp type represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     * 
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the description property: An optional description for the group. Returned by default.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: An optional description for the group. Returned by default.
     * 
     * @param description the description value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: The display name for the group. This property is required when a group is created
     * and cannot be cleared during updates. Returned by default. Supports $filter and $orderby.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name for the group. This property is required when a group is created
     * and cannot be cleared during updates. Returned by default. Supports $filter and $orderby.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the expirationDateTime property: Timestamp of when the group is set to expire. The value cannot be modified
     * and is automatically populated when the group is created. The Timestamp type represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     * 
     * @return the expirationDateTime value.
     */
    public OffsetDateTime expirationDateTime() {
        return this.expirationDateTime;
    }

    /**
     * Set the expirationDateTime property: Timestamp of when the group is set to expire. The value cannot be modified
     * and is automatically populated when the group is created. The Timestamp type represents date and time information
     * using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     * 
     * @param expirationDateTime the expirationDateTime value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    /**
     * Get the groupTypes property: Specifies the group type and its membership. If the collection contains Unified, the
     * group is a Microsoft 365 group; otherwise, it's either a security group or distribution group. For details, see
     * groups overview.If the collection includes DynamicMembership, the group has dynamic membership; otherwise,
     * membership is static. Returned by default. Supports $filter.
     * 
     * @return the groupTypes value.
     */
    public List<String> groupTypes() {
        return this.groupTypes;
    }

    /**
     * Set the groupTypes property: Specifies the group type and its membership. If the collection contains Unified, the
     * group is a Microsoft 365 group; otherwise, it's either a security group or distribution group. For details, see
     * groups overview.If the collection includes DynamicMembership, the group has dynamic membership; otherwise,
     * membership is static. Returned by default. Supports $filter.
     * 
     * @param groupTypes the groupTypes value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withGroupTypes(List<String> groupTypes) {
        this.groupTypes = groupTypes;
        return this;
    }

    /**
     * Get the hasMembersWithLicenseErrors property: Indicates whether there are members in this group that have license
     * errors from its group-based license assignment. This property is never returned on a GET operation. You can use
     * it as a $filter argument to get groups that have members with license errors (that is, filter for this property
     * being true). See an example.
     * 
     * @return the hasMembersWithLicenseErrors value.
     */
    public Boolean hasMembersWithLicenseErrors() {
        return this.hasMembersWithLicenseErrors;
    }

    /**
     * Set the hasMembersWithLicenseErrors property: Indicates whether there are members in this group that have license
     * errors from its group-based license assignment. This property is never returned on a GET operation. You can use
     * it as a $filter argument to get groups that have members with license errors (that is, filter for this property
     * being true). See an example.
     * 
     * @param hasMembersWithLicenseErrors the hasMembersWithLicenseErrors value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withHasMembersWithLicenseErrors(Boolean hasMembersWithLicenseErrors) {
        this.hasMembersWithLicenseErrors = hasMembersWithLicenseErrors;
        return this;
    }

    /**
     * Get the licenseProcessingState property: licenseProcessingState.
     * 
     * @return the licenseProcessingState value.
     */
    public MicrosoftGraphLicenseProcessingState licenseProcessingState() {
        return this.licenseProcessingState;
    }

    /**
     * Set the licenseProcessingState property: licenseProcessingState.
     * 
     * @param licenseProcessingState the licenseProcessingState value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner
        withLicenseProcessingState(MicrosoftGraphLicenseProcessingState licenseProcessingState) {
        this.licenseProcessingState = licenseProcessingState;
        return this;
    }

    /**
     * Get the mail property: The SMTP address for the group, for example, 'serviceadmins&#064;contoso.onmicrosoft.com'.
     * Returned by default. Read-only. Supports $filter.
     * 
     * @return the mail value.
     */
    public String mail() {
        return this.mail;
    }

    /**
     * Set the mail property: The SMTP address for the group, for example, 'serviceadmins&#064;contoso.onmicrosoft.com'.
     * Returned by default. Read-only. Supports $filter.
     * 
     * @param mail the mail value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMail(String mail) {
        this.mail = mail;
        return this;
    }

    /**
     * Get the mailEnabled property: Specifies whether the group is mail-enabled. Returned by default.
     * 
     * @return the mailEnabled value.
     */
    public Boolean mailEnabled() {
        return this.mailEnabled;
    }

    /**
     * Set the mailEnabled property: Specifies whether the group is mail-enabled. Returned by default.
     * 
     * @param mailEnabled the mailEnabled value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMailEnabled(Boolean mailEnabled) {
        this.mailEnabled = mailEnabled;
        return this;
    }

    /**
     * Get the mailNickname property: The mailNickname property.
     * 
     * @return the mailNickname value.
     */
    public String mailNickname() {
        return this.mailNickname;
    }

    /**
     * Set the mailNickname property: The mailNickname property.
     * 
     * @param mailNickname the mailNickname value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMailNickname(String mailNickname) {
        this.mailNickname = mailNickname;
        return this;
    }

    /**
     * Get the membershipRule property: The rule that determines members for this group if the group is a dynamic group
     * (groupTypes contains DynamicMembership). For more information about the syntax of the membership rule, see
     * Membership Rules syntax. Returned by default.
     * 
     * @return the membershipRule value.
     */
    public String membershipRule() {
        return this.membershipRule;
    }

    /**
     * Set the membershipRule property: The rule that determines members for this group if the group is a dynamic group
     * (groupTypes contains DynamicMembership). For more information about the syntax of the membership rule, see
     * Membership Rules syntax. Returned by default.
     * 
     * @param membershipRule the membershipRule value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMembershipRule(String membershipRule) {
        this.membershipRule = membershipRule;
        return this;
    }

    /**
     * Get the membershipRuleProcessingState property: Indicates whether the dynamic membership processing is on or
     * paused. Possible values are 'On' or 'Paused'. Returned by default.
     * 
     * @return the membershipRuleProcessingState value.
     */
    public String membershipRuleProcessingState() {
        return this.membershipRuleProcessingState;
    }

    /**
     * Set the membershipRuleProcessingState property: Indicates whether the dynamic membership processing is on or
     * paused. Possible values are 'On' or 'Paused'. Returned by default.
     * 
     * @param membershipRuleProcessingState the membershipRuleProcessingState value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMembershipRuleProcessingState(String membershipRuleProcessingState) {
        this.membershipRuleProcessingState = membershipRuleProcessingState;
        return this;
    }

    /**
     * Get the onPremisesDomainName property: The onPremisesDomainName property.
     * 
     * @return the onPremisesDomainName value.
     */
    public String onPremisesDomainName() {
        return this.onPremisesDomainName;
    }

    /**
     * Set the onPremisesDomainName property: The onPremisesDomainName property.
     * 
     * @param onPremisesDomainName the onPremisesDomainName value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesDomainName(String onPremisesDomainName) {
        this.onPremisesDomainName = onPremisesDomainName;
        return this;
    }

    /**
     * Get the onPremisesLastSyncDateTime property: The onPremisesLastSyncDateTime property.
     * 
     * @return the onPremisesLastSyncDateTime value.
     */
    public OffsetDateTime onPremisesLastSyncDateTime() {
        return this.onPremisesLastSyncDateTime;
    }

    /**
     * Set the onPremisesLastSyncDateTime property: The onPremisesLastSyncDateTime property.
     * 
     * @param onPremisesLastSyncDateTime the onPremisesLastSyncDateTime value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
        this.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        return this;
    }

    /**
     * Get the onPremisesNetBiosName property: The onPremisesNetBiosName property.
     * 
     * @return the onPremisesNetBiosName value.
     */
    public String onPremisesNetBiosName() {
        return this.onPremisesNetBiosName;
    }

    /**
     * Set the onPremisesNetBiosName property: The onPremisesNetBiosName property.
     * 
     * @param onPremisesNetBiosName the onPremisesNetBiosName value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesNetBiosName(String onPremisesNetBiosName) {
        this.onPremisesNetBiosName = onPremisesNetBiosName;
        return this;
    }

    /**
     * Get the onPremisesProvisioningErrors property: The onPremisesProvisioningErrors property.
     * 
     * @return the onPremisesProvisioningErrors value.
     */
    public List<MicrosoftGraphOnPremisesProvisioningError> onPremisesProvisioningErrors() {
        return this.onPremisesProvisioningErrors;
    }

    /**
     * Set the onPremisesProvisioningErrors property: The onPremisesProvisioningErrors property.
     * 
     * @param onPremisesProvisioningErrors the onPremisesProvisioningErrors value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner
        withOnPremisesProvisioningErrors(List<MicrosoftGraphOnPremisesProvisioningError> onPremisesProvisioningErrors) {
        this.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
        return this;
    }

    /**
     * Get the onPremisesSamAccountName property: Contains the on-premises SAM account name synchronized from the
     * on-premises directory. The property is only populated for customers who are synchronizing their on-premises
     * directory to Azure Active Directory via Azure AD Connect.Returned by default. Read-only.
     * 
     * @return the onPremisesSamAccountName value.
     */
    public String onPremisesSamAccountName() {
        return this.onPremisesSamAccountName;
    }

    /**
     * Set the onPremisesSamAccountName property: Contains the on-premises SAM account name synchronized from the
     * on-premises directory. The property is only populated for customers who are synchronizing their on-premises
     * directory to Azure Active Directory via Azure AD Connect.Returned by default. Read-only.
     * 
     * @param onPremisesSamAccountName the onPremisesSamAccountName value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesSamAccountName(String onPremisesSamAccountName) {
        this.onPremisesSamAccountName = onPremisesSamAccountName;
        return this;
    }

    /**
     * Get the onPremisesSecurityIdentifier property: Contains the on-premises security identifier (SID) for the group
     * that was synchronized from on-premises to the cloud. Returned by default. Read-only.
     * 
     * @return the onPremisesSecurityIdentifier value.
     */
    public String onPremisesSecurityIdentifier() {
        return this.onPremisesSecurityIdentifier;
    }

    /**
     * Set the onPremisesSecurityIdentifier property: Contains the on-premises security identifier (SID) for the group
     * that was synchronized from on-premises to the cloud. Returned by default. Read-only.
     * 
     * @param onPremisesSecurityIdentifier the onPremisesSecurityIdentifier value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
        this.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        return this;
    }

    /**
     * Get the onPremisesSyncEnabled property: true if this group is synced from an on-premises directory; false if this
     * group was originally synced from an on-premises directory but is no longer synced; null if this object has never
     * been synced from an on-premises directory (default). Returned by default. Read-only. Supports $filter.
     * 
     * @return the onPremisesSyncEnabled value.
     */
    public Boolean onPremisesSyncEnabled() {
        return this.onPremisesSyncEnabled;
    }

    /**
     * Set the onPremisesSyncEnabled property: true if this group is synced from an on-premises directory; false if this
     * group was originally synced from an on-premises directory but is no longer synced; null if this object has never
     * been synced from an on-premises directory (default). Returned by default. Read-only. Supports $filter.
     * 
     * @param onPremisesSyncEnabled the onPremisesSyncEnabled value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
        this.onPremisesSyncEnabled = onPremisesSyncEnabled;
        return this;
    }

    /**
     * Get the preferredDataLocation property: The preferred data location for the group. For more information, see
     * OneDrive Online Multi-Geo. Returned by default.
     * 
     * @return the preferredDataLocation value.
     */
    public String preferredDataLocation() {
        return this.preferredDataLocation;
    }

    /**
     * Set the preferredDataLocation property: The preferred data location for the group. For more information, see
     * OneDrive Online Multi-Geo. Returned by default.
     * 
     * @param preferredDataLocation the preferredDataLocation value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withPreferredDataLocation(String preferredDataLocation) {
        this.preferredDataLocation = preferredDataLocation;
        return this;
    }

    /**
     * Get the preferredLanguage property: The preferred language for an Microsoft 365 group. Should follow ISO 639-1
     * Code; for example 'en-US'. Returned by default.
     * 
     * @return the preferredLanguage value.
     */
    public String preferredLanguage() {
        return this.preferredLanguage;
    }

    /**
     * Set the preferredLanguage property: The preferred language for an Microsoft 365 group. Should follow ISO 639-1
     * Code; for example 'en-US'. Returned by default.
     * 
     * @param preferredLanguage the preferredLanguage value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
        return this;
    }

    /**
     * Get the proxyAddresses property: The proxyAddresses property.
     * 
     * @return the proxyAddresses value.
     */
    public List<String> proxyAddresses() {
        return this.proxyAddresses;
    }

    /**
     * Set the proxyAddresses property: The proxyAddresses property.
     * 
     * @param proxyAddresses the proxyAddresses value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withProxyAddresses(List<String> proxyAddresses) {
        this.proxyAddresses = proxyAddresses;
        return this;
    }

    /**
     * Get the renewedDateTime property: Timestamp of when the group was last renewed. This cannot be modified directly
     * and is only updated via the renew service action. The Timestamp type represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     * 
     * @return the renewedDateTime value.
     */
    public OffsetDateTime renewedDateTime() {
        return this.renewedDateTime;
    }

    /**
     * Set the renewedDateTime property: Timestamp of when the group was last renewed. This cannot be modified directly
     * and is only updated via the renew service action. The Timestamp type represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Returned by default. Read-only.
     * 
     * @param renewedDateTime the renewedDateTime value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withRenewedDateTime(OffsetDateTime renewedDateTime) {
        this.renewedDateTime = renewedDateTime;
        return this;
    }

    /**
     * Get the securityEnabled property: Specifies whether the group is a security group. Returned by default. Supports
     * $filter.
     * 
     * @return the securityEnabled value.
     */
    public Boolean securityEnabled() {
        return this.securityEnabled;
    }

    /**
     * Set the securityEnabled property: Specifies whether the group is a security group. Returned by default. Supports
     * $filter.
     * 
     * @param securityEnabled the securityEnabled value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withSecurityEnabled(Boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
        return this;
    }

    /**
     * Get the securityIdentifier property: Security identifier of the group, used in Windows scenarios. Returned by
     * default.
     * 
     * @return the securityIdentifier value.
     */
    public String securityIdentifier() {
        return this.securityIdentifier;
    }

    /**
     * Set the securityIdentifier property: Security identifier of the group, used in Windows scenarios. Returned by
     * default.
     * 
     * @param securityIdentifier the securityIdentifier value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withSecurityIdentifier(String securityIdentifier) {
        this.securityIdentifier = securityIdentifier;
        return this;
    }

    /**
     * Get the theme property: Specifies an Microsoft 365 group's color theme. Possible values are Teal, Purple, Green,
     * Blue, Pink, Orange or Red. Returned by default.
     * 
     * @return the theme value.
     */
    public String theme() {
        return this.theme;
    }

    /**
     * Set the theme property: Specifies an Microsoft 365 group's color theme. Possible values are Teal, Purple, Green,
     * Blue, Pink, Orange or Red. Returned by default.
     * 
     * @param theme the theme value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withTheme(String theme) {
        this.theme = theme;
        return this;
    }

    /**
     * Get the visibility property: Specifies the visibility of a Microsoft 365 group. Possible values are: Private,
     * Public, or Hiddenmembership; blank values are treated as public. See group visibility options to learn
     * more.Visibility can be set only when a group is created; it is not editable.Visibility is supported only for
     * unified groups; it is not supported for security groups. Returned by default.
     * 
     * @return the visibility value.
     */
    public String visibility() {
        return this.visibility;
    }

    /**
     * Set the visibility property: Specifies the visibility of a Microsoft 365 group. Possible values are: Private,
     * Public, or Hiddenmembership; blank values are treated as public. See group visibility options to learn
     * more.Visibility can be set only when a group is created; it is not editable.Visibility is supported only for
     * unified groups; it is not supported for security groups. Returned by default.
     * 
     * @param visibility the visibility value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withVisibility(String visibility) {
        this.visibility = visibility;
        return this;
    }

    /**
     * Get the allowExternalSenders property: Indicates if people external to the organization can send messages to the
     * group. Default value is false. Returned only on $select.
     * 
     * @return the allowExternalSenders value.
     */
    public Boolean allowExternalSenders() {
        return this.allowExternalSenders;
    }

    /**
     * Set the allowExternalSenders property: Indicates if people external to the organization can send messages to the
     * group. Default value is false. Returned only on $select.
     * 
     * @param allowExternalSenders the allowExternalSenders value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAllowExternalSenders(Boolean allowExternalSenders) {
        this.allowExternalSenders = allowExternalSenders;
        return this;
    }

    /**
     * Get the autoSubscribeNewMembers property: Indicates if new members added to the group will be auto-subscribed to
     * receive email notifications. You can set this property in a PATCH request for the group; do not set it in the
     * initial POST request that creates the group. Default value is false. Returned only on $select.
     * 
     * @return the autoSubscribeNewMembers value.
     */
    public Boolean autoSubscribeNewMembers() {
        return this.autoSubscribeNewMembers;
    }

    /**
     * Set the autoSubscribeNewMembers property: Indicates if new members added to the group will be auto-subscribed to
     * receive email notifications. You can set this property in a PATCH request for the group; do not set it in the
     * initial POST request that creates the group. Default value is false. Returned only on $select.
     * 
     * @param autoSubscribeNewMembers the autoSubscribeNewMembers value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAutoSubscribeNewMembers(Boolean autoSubscribeNewMembers) {
        this.autoSubscribeNewMembers = autoSubscribeNewMembers;
        return this;
    }

    /**
     * Get the hideFromAddressLists property: True if the group is not displayed in certain parts of the Outlook UI: the
     * Address Book, address lists for selecting message recipients, and the Browse Groups dialog for searching groups;
     * otherwise, false. Default value is false. Returned only on $select.
     * 
     * @return the hideFromAddressLists value.
     */
    public Boolean hideFromAddressLists() {
        return this.hideFromAddressLists;
    }

    /**
     * Set the hideFromAddressLists property: True if the group is not displayed in certain parts of the Outlook UI: the
     * Address Book, address lists for selecting message recipients, and the Browse Groups dialog for searching groups;
     * otherwise, false. Default value is false. Returned only on $select.
     * 
     * @param hideFromAddressLists the hideFromAddressLists value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withHideFromAddressLists(Boolean hideFromAddressLists) {
        this.hideFromAddressLists = hideFromAddressLists;
        return this;
    }

    /**
     * Get the hideFromOutlookClients property: True if the group is not displayed in Outlook clients, such as Outlook
     * for Windows and Outlook on the web; otherwise, false. Default value is false. Returned only on $select.
     * 
     * @return the hideFromOutlookClients value.
     */
    public Boolean hideFromOutlookClients() {
        return this.hideFromOutlookClients;
    }

    /**
     * Set the hideFromOutlookClients property: True if the group is not displayed in Outlook clients, such as Outlook
     * for Windows and Outlook on the web; otherwise, false. Default value is false. Returned only on $select.
     * 
     * @param hideFromOutlookClients the hideFromOutlookClients value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withHideFromOutlookClients(Boolean hideFromOutlookClients) {
        this.hideFromOutlookClients = hideFromOutlookClients;
        return this;
    }

    /**
     * Get the isSubscribedByMail property: Indicates whether the signed-in user is subscribed to receive email
     * conversations. Default value is true. Returned only on $select.
     * 
     * @return the isSubscribedByMail value.
     */
    public Boolean isSubscribedByMail() {
        return this.isSubscribedByMail;
    }

    /**
     * Set the isSubscribedByMail property: Indicates whether the signed-in user is subscribed to receive email
     * conversations. Default value is true. Returned only on $select.
     * 
     * @param isSubscribedByMail the isSubscribedByMail value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withIsSubscribedByMail(Boolean isSubscribedByMail) {
        this.isSubscribedByMail = isSubscribedByMail;
        return this;
    }

    /**
     * Get the unseenCount property: Count of conversations that have received new posts since the signed-in user last
     * visited the group. Returned only on $select.
     * 
     * @return the unseenCount value.
     */
    public Integer unseenCount() {
        return this.unseenCount;
    }

    /**
     * Set the unseenCount property: Count of conversations that have received new posts since the signed-in user last
     * visited the group. Returned only on $select.
     * 
     * @param unseenCount the unseenCount value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withUnseenCount(Integer unseenCount) {
        this.unseenCount = unseenCount;
        return this;
    }

    /**
     * Get the isArchived property: The isArchived property.
     * 
     * @return the isArchived value.
     */
    public Boolean isArchived() {
        return this.isArchived;
    }

    /**
     * Set the isArchived property: The isArchived property.
     * 
     * @param isArchived the isArchived value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withIsArchived(Boolean isArchived) {
        this.isArchived = isArchived;
        return this;
    }

    /**
     * Get the appRoleAssignments property: The appRoleAssignments property.
     * 
     * @return the appRoleAssignments value.
     */
    public List<MicrosoftGraphAppRoleAssignment> appRoleAssignments() {
        return this.appRoleAssignments;
    }

    /**
     * Set the appRoleAssignments property: The appRoleAssignments property.
     * 
     * @param appRoleAssignments the appRoleAssignments value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAppRoleAssignments(List<MicrosoftGraphAppRoleAssignment> appRoleAssignments) {
        this.appRoleAssignments = appRoleAssignments;
        return this;
    }

    /**
     * Get the createdOnBehalfOf property: Represents an Azure Active Directory object. The directoryObject type is the
     * base type for many other directory entity types.
     * 
     * @return the createdOnBehalfOf value.
     */
    public MicrosoftGraphDirectoryObjectInner createdOnBehalfOf() {
        return this.createdOnBehalfOf;
    }

    /**
     * Set the createdOnBehalfOf property: Represents an Azure Active Directory object. The directoryObject type is the
     * base type for many other directory entity types.
     * 
     * @param createdOnBehalfOf the createdOnBehalfOf value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withCreatedOnBehalfOf(MicrosoftGraphDirectoryObjectInner createdOnBehalfOf) {
        this.createdOnBehalfOf = createdOnBehalfOf;
        return this;
    }

    /**
     * Get the memberOf property: Groups that this group is a member of. HTTP Methods: GET (supported for all groups).
     * Read-only. Nullable.
     * 
     * @return the memberOf value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> memberOf() {
        return this.memberOf;
    }

    /**
     * Set the memberOf property: Groups that this group is a member of. HTTP Methods: GET (supported for all groups).
     * Read-only. Nullable.
     * 
     * @param memberOf the memberOf value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMemberOf(List<MicrosoftGraphDirectoryObjectInner> memberOf) {
        this.memberOf = memberOf;
        return this;
    }

    /**
     * Get the members property: Users and groups that are members of this group. HTTP Methods: GET (supported for all
     * groups), POST (supported for Microsoft 365 groups, security groups and mail-enabled security groups), DELETE
     * (supported for Microsoft 365 groups and security groups) Nullable.
     * 
     * @return the members value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> members() {
        return this.members;
    }

    /**
     * Set the members property: Users and groups that are members of this group. HTTP Methods: GET (supported for all
     * groups), POST (supported for Microsoft 365 groups, security groups and mail-enabled security groups), DELETE
     * (supported for Microsoft 365 groups and security groups) Nullable.
     * 
     * @param members the members value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withMembers(List<MicrosoftGraphDirectoryObjectInner> members) {
        this.members = members;
        return this;
    }

    /**
     * Get the membersWithLicenseErrors property: A list of group members with license errors from this group-based
     * license assignment. Read-only.
     * 
     * @return the membersWithLicenseErrors value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> membersWithLicenseErrors() {
        return this.membersWithLicenseErrors;
    }

    /**
     * Set the membersWithLicenseErrors property: A list of group members with license errors from this group-based
     * license assignment. Read-only.
     * 
     * @param membersWithLicenseErrors the membersWithLicenseErrors value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner
        withMembersWithLicenseErrors(List<MicrosoftGraphDirectoryObjectInner> membersWithLicenseErrors) {
        this.membersWithLicenseErrors = membersWithLicenseErrors;
        return this;
    }

    /**
     * Get the owners property: The owners of the group. The owners are a set of non-admin users who are allowed to
     * modify this object. Limited to 100 owners. HTTP Methods: GET (supported for all groups), POST (supported for
     * Microsoft 365 groups, security groups and mail-enabled security groups), DELETE (supported for Microsoft 365
     * groups and security groups). Nullable.
     * 
     * @return the owners value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> owners() {
        return this.owners;
    }

    /**
     * Set the owners property: The owners of the group. The owners are a set of non-admin users who are allowed to
     * modify this object. Limited to 100 owners. HTTP Methods: GET (supported for all groups), POST (supported for
     * Microsoft 365 groups, security groups and mail-enabled security groups), DELETE (supported for Microsoft 365
     * groups and security groups). Nullable.
     * 
     * @param owners the owners value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOwners(List<MicrosoftGraphDirectoryObjectInner> owners) {
        this.owners = owners;
        return this;
    }

    /**
     * Get the permissionGrants property: The permissionGrants property.
     * 
     * @return the permissionGrants value.
     */
    public List<MicrosoftGraphResourceSpecificPermissionGrant> permissionGrants() {
        return this.permissionGrants;
    }

    /**
     * Set the permissionGrants property: The permissionGrants property.
     * 
     * @param permissionGrants the permissionGrants value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner
        withPermissionGrants(List<MicrosoftGraphResourceSpecificPermissionGrant> permissionGrants) {
        this.permissionGrants = permissionGrants;
        return this;
    }

    /**
     * Get the settings property: Read-only. Nullable.
     * 
     * @return the settings value.
     */
    public List<MicrosoftGraphGroupSetting> settings() {
        return this.settings;
    }

    /**
     * Set the settings property: Read-only. Nullable.
     * 
     * @param settings the settings value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withSettings(List<MicrosoftGraphGroupSetting> settings) {
        this.settings = settings;
        return this;
    }

    /**
     * Get the transitiveMemberOf property: The transitiveMemberOf property.
     * 
     * @return the transitiveMemberOf value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf() {
        return this.transitiveMemberOf;
    }

    /**
     * Set the transitiveMemberOf property: The transitiveMemberOf property.
     * 
     * @param transitiveMemberOf the transitiveMemberOf value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner
        withTransitiveMemberOf(List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf) {
        this.transitiveMemberOf = transitiveMemberOf;
        return this;
    }

    /**
     * Get the transitiveMembers property: The transitiveMembers property.
     * 
     * @return the transitiveMembers value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> transitiveMembers() {
        return this.transitiveMembers;
    }

    /**
     * Set the transitiveMembers property: The transitiveMembers property.
     * 
     * @param transitiveMembers the transitiveMembers value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withTransitiveMembers(List<MicrosoftGraphDirectoryObjectInner> transitiveMembers) {
        this.transitiveMembers = transitiveMembers;
        return this;
    }

    /**
     * Get the acceptedSenders property: The list of users or groups that are allowed to create post's or calendar
     * events in this group. If this list is non-empty then only users or groups listed here are allowed to post.
     * 
     * @return the acceptedSenders value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> acceptedSenders() {
        return this.acceptedSenders;
    }

    /**
     * Set the acceptedSenders property: The list of users or groups that are allowed to create post's or calendar
     * events in this group. If this list is non-empty then only users or groups listed here are allowed to post.
     * 
     * @param acceptedSenders the acceptedSenders value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAcceptedSenders(List<MicrosoftGraphDirectoryObjectInner> acceptedSenders) {
        this.acceptedSenders = acceptedSenders;
        return this;
    }

    /**
     * Get the calendar property: calendar.
     * 
     * @return the calendar value.
     */
    public MicrosoftGraphCalendar calendar() {
        return this.calendar;
    }

    /**
     * Set the calendar property: calendar.
     * 
     * @param calendar the calendar value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withCalendar(MicrosoftGraphCalendar calendar) {
        this.calendar = calendar;
        return this;
    }

    /**
     * Get the calendarView property: The calendar view for the calendar. Read-only.
     * 
     * @return the calendarView value.
     */
    public List<MicrosoftGraphEvent> calendarView() {
        return this.calendarView;
    }

    /**
     * Set the calendarView property: The calendar view for the calendar. Read-only.
     * 
     * @param calendarView the calendarView value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withCalendarView(List<MicrosoftGraphEvent> calendarView) {
        this.calendarView = calendarView;
        return this;
    }

    /**
     * Get the conversations property: The group's conversations.
     * 
     * @return the conversations value.
     */
    public List<MicrosoftGraphConversation> conversations() {
        return this.conversations;
    }

    /**
     * Set the conversations property: The group's conversations.
     * 
     * @param conversations the conversations value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withConversations(List<MicrosoftGraphConversation> conversations) {
        this.conversations = conversations;
        return this;
    }

    /**
     * Get the events property: The group's calendar events.
     * 
     * @return the events value.
     */
    public List<MicrosoftGraphEvent> events() {
        return this.events;
    }

    /**
     * Set the events property: The group's calendar events.
     * 
     * @param events the events value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withEvents(List<MicrosoftGraphEvent> events) {
        this.events = events;
        return this;
    }

    /**
     * Get the photo property: profilePhoto.
     * 
     * @return the photo value.
     */
    public MicrosoftGraphProfilePhoto photo() {
        return this.photo;
    }

    /**
     * Set the photo property: profilePhoto.
     * 
     * @param photo the photo value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withPhoto(MicrosoftGraphProfilePhoto photo) {
        this.photo = photo;
        return this;
    }

    /**
     * Get the photos property: The profile photos owned by the group. Read-only. Nullable.
     * 
     * @return the photos value.
     */
    public List<MicrosoftGraphProfilePhoto> photos() {
        return this.photos;
    }

    /**
     * Set the photos property: The profile photos owned by the group. Read-only. Nullable.
     * 
     * @param photos the photos value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withPhotos(List<MicrosoftGraphProfilePhoto> photos) {
        this.photos = photos;
        return this;
    }

    /**
     * Get the rejectedSenders property: The list of users or groups that are not allowed to create posts or calendar
     * events in this group. Nullable.
     * 
     * @return the rejectedSenders value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> rejectedSenders() {
        return this.rejectedSenders;
    }

    /**
     * Set the rejectedSenders property: The list of users or groups that are not allowed to create posts or calendar
     * events in this group. Nullable.
     * 
     * @param rejectedSenders the rejectedSenders value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withRejectedSenders(List<MicrosoftGraphDirectoryObjectInner> rejectedSenders) {
        this.rejectedSenders = rejectedSenders;
        return this;
    }

    /**
     * Get the threads property: The group's conversation threads. Nullable.
     * 
     * @return the threads value.
     */
    public List<MicrosoftGraphConversationThread> threads() {
        return this.threads;
    }

    /**
     * Set the threads property: The group's conversation threads. Nullable.
     * 
     * @param threads the threads value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withThreads(List<MicrosoftGraphConversationThread> threads) {
        this.threads = threads;
        return this;
    }

    /**
     * Get the drive property: drive.
     * 
     * @return the drive value.
     */
    public MicrosoftGraphDrive drive() {
        return this.drive;
    }

    /**
     * Set the drive property: drive.
     * 
     * @param drive the drive value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withDrive(MicrosoftGraphDrive drive) {
        this.drive = drive;
        return this;
    }

    /**
     * Get the drives property: The group's drives. Read-only.
     * 
     * @return the drives value.
     */
    public List<MicrosoftGraphDrive> drives() {
        return this.drives;
    }

    /**
     * Set the drives property: The group's drives. Read-only.
     * 
     * @param drives the drives value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withDrives(List<MicrosoftGraphDrive> drives) {
        this.drives = drives;
        return this;
    }

    /**
     * Get the sites property: The list of SharePoint sites in this group. Access the default site with /sites/root.
     * 
     * @return the sites value.
     */
    public List<MicrosoftGraphSite> sites() {
        return this.sites;
    }

    /**
     * Set the sites property: The list of SharePoint sites in this group. Access the default site with /sites/root.
     * 
     * @param sites the sites value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withSites(List<MicrosoftGraphSite> sites) {
        this.sites = sites;
        return this;
    }

    /**
     * Get the extensions property: The collection of open extensions defined for the group. Read-only. Nullable.
     * 
     * @return the extensions value.
     */
    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: The collection of open extensions defined for the group. Read-only. Nullable.
     * 
     * @param extensions the extensions value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the groupLifecyclePolicies property: The collection of lifecycle policies for this group. Read-only.
     * Nullable.
     * 
     * @return the groupLifecyclePolicies value.
     */
    public List<MicrosoftGraphGroupLifecyclePolicy> groupLifecyclePolicies() {
        return this.groupLifecyclePolicies;
    }

    /**
     * Set the groupLifecyclePolicies property: The collection of lifecycle policies for this group. Read-only.
     * Nullable.
     * 
     * @param groupLifecyclePolicies the groupLifecyclePolicies value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner
        withGroupLifecyclePolicies(List<MicrosoftGraphGroupLifecyclePolicy> groupLifecyclePolicies) {
        this.groupLifecyclePolicies = groupLifecyclePolicies;
        return this;
    }

    /**
     * Get the planner property: plannerGroup.
     * 
     * @return the planner value.
     */
    public MicrosoftGraphPlannerGroup planner() {
        return this.planner;
    }

    /**
     * Set the planner property: plannerGroup.
     * 
     * @param planner the planner value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withPlanner(MicrosoftGraphPlannerGroup planner) {
        this.planner = planner;
        return this;
    }

    /**
     * Get the onenote property: onenote.
     * 
     * @return the onenote value.
     */
    public MicrosoftGraphOnenote onenote() {
        return this.onenote;
    }

    /**
     * Set the onenote property: onenote.
     * 
     * @param onenote the onenote value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withOnenote(MicrosoftGraphOnenote onenote) {
        this.onenote = onenote;
        return this;
    }

    /**
     * Get the team property: team.
     * 
     * @return the team value.
     */
    public MicrosoftGraphTeamInner team() {
        return this.team;
    }

    /**
     * Set the team property: team.
     * 
     * @param team the team value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withTeam(MicrosoftGraphTeamInner team) {
        this.team = team;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphGroupInner object itself.
     */
    public MicrosoftGraphGroupInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphGroupInner withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphGroupInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (assignedLabels() != null) {
            assignedLabels().forEach(e -> e.validate());
        }
        if (assignedLicenses() != null) {
            assignedLicenses().forEach(e -> e.validate());
        }
        if (licenseProcessingState() != null) {
            licenseProcessingState().validate();
        }
        if (onPremisesProvisioningErrors() != null) {
            onPremisesProvisioningErrors().forEach(e -> e.validate());
        }
        if (appRoleAssignments() != null) {
            appRoleAssignments().forEach(e -> e.validate());
        }
        if (createdOnBehalfOf() != null) {
            createdOnBehalfOf().validate();
        }
        if (memberOf() != null) {
            memberOf().forEach(e -> e.validate());
        }
        if (members() != null) {
            members().forEach(e -> e.validate());
        }
        if (membersWithLicenseErrors() != null) {
            membersWithLicenseErrors().forEach(e -> e.validate());
        }
        if (owners() != null) {
            owners().forEach(e -> e.validate());
        }
        if (permissionGrants() != null) {
            permissionGrants().forEach(e -> e.validate());
        }
        if (settings() != null) {
            settings().forEach(e -> e.validate());
        }
        if (transitiveMemberOf() != null) {
            transitiveMemberOf().forEach(e -> e.validate());
        }
        if (transitiveMembers() != null) {
            transitiveMembers().forEach(e -> e.validate());
        }
        if (acceptedSenders() != null) {
            acceptedSenders().forEach(e -> e.validate());
        }
        if (calendar() != null) {
            calendar().validate();
        }
        if (calendarView() != null) {
            calendarView().forEach(e -> e.validate());
        }
        if (conversations() != null) {
            conversations().forEach(e -> e.validate());
        }
        if (events() != null) {
            events().forEach(e -> e.validate());
        }
        if (photo() != null) {
            photo().validate();
        }
        if (photos() != null) {
            photos().forEach(e -> e.validate());
        }
        if (rejectedSenders() != null) {
            rejectedSenders().forEach(e -> e.validate());
        }
        if (threads() != null) {
            threads().forEach(e -> e.validate());
        }
        if (drive() != null) {
            drive().validate();
        }
        if (drives() != null) {
            drives().forEach(e -> e.validate());
        }
        if (sites() != null) {
            sites().forEach(e -> e.validate());
        }
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
        if (groupLifecyclePolicies() != null) {
            groupLifecyclePolicies().forEach(e -> e.validate());
        }
        if (planner() != null) {
            planner().validate();
        }
        if (onenote() != null) {
            onenote().validate();
        }
        if (team() != null) {
            team().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("deletedDateTime",
            deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(deletedDateTime()));
        jsonWriter.writeArrayField("assignedLabels", this.assignedLabels,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("assignedLicenses", this.assignedLicenses,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("classification", this.classification);
        jsonWriter.writeStringField("createdDateTime",
            this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("expirationDateTime",
            this.expirationDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        jsonWriter.writeArrayField("groupTypes", this.groupTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("hasMembersWithLicenseErrors", this.hasMembersWithLicenseErrors);
        jsonWriter.writeJsonField("licenseProcessingState", this.licenseProcessingState);
        jsonWriter.writeStringField("mail", this.mail);
        jsonWriter.writeBooleanField("mailEnabled", this.mailEnabled);
        jsonWriter.writeStringField("mailNickname", this.mailNickname);
        jsonWriter.writeStringField("membershipRule", this.membershipRule);
        jsonWriter.writeStringField("membershipRuleProcessingState", this.membershipRuleProcessingState);
        jsonWriter.writeStringField("onPremisesDomainName", this.onPremisesDomainName);
        jsonWriter.writeStringField("onPremisesLastSyncDateTime",
            this.onPremisesLastSyncDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.onPremisesLastSyncDateTime));
        jsonWriter.writeStringField("onPremisesNetBiosName", this.onPremisesNetBiosName);
        jsonWriter.writeArrayField("onPremisesProvisioningErrors", this.onPremisesProvisioningErrors,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("onPremisesSamAccountName", this.onPremisesSamAccountName);
        jsonWriter.writeStringField("onPremisesSecurityIdentifier", this.onPremisesSecurityIdentifier);
        jsonWriter.writeBooleanField("onPremisesSyncEnabled", this.onPremisesSyncEnabled);
        jsonWriter.writeStringField("preferredDataLocation", this.preferredDataLocation);
        jsonWriter.writeStringField("preferredLanguage", this.preferredLanguage);
        jsonWriter.writeArrayField("proxyAddresses", this.proxyAddresses,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("renewedDateTime",
            this.renewedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.renewedDateTime));
        jsonWriter.writeBooleanField("securityEnabled", this.securityEnabled);
        jsonWriter.writeStringField("securityIdentifier", this.securityIdentifier);
        jsonWriter.writeStringField("theme", this.theme);
        jsonWriter.writeStringField("visibility", this.visibility);
        jsonWriter.writeBooleanField("allowExternalSenders", this.allowExternalSenders);
        jsonWriter.writeBooleanField("autoSubscribeNewMembers", this.autoSubscribeNewMembers);
        jsonWriter.writeBooleanField("hideFromAddressLists", this.hideFromAddressLists);
        jsonWriter.writeBooleanField("hideFromOutlookClients", this.hideFromOutlookClients);
        jsonWriter.writeBooleanField("isSubscribedByMail", this.isSubscribedByMail);
        jsonWriter.writeNumberField("unseenCount", this.unseenCount);
        jsonWriter.writeBooleanField("isArchived", this.isArchived);
        jsonWriter.writeArrayField("appRoleAssignments", this.appRoleAssignments,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("createdOnBehalfOf", this.createdOnBehalfOf);
        jsonWriter.writeArrayField("memberOf", this.memberOf, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("members", this.members, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("membersWithLicenseErrors", this.membersWithLicenseErrors,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("owners", this.owners, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("permissionGrants", this.permissionGrants,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("settings", this.settings, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("transitiveMemberOf", this.transitiveMemberOf,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("transitiveMembers", this.transitiveMembers,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("acceptedSenders", this.acceptedSenders,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("calendar", this.calendar);
        jsonWriter.writeArrayField("calendarView", this.calendarView, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("conversations", this.conversations, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("events", this.events, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("photo", this.photo);
        jsonWriter.writeArrayField("photos", this.photos, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("rejectedSenders", this.rejectedSenders,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("threads", this.threads, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("drive", this.drive);
        jsonWriter.writeArrayField("drives", this.drives, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("sites", this.sites, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("groupLifecyclePolicies", this.groupLifecyclePolicies,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("planner", this.planner);
        jsonWriter.writeJsonField("onenote", this.onenote);
        jsonWriter.writeJsonField("team", this.team);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphGroupInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphGroupInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphGroupInner.
     */
    public static MicrosoftGraphGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphGroupInner deserializedMicrosoftGraphGroupInner = new MicrosoftGraphGroupInner();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.withId(reader.getString());
                } else if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.withDeletedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("assignedLabels".equals(fieldName)) {
                    List<MicrosoftGraphAssignedLabel> assignedLabels
                        = reader.readArray(reader1 -> MicrosoftGraphAssignedLabel.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.assignedLabels = assignedLabels;
                } else if ("assignedLicenses".equals(fieldName)) {
                    List<MicrosoftGraphAssignedLicense> assignedLicenses
                        = reader.readArray(reader1 -> MicrosoftGraphAssignedLicense.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.assignedLicenses = assignedLicenses;
                } else if ("classification".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.classification = reader.getString();
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.description = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.displayName = reader.getString();
                } else if ("expirationDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.expirationDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("groupTypes".equals(fieldName)) {
                    List<String> groupTypes = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphGroupInner.groupTypes = groupTypes;
                } else if ("hasMembersWithLicenseErrors".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.hasMembersWithLicenseErrors
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("licenseProcessingState".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.licenseProcessingState
                        = MicrosoftGraphLicenseProcessingState.fromJson(reader);
                } else if ("mail".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.mail = reader.getString();
                } else if ("mailEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.mailEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("mailNickname".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.mailNickname = reader.getString();
                } else if ("membershipRule".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.membershipRule = reader.getString();
                } else if ("membershipRuleProcessingState".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.membershipRuleProcessingState = reader.getString();
                } else if ("onPremisesDomainName".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.onPremisesDomainName = reader.getString();
                } else if ("onPremisesLastSyncDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.onPremisesLastSyncDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("onPremisesNetBiosName".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.onPremisesNetBiosName = reader.getString();
                } else if ("onPremisesProvisioningErrors".equals(fieldName)) {
                    List<MicrosoftGraphOnPremisesProvisioningError> onPremisesProvisioningErrors
                        = reader.readArray(reader1 -> MicrosoftGraphOnPremisesProvisioningError.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
                } else if ("onPremisesSamAccountName".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.onPremisesSamAccountName = reader.getString();
                } else if ("onPremisesSecurityIdentifier".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.onPremisesSecurityIdentifier = reader.getString();
                } else if ("onPremisesSyncEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.onPremisesSyncEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("preferredDataLocation".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.preferredDataLocation = reader.getString();
                } else if ("preferredLanguage".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.preferredLanguage = reader.getString();
                } else if ("proxyAddresses".equals(fieldName)) {
                    List<String> proxyAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphGroupInner.proxyAddresses = proxyAddresses;
                } else if ("renewedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.renewedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("securityEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.securityEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("securityIdentifier".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.securityIdentifier = reader.getString();
                } else if ("theme".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.theme = reader.getString();
                } else if ("visibility".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.visibility = reader.getString();
                } else if ("allowExternalSenders".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.allowExternalSenders
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("autoSubscribeNewMembers".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.autoSubscribeNewMembers
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("hideFromAddressLists".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.hideFromAddressLists
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("hideFromOutlookClients".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.hideFromOutlookClients
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("isSubscribedByMail".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.isSubscribedByMail
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("unseenCount".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.unseenCount = reader.getNullable(JsonReader::getInt);
                } else if ("isArchived".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.isArchived = reader.getNullable(JsonReader::getBoolean);
                } else if ("appRoleAssignments".equals(fieldName)) {
                    List<MicrosoftGraphAppRoleAssignment> appRoleAssignments
                        = reader.readArray(reader1 -> MicrosoftGraphAppRoleAssignment.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.appRoleAssignments = appRoleAssignments;
                } else if ("createdOnBehalfOf".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.createdOnBehalfOf
                        = MicrosoftGraphDirectoryObjectInner.fromJson(reader);
                } else if ("memberOf".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> memberOf
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.memberOf = memberOf;
                } else if ("members".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> members
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.members = members;
                } else if ("membersWithLicenseErrors".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> membersWithLicenseErrors
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.membersWithLicenseErrors = membersWithLicenseErrors;
                } else if ("owners".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> owners
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.owners = owners;
                } else if ("permissionGrants".equals(fieldName)) {
                    List<MicrosoftGraphResourceSpecificPermissionGrant> permissionGrants
                        = reader.readArray(reader1 -> MicrosoftGraphResourceSpecificPermissionGrant.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.permissionGrants = permissionGrants;
                } else if ("settings".equals(fieldName)) {
                    List<MicrosoftGraphGroupSetting> settings
                        = reader.readArray(reader1 -> MicrosoftGraphGroupSetting.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.settings = settings;
                } else if ("transitiveMemberOf".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.transitiveMemberOf = transitiveMemberOf;
                } else if ("transitiveMembers".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> transitiveMembers
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.transitiveMembers = transitiveMembers;
                } else if ("acceptedSenders".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> acceptedSenders
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.acceptedSenders = acceptedSenders;
                } else if ("calendar".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.calendar = MicrosoftGraphCalendar.fromJson(reader);
                } else if ("calendarView".equals(fieldName)) {
                    List<MicrosoftGraphEvent> calendarView
                        = reader.readArray(reader1 -> MicrosoftGraphEvent.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.calendarView = calendarView;
                } else if ("conversations".equals(fieldName)) {
                    List<MicrosoftGraphConversation> conversations
                        = reader.readArray(reader1 -> MicrosoftGraphConversation.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.conversations = conversations;
                } else if ("events".equals(fieldName)) {
                    List<MicrosoftGraphEvent> events
                        = reader.readArray(reader1 -> MicrosoftGraphEvent.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.events = events;
                } else if ("photo".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.photo = MicrosoftGraphProfilePhoto.fromJson(reader);
                } else if ("photos".equals(fieldName)) {
                    List<MicrosoftGraphProfilePhoto> photos
                        = reader.readArray(reader1 -> MicrosoftGraphProfilePhoto.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.photos = photos;
                } else if ("rejectedSenders".equals(fieldName)) {
                    List<MicrosoftGraphDirectoryObjectInner> rejectedSenders
                        = reader.readArray(reader1 -> MicrosoftGraphDirectoryObjectInner.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.rejectedSenders = rejectedSenders;
                } else if ("threads".equals(fieldName)) {
                    List<MicrosoftGraphConversationThread> threads
                        = reader.readArray(reader1 -> MicrosoftGraphConversationThread.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.threads = threads;
                } else if ("drive".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.drive = MicrosoftGraphDrive.fromJson(reader);
                } else if ("drives".equals(fieldName)) {
                    List<MicrosoftGraphDrive> drives
                        = reader.readArray(reader1 -> MicrosoftGraphDrive.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.drives = drives;
                } else if ("sites".equals(fieldName)) {
                    List<MicrosoftGraphSite> sites = reader.readArray(reader1 -> MicrosoftGraphSite.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.sites = sites;
                } else if ("extensions".equals(fieldName)) {
                    List<MicrosoftGraphExtension> extensions
                        = reader.readArray(reader1 -> MicrosoftGraphExtension.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.extensions = extensions;
                } else if ("groupLifecyclePolicies".equals(fieldName)) {
                    List<MicrosoftGraphGroupLifecyclePolicy> groupLifecyclePolicies
                        = reader.readArray(reader1 -> MicrosoftGraphGroupLifecyclePolicy.fromJson(reader1));
                    deserializedMicrosoftGraphGroupInner.groupLifecyclePolicies = groupLifecyclePolicies;
                } else if ("planner".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.planner = MicrosoftGraphPlannerGroup.fromJson(reader);
                } else if ("onenote".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.onenote = MicrosoftGraphOnenote.fromJson(reader);
                } else if ("team".equals(fieldName)) {
                    deserializedMicrosoftGraphGroupInner.team = MicrosoftGraphTeamInner.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphGroupInner.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphGroupInner;
        });
    }
}
