// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * assignedLabel.
 */
@Fluent
public final class MicrosoftGraphAssignedLabel implements JsonSerializable<MicrosoftGraphAssignedLabel> {
    /*
     * The display name of the label. Read-only.
     */
    private String displayName;

    /*
     * The unique identifier of the label.
     */
    private String labelId;

    /*
     * assignedLabel
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphAssignedLabel class.
     */
    public MicrosoftGraphAssignedLabel() {
    }

    /**
     * Get the displayName property: The display name of the label. Read-only.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the label. Read-only.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphAssignedLabel object itself.
     */
    public MicrosoftGraphAssignedLabel withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the labelId property: The unique identifier of the label.
     * 
     * @return the labelId value.
     */
    public String labelId() {
        return this.labelId;
    }

    /**
     * Set the labelId property: The unique identifier of the label.
     * 
     * @param labelId the labelId value to set.
     * @return the MicrosoftGraphAssignedLabel object itself.
     */
    public MicrosoftGraphAssignedLabel withLabelId(String labelId) {
        this.labelId = labelId;
        return this;
    }

    /**
     * Get the additionalProperties property: assignedLabel.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: assignedLabel.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAssignedLabel object itself.
     */
    public MicrosoftGraphAssignedLabel withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("labelId", this.labelId);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphAssignedLabel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphAssignedLabel if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphAssignedLabel.
     */
    public static MicrosoftGraphAssignedLabel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphAssignedLabel deserializedMicrosoftGraphAssignedLabel = new MicrosoftGraphAssignedLabel();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphAssignedLabel.displayName = reader.getString();
                } else if ("labelId".equals(fieldName)) {
                    deserializedMicrosoftGraphAssignedLabel.labelId = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphAssignedLabel.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphAssignedLabel;
        });
    }
}
