/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.PermissionInner;
import com.azure.resourcemanager.authorization.fluent.models.RoleDefinitionProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class RoleDefinitionInner
implements JsonSerializable<RoleDefinitionInner> {
    private String id;
    private String name;
    private String type;
    private RoleDefinitionProperties innerProperties;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    private RoleDefinitionProperties innerProperties() {
        return this.innerProperties;
    }

    public String roleName() {
        return this.innerProperties() == null ? null : this.innerProperties().roleName();
    }

    public RoleDefinitionInner withRoleName(String roleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleDefinitionProperties();
        }
        this.innerProperties().withRoleName(roleName);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public RoleDefinitionInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleDefinitionProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String roleType() {
        return this.innerProperties() == null ? null : this.innerProperties().roleType();
    }

    public RoleDefinitionInner withRoleType(String roleType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleDefinitionProperties();
        }
        this.innerProperties().withRoleType(roleType);
        return this;
    }

    public List<PermissionInner> permissions() {
        return this.innerProperties() == null ? null : this.innerProperties().permissions();
    }

    public RoleDefinitionInner withPermissions(List<PermissionInner> permissions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleDefinitionProperties();
        }
        this.innerProperties().withPermissions(permissions);
        return this;
    }

    public List<String> assignableScopes() {
        return this.innerProperties() == null ? null : this.innerProperties().assignableScopes();
    }

    public RoleDefinitionInner withAssignableScopes(List<String> assignableScopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleDefinitionProperties();
        }
        this.innerProperties().withAssignableScopes(assignableScopes);
        return this;
    }

    public OffsetDateTime createdOn() {
        return this.innerProperties() == null ? null : this.innerProperties().createdOn();
    }

    public OffsetDateTime updatedOn() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedOn();
    }

    public String createdBy() {
        return this.innerProperties() == null ? null : this.innerProperties().createdBy();
    }

    public String updatedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedBy();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RoleDefinitionInner fromJson(JsonReader jsonReader) throws IOException {
        return (RoleDefinitionInner)jsonReader.readObject(reader -> {
            RoleDefinitionInner deserializedRoleDefinitionInner = new RoleDefinitionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRoleDefinitionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRoleDefinitionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRoleDefinitionInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRoleDefinitionInner.innerProperties = RoleDefinitionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleDefinitionInner;
        });
    }
}

