/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphManagedAppPolicy
extends MicrosoftGraphEntity {
    private OffsetDateTime createdDateTime;
    private String description;
    private String displayName;
    private OffsetDateTime lastModifiedDateTime;
    private String version;
    private Map<String, Object> additionalProperties;

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public MicrosoftGraphManagedAppPolicy withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public String description() {
        return this.description;
    }

    public MicrosoftGraphManagedAppPolicy withDescription(String description) {
        this.description = description;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphManagedAppPolicy withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphManagedAppPolicy withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    public String version() {
        return this.version;
    }

    public MicrosoftGraphManagedAppPolicy withVersion(String version) {
        this.version = version;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphManagedAppPolicy withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphManagedAppPolicy withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeStringField("version", this.version);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphManagedAppPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphManagedAppPolicy)jsonReader.readObject(reader -> {
            MicrosoftGraphManagedAppPolicy deserializedMicrosoftGraphManagedAppPolicy = new MicrosoftGraphManagedAppPolicy();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppPolicy.withId(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppPolicy.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppPolicy.description = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppPolicy.displayName = reader.getString();
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppPolicy.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedMicrosoftGraphManagedAppPolicy.version = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphManagedAppPolicy.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphManagedAppPolicy;
        });
    }
}

