// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Ticket Info of the role assignment.
 */
@Fluent
public final class RoleAssignmentScheduleRequestPropertiesTicketInfo
    implements JsonSerializable<RoleAssignmentScheduleRequestPropertiesTicketInfo> {
    /*
     * Ticket number for the role assignment
     */
    private String ticketNumber;

    /*
     * Ticket system name for the role assignment
     */
    private String ticketSystem;

    /**
     * Creates an instance of RoleAssignmentScheduleRequestPropertiesTicketInfo class.
     */
    public RoleAssignmentScheduleRequestPropertiesTicketInfo() {
    }

    /**
     * Get the ticketNumber property: Ticket number for the role assignment.
     * 
     * @return the ticketNumber value.
     */
    public String ticketNumber() {
        return this.ticketNumber;
    }

    /**
     * Set the ticketNumber property: Ticket number for the role assignment.
     * 
     * @param ticketNumber the ticketNumber value to set.
     * @return the RoleAssignmentScheduleRequestPropertiesTicketInfo object itself.
     */
    public RoleAssignmentScheduleRequestPropertiesTicketInfo withTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
        return this;
    }

    /**
     * Get the ticketSystem property: Ticket system name for the role assignment.
     * 
     * @return the ticketSystem value.
     */
    public String ticketSystem() {
        return this.ticketSystem;
    }

    /**
     * Set the ticketSystem property: Ticket system name for the role assignment.
     * 
     * @param ticketSystem the ticketSystem value to set.
     * @return the RoleAssignmentScheduleRequestPropertiesTicketInfo object itself.
     */
    public RoleAssignmentScheduleRequestPropertiesTicketInfo withTicketSystem(String ticketSystem) {
        this.ticketSystem = ticketSystem;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ticketNumber", this.ticketNumber);
        jsonWriter.writeStringField("ticketSystem", this.ticketSystem);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleAssignmentScheduleRequestPropertiesTicketInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleAssignmentScheduleRequestPropertiesTicketInfo if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleAssignmentScheduleRequestPropertiesTicketInfo.
     */
    public static RoleAssignmentScheduleRequestPropertiesTicketInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleAssignmentScheduleRequestPropertiesTicketInfo deserializedRoleAssignmentScheduleRequestPropertiesTicketInfo
                = new RoleAssignmentScheduleRequestPropertiesTicketInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ticketNumber".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestPropertiesTicketInfo.ticketNumber = reader.getString();
                } else if ("ticketSystem".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestPropertiesTicketInfo.ticketSystem = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleAssignmentScheduleRequestPropertiesTicketInfo;
        });
    }
}
